/*
 * Decompiled with CFR 0.152.
 */
package thredds.server.ncSubset.controller;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import thredds.server.ncSubset.controller.SupportedFormat;
import thredds.server.ncSubset.exception.UnsupportedResponseFormatException;

enum SupportedOperation {
    DATASET_INFO_REQUEST("Dataset info request", Collections.unmodifiableList(Arrays.asList(SupportedFormat.XML)), SupportedFormat.XML),
    POINT_REQUEST("Grid as Point data request", Collections.unmodifiableList(Arrays.asList(SupportedFormat.XML, SupportedFormat.CSV, SupportedFormat.NETCDF)), SupportedFormat.XML),
    GRID_REQUEST("Grid data request", Collections.unmodifiableList(Arrays.asList(SupportedFormat.NETCDF)), SupportedFormat.NETCDF);

    private final String operationName;
    private final List<SupportedFormat> supportedFormats;
    private final SupportedFormat defaultFormat;

    private SupportedOperation(String operationName, List<SupportedFormat> supportedFormats, SupportedFormat defaultFormat) {
        this.operationName = operationName;
        this.supportedFormats = supportedFormats;
        this.defaultFormat = defaultFormat;
    }

    String getOperation() {
        return this.operationName;
    }

    List<SupportedFormat> getSupportedFormats() {
        return this.supportedFormats;
    }

    SupportedFormat getDefaultFormat() {
        return this.defaultFormat;
    }

    public static SupportedFormat isSupportedFormat(String format, SupportedOperation operation) throws UnsupportedResponseFormatException {
        int cont;
        List<SupportedFormat> supportedFormats = operation.getSupportedFormats();
        int len = supportedFormats.size();
        boolean found = false;
        for (cont = 0; !found && cont < len; ++cont) {
            if (!supportedFormats.get(cont).getAliases().contains(format)) continue;
            found = true;
        }
        if (found) {
            return supportedFormats.get(cont - 1);
        }
        throw new UnsupportedResponseFormatException("Format " + format + " is not supported for " + operation.getOperation());
    }
}

