/*
 * Decompiled with CFR 0.152.
 */
package thredds.server.ncSubset;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.Random;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;
import org.jdom.transform.XSLTransformer;
import thredds.server.ncSubset.GridPointWriter;
import thredds.server.ncSubset.QueryParams;
import thredds.servlet.AbstractServlet;
import thredds.servlet.DatasetHandler;
import thredds.servlet.ServletUtil;
import thredds.servlet.ThreddsConfig;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.Range;
import ucar.nc2.constants.CDM;
import ucar.nc2.dataset.CoordinateAxis1D;
import ucar.nc2.dt.GridCoordSystem;
import ucar.nc2.dt.GridDataset;
import ucar.nc2.dt.GridDatatype;
import ucar.nc2.dt.grid.GridDatasetInfo;
import ucar.nc2.dt.grid.NetcdfCFWriter;
import ucar.nc2.time.CalendarDateRange;
import ucar.nc2.util.DiskCache2;
import ucar.nc2.util.Misc;
import ucar.unidata.geoloc.LatLonPoint;
import ucar.unidata.geoloc.LatLonRect;

public class GridServlet
extends AbstractServlet {
    private DiskCache2 diskCache = null;
    private boolean allow = false;
    private boolean debug = false;
    private static String context = "/thredds";
    private static String servletPath = "/ncss/grid";
    private static String servletCachePath = "/ncServer/cache";

    public static void setContextPath(String c) {
        context = c;
    }

    protected String getContextPath() {
        return context;
    }

    public static void setServletPath(String path) {
        servletPath = path;
    }

    protected String buildDatasetUrl(String path) {
        return context + servletPath + "/" + path;
    }

    public static void setServletCachePath(String path) {
        servletCachePath = path;
    }

    protected String buildCacheUrl(String path) {
        return context + servletCachePath + "/" + path;
    }

    @Override
    protected String getPath() {
        return servletPath.substring(1) + "/";
    }

    @Override
    protected void makeDebugActions() {
    }

    @Override
    public void init() throws ServletException {
        super.init();
        this.allow = ThreddsConfig.getBoolean("NetcdfSubsetService.allow", false);
        this.logServerStartup.error("NetcdfSubsetService:allow= " + this.allow);
        if (!this.allow) {
            return;
        }
        String cache = ThreddsConfig.get("NetcdfSubsetService.dir", ServletUtil.getContentPath() + "cache/ncss/");
        File cacheDir = new File(cache);
        if (!cacheDir.exists() && !cacheDir.mkdirs()) {
            this.logServerStartup.error("Cant make cache directory " + cache);
            throw new IllegalArgumentException("Cant make cache directory " + cache);
        }
        int scourSecs = ThreddsConfig.getSeconds("NetcdfSubsetService.scour", 600);
        int maxAgeSecs = ThreddsConfig.getSeconds("NetcdfSubsetService.maxAge", -1);
        maxAgeSecs = Math.max(maxAgeSecs, 300);
        scourSecs = Math.max(scourSecs, 300);
        this.diskCache = new DiskCache2(cache, false, maxAgeSecs / 60, scourSecs / 60);
        this.logServerStartup.info(((Object)((Object)this)).getClass().getName() + "Ncss.Cache= " + cache + " scour = " + scourSecs + " maxAgeSecs = " + maxAgeSecs);
        this.logServerStartup.info(((Object)((Object)this)).getClass().getName() + " initialization done -  ");
    }

    public void destroy() {
        this.logServerStartup.info(((Object)((Object)this)).getClass().getName() + " destroy start -  ");
        if (this.diskCache != null) {
            this.diskCache.exit();
        }
        super.destroy();
        this.logServerStartup.info(((Object)((Object)this)).getClass().getName() + " destroy done -  ");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        if (!this.allow) {
            res.sendError(403, "Service not supported");
            return;
        }
        String pathInfo = req.getPathInfo();
        if (pathInfo == null) {
            res.sendError(404);
            return;
        }
        boolean wantXML = pathInfo.endsWith("/dataset.xml");
        boolean showForm = pathInfo.endsWith("/dataset.html");
        boolean showPointForm = pathInfo.endsWith("/pointDataset.html");
        if (wantXML || showForm || showPointForm) {
            int len = pathInfo.length();
            if (wantXML) {
                pathInfo = pathInfo.substring(0, len - 12);
            } else if (showForm) {
                pathInfo = pathInfo.substring(0, len - 13);
            } else if (showPointForm) {
                pathInfo = pathInfo.substring(0, len - 18);
            }
            if (pathInfo.startsWith("/")) {
                pathInfo = pathInfo.substring(1);
            }
            GridDataset gds = null;
            try {
                gds = DatasetHandler.openGridDataset(req, res, pathInfo);
                if (null == gds) {
                    res.sendError(404);
                    return;
                }
                this.showForm(res, gds, pathInfo, wantXML, showPointForm);
            }
            catch (FileNotFoundException ioe) {
                if (!res.isCommitted()) {
                    res.sendError(404);
                }
            }
            catch (Throwable e) {
                this.log.error("GridServlet.showForm", e);
                if (!res.isCommitted()) {
                    res.sendError(500);
                }
            }
            finally {
                if (null != gds) {
                    try {
                        gds.close();
                    }
                    catch (IOException ioe) {
                        this.log.error("Failed to close = " + pathInfo);
                    }
                }
            }
            return;
        }
        String point = ServletUtil.getParameterIgnoreCase(req, "point");
        if (point != null && point.equalsIgnoreCase("true")) {
            this.processGridAsPoint(req, res, pathInfo);
            return;
        }
        this.processGrid(req, res, pathInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processGridAsPoint(HttpServletRequest req, HttpServletResponse res, String pathInfo) throws IOException {
        long start;
        block60: {
            start = System.currentTimeMillis();
            GridDataset gds = null;
            try {
                QueryParams qp;
                block59: {
                    qp = new QueryParams();
                    if (!qp.parseQuery(req, res, new String[]{"text/csv", "application/xml", "application/x-netcdf"})) {
                        return;
                    }
                    gds = DatasetHandler.openGridDataset(req, res, pathInfo);
                    if (null == gds) {
                        res.sendError(404);
                        return;
                    }
                    if (qp.vars == null || qp.vars.size() == 0) {
                        qp.errs.append("No Grid variables selected\n");
                        qp.writeErr(req, res, qp.errs.toString(), 400);
                        return;
                    }
                    if (qp.vars != null) {
                        int count = 0;
                        StringBuilder buff = new StringBuilder();
                        for (String varName : qp.vars) {
                            if (null != gds.findGridDatatype(varName)) continue;
                            buff.append(varName);
                            if (count > 0) {
                                buff.append(";");
                            }
                            ++count;
                        }
                        if (buff.length() != 0) {
                            qp.errs.append("Grid variable(s) not found in dataset=" + buff + "\n");
                            qp.writeErr(req, res, qp.errs.toString(), 400);
                            return;
                        }
                    } else {
                        qp.errs.append("You must specify at least one variable\n");
                        qp.writeErr(req, res, qp.errs.toString(), 400);
                        return;
                    }
                    if (qp.hasLatlonPoint) {
                        LatLonPoint pt;
                        LatLonRect bb = gds.getBoundingBox();
                        if (!bb.contains(pt = qp.getPoint())) {
                            qp.errs.append("Requested Lat/Lon Point (+" + pt + ") is not contained in the Data\n" + "Data Bounding Box = " + bb.toString2() + "\n");
                            qp.writeErr(req, res, qp.errs.toString(), 400);
                            return;
                        }
                    } else {
                        qp.errs.append("Must specify a Lat/Lon Point\n");
                        qp.writeErr(req, res, qp.errs.toString(), 400);
                        return;
                    }
                    GridPointWriter writer = new GridPointWriter(gds, this.diskCache);
                    String contentType = qp.acceptType;
                    if (qp.acceptType.equals("text/csv")) {
                        contentType = "text/plain";
                    }
                    res.setContentType(contentType);
                    try {
                        if (qp.acceptType.equals("application/x-netcdf")) break block59;
                        writer.write(qp, res.getWriter());
                        if (this.debug) {
                            long took = System.currentTimeMillis() - start;
                            System.out.println("\ntotal response took = " + took + " msecs");
                        }
                        return;
                    }
                    catch (InvalidRangeException e) {
                        if (!res.isCommitted()) {
                            res.sendError(400, "Invalid Lat/Lon or Time Range");
                        }
                        break block60;
                    }
                }
                this.sendPointFile(req, res, gds, qp);
            }
            catch (Throwable e) {
                System.err.println("GridServlet.processGridAsPoint req=" + req.getRequestURI());
                e.printStackTrace();
                this.log.error("GridServlet.processGridAsPoint", e);
                if (!res.isCommitted()) {
                    res.sendError(500);
                }
            }
            finally {
                if (null != gds) {
                    try {
                        gds.close();
                    }
                    catch (IOException ioe) {
                        this.log.error("Failed to close = " + pathInfo);
                    }
                }
            }
        }
        if (this.debug) {
            long took = System.currentTimeMillis() - start;
            System.out.println("\ntotal response took = " + took + " msecs");
        }
    }

    private void sendPointFile(HttpServletRequest req, HttpServletResponse res, GridDataset gds, QueryParams qp) throws IOException, InvalidRangeException {
        File result;
        String filename = req.getRequestURI();
        int pos = filename.lastIndexOf("/");
        if (!(filename = filename.substring(pos + 1)).endsWith(".nc")) {
            filename = filename + ".nc";
        }
        Random random = new Random(System.currentTimeMillis());
        int randomInt = random.nextInt();
        String pathname = Integer.toString(randomInt) + "/" + filename;
        File ncFile = this.diskCache.getCacheFile(pathname);
        String cacheFilename = ncFile.getPath();
        String url = this.buildCacheUrl(pathname);
        try {
            GridPointWriter writer = new GridPointWriter(gds, this.diskCache);
            PrintWriter pw = !qp.acceptType.equals("application/x-netcdf") ? res.getWriter() : null;
            result = writer.write(qp, pw);
        }
        catch (Throwable ioe) {
            this.log.error("Writing to " + cacheFilename, ioe);
            if (!res.isCommitted()) {
                res.sendError(500, ioe.getMessage());
            }
            return;
        }
        res.addHeader("Content-Location", url);
        res.setHeader("Content-Disposition", "attachment; filename=\"" + filename + "\"");
        ServletUtil.returnFile(this, req, res, result, "application/x-netcdf");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processGrid(HttpServletRequest req, HttpServletResponse res, String pathInfo) throws IOException {
        long start = System.currentTimeMillis();
        GridDataset gds = null;
        try {
            QueryParams qp = new QueryParams();
            if (!qp.parseQuery(req, res, new String[]{"application/x-netcdf"})) {
                return;
            }
            gds = DatasetHandler.openGridDataset(req, res, pathInfo);
            if (null == gds) {
                res.sendError(404, "Cant find " + pathInfo);
                return;
            }
            if (qp.vars == null || qp.vars.size() == 0) {
                qp.errs.append("No Grid variables selected\n");
                qp.writeErr(req, res, qp.errs.toString(), 400);
                return;
            }
            if (qp.vars != null) {
                int count = 0;
                StringBuilder buff = new StringBuilder();
                for (String varName : qp.vars) {
                    if (null != gds.findGridDatatype(varName)) continue;
                    buff.append(varName);
                    if (count > 0) {
                        buff.append(";");
                    }
                    ++count;
                }
                if (buff.length() != 0) {
                    qp.errs.append("Grid variable(s) not found in dataset=" + buff + "\n");
                    qp.writeErr(req, res, qp.errs.toString(), 400);
                    return;
                }
            }
            if (qp.hasDateRange) {
                CalendarDateRange dr = qp.getCalendarDateRange();
                if (dr.getStart().isAfter(dr.getEnd())) {
                    qp.errs.append("Request Time range start > end\nRequest Time range = " + dr.toString() + "\n");
                    qp.writeErr(req, res, qp.errs.toString(), 400);
                    return;
                }
                if (dr.getStart().isAfter(gds.getCalendarDateEnd()) || dr.getEnd().isBefore(gds.getCalendarDateStart())) {
                    qp.errs.append("RequestTime range does not intersect the Data\nData Time Range = " + gds.getStartDate() + " to " + gds.getEndDate() + "\n");
                    qp.writeErr(req, res, qp.errs.toString(), 400);
                    return;
                }
            }
            boolean hasBB = false;
            if (qp.hasBB) {
                LatLonRect maxBB = gds.getBoundingBox();
                boolean bl = hasBB = !Misc.closeEnough((double)qp.north, (double)maxBB.getUpperRightPoint().getLatitude()) || !Misc.closeEnough((double)qp.south, (double)maxBB.getLowerLeftPoint().getLatitude()) || !Misc.closeEnough((double)qp.east, (double)maxBB.getUpperRightPoint().getLongitude()) || !Misc.closeEnough((double)qp.west, (double)maxBB.getLowerLeftPoint().getLongitude());
                if (maxBB.intersect(qp.getBB()) == null) {
                    qp.errs.append("Request Bounding Box does not intersect the Data\nData Bounding Box = " + maxBB.toString2() + "\n");
                    qp.writeErr(req, res, qp.errs.toString(), 400);
                    return;
                }
            }
            Range zRange = null;
            if (qp.hasVerticalCoord) {
                for (String varName : qp.vars) {
                    GridDatatype grid = gds.findGridDatatype(varName);
                    GridCoordSystem gcs = grid.getCoordinateSystem();
                    CoordinateAxis1D vaxis = gcs.getVerticalAxis();
                    if (vaxis == null || vaxis.getSize() <= 1L) continue;
                    int bestIndex = -1;
                    double bestDiff = Double.MAX_VALUE;
                    int i = 0;
                    while ((long)i < vaxis.getSize()) {
                        double diff = Math.abs(vaxis.getCoordValue(i) - qp.vertCoord);
                        if (diff < bestDiff) {
                            bestIndex = i;
                            bestDiff = diff;
                        }
                        ++i;
                    }
                    if (bestIndex < 0) break;
                    zRange = new Range(bestIndex, bestIndex);
                    break;
                }
            }
            boolean addLatLon = ServletUtil.getParameterIgnoreCase(req, "addLatLon") != null;
            try {
                this.makeGridFile(req, res, gds, qp, hasBB, addLatLon, zRange);
            }
            catch (InvalidRangeException e) {
                res.sendError(400, "Invalid Lat/Lon or Time Range: " + e.getMessage());
            }
        }
        catch (Throwable e) {
            this.log.error("GridServlet.processGrid", e);
            if (!res.isCommitted()) {
                res.sendError(500);
            }
        }
        finally {
            if (null != gds) {
                try {
                    gds.close();
                }
                catch (IOException ioe) {
                    this.log.error("Failed to close = " + pathInfo);
                }
            }
        }
        if (this.log.isDebugEnabled()) {
            long took = System.currentTimeMillis() - start;
            this.log.debug(" total response took = " + took + " msecs");
        }
    }

    private void makeGridFile(HttpServletRequest req, HttpServletResponse res, GridDataset gds, QueryParams qp, boolean useBB, boolean addLatLon, Range zRange) throws IOException, InvalidRangeException {
        String filename = req.getRequestURI();
        int pos = filename.lastIndexOf("/");
        if (!(filename = filename.substring(pos + 1)).endsWith(".nc")) {
            filename = filename + ".nc";
        }
        Random random = new Random(System.currentTimeMillis());
        int randomInt = random.nextInt();
        String pathname = Integer.toString(randomInt) + "/" + filename;
        File ncFile = this.diskCache.getCacheFile(pathname);
        String cacheFilename = ncFile.getPath();
        String url = this.buildCacheUrl(pathname);
        try {
            NetcdfCFWriter writer = new NetcdfCFWriter();
            writer.makeFile(cacheFilename, gds, qp.vars, useBB ? qp.getBB() : null, qp.horizStride, zRange, qp.hasDateRange ? qp.getCalendarDateRange() : null, qp.timeStride, addLatLon);
        }
        catch (IllegalArgumentException e) {
            res.sendError(403, e.getMessage());
            return;
        }
        catch (Throwable ioe) {
            this.log.error("Writing to " + cacheFilename, ioe);
            if (!res.isCommitted()) {
                res.sendError(500, ioe.getMessage());
            }
            return;
        }
        res.addHeader("Content-Location", url);
        res.setHeader("Content-Disposition", "attachment; filename=\"" + filename + "\"");
        ServletUtil.returnFile(this, req, res, new File(cacheFilename), "application/x-netcdf");
    }

    private void showForm(HttpServletResponse res, GridDataset gds, String path, boolean wantXml, boolean isPoint) throws IOException {
        String infoString;
        GridDatasetInfo writer = new GridDatasetInfo(gds, "path");
        if (wantXml) {
            infoString = writer.writeXML(writer.makeDatasetDescription());
        } else {
            InputStream xslt = this.getXSLT(isPoint ? "ncssGridAsPoint.xsl" : "ncssGrid.xsl");
            Document doc = writer.makeGridForm();
            Element root = doc.getRootElement();
            root.setAttribute("location", this.buildDatasetUrl(path));
            try {
                XSLTransformer transformer = new XSLTransformer(xslt);
                Document html = transformer.transform(doc);
                XMLOutputter fmt = new XMLOutputter(Format.getPrettyFormat());
                infoString = fmt.outputString(html);
            }
            catch (Throwable e) {
                this.log.error("ForecastModelRunServlet internal error", e);
                if (!res.isCommitted()) {
                    res.sendError(500, "ForecastModelRunServlet internal error");
                }
                return;
            }
        }
        res.setContentLength(infoString.length());
        if (wantXml) {
            res.setContentType("text/xml; charset=iso-8859-1");
        } else {
            res.setContentType("text/html; charset=iso-8859-1");
        }
        ServletOutputStream out = res.getOutputStream();
        out.write(infoString.getBytes(CDM.utf8Charset));
        out.flush();
    }

    private InputStream getXSLT(String xslName) {
        return ((Object)((Object)this)).getClass().getResourceAsStream("/resources/xsl/" + xslName);
    }
}

