/*
 * Decompiled with CFR 0.152.
 */
package thredds.server.ncSubset.controller;

import java.io.FileNotFoundException;
import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;
import thredds.server.ncSubset.controller.AbstractNcssController;
import thredds.servlet.DatasetHandler;
import thredds.servlet.ThreddsConfig;
import ucar.nc2.dt.GridDataset;

public class NcssInterceptor
extends HandlerInterceptorAdapter {
    private static final Logger log = LoggerFactory.getLogger(NcssInterceptor.class);

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        boolean allow = ThreddsConfig.getBoolean("NetcdfSubsetService.allow", false);
        AbstractNcssController hm = (AbstractNcssController)((HandlerMethod)handler).getBean();
        String servletPath = request.getServletPath();
        String pathInfo = servletPath.substring(AbstractNcssController.getServletPath().length(), servletPath.length());
        if (pathInfo == null) {
            response.sendError(404);
            return false;
        }
        GridDataset gds = this.getGridDataset(request, response, pathInfo);
        hm.setRequestPathInfo(pathInfo);
        hm.setGridDataset(gds);
        return allow && gds != null;
    }

    public void postHandle(HttpServletRequest request, HttpServletResponse response, Object handler, ModelAndView modelAndView) throws Exception {
        this.closeGridDataset(handler);
    }

    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) throws Exception {
        this.closeGridDataset(handler);
    }

    private GridDataset getGridDataset(HttpServletRequest req, HttpServletResponse res, String pathInfo) throws IOException {
        GridDataset gds;
        block7: {
            gds = null;
            if (pathInfo.endsWith("xml") || pathInfo.endsWith("html")) {
                pathInfo = pathInfo.trim();
                String[] pathInfoArr = pathInfo.split("/");
                StringBuilder sb = new StringBuilder();
                int len = pathInfoArr.length;
                sb.append(pathInfoArr[1]);
                for (int i = 2; i < len - 1; ++i) {
                    sb.append("/" + pathInfoArr[i]);
                }
                pathInfo = sb.toString();
            }
            try {
                gds = DatasetHandler.openGridDataset(req, res, pathInfo);
                if (null == gds) {
                    res.sendError(404);
                }
            }
            catch (FileNotFoundException ioe) {
                if (!res.isCommitted()) {
                    res.sendError(404);
                }
            }
            catch (Throwable e) {
                log.error("GridServlet.showForm", e);
                if (res.isCommitted()) break block7;
                res.sendError(500);
            }
        }
        return gds;
    }

    private void closeGridDataset(Object handler) {
        AbstractNcssController hm = (AbstractNcssController)((HandlerMethod)handler).getBean();
        GridDataset gds = hm.getGridDataset();
        if (null != gds) {
            try {
                gds.close();
            }
            catch (IOException ioe) {
                log.error("Failed to close = " + hm.getRequestPathInfo());
            }
        }
        hm.setRequestPathInfo(null);
        hm.setGridDataset(null);
    }
}

