/*
 * Decompiled with CFR 0.152.
 */
package thredds.server.ncSubset.controller;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import thredds.server.ncSubset.exception.UnsupportedResponseFormatException;
import thredds.server.ncSubset.format.SupportedFormat;

enum SupportedOperation {
    DATASET_INFO_REQUEST("Dataset info request", Collections.unmodifiableList(Arrays.asList(SupportedFormat.XML)), SupportedFormat.XML),
    POINT_REQUEST("Grid as Point data request", Collections.unmodifiableList(Arrays.asList(SupportedFormat.XML, SupportedFormat.CSV, SupportedFormat.NETCDF3)), SupportedFormat.XML),
    GRID_REQUEST("Grid data request", Collections.unmodifiableList(Arrays.asList(SupportedFormat.NETCDF3, SupportedFormat.NETCDF4)), SupportedFormat.NETCDF3);

    private final String operationName;
    private final List<SupportedFormat> supportedFormats;
    private final SupportedFormat defaultFormat;

    private SupportedOperation(String operationName, List<SupportedFormat> supportedFormats, SupportedFormat defaultFormat) {
        this.operationName = operationName;
        this.supportedFormats = supportedFormats;
        this.defaultFormat = defaultFormat;
    }

    String getOperation() {
        return this.operationName;
    }

    List<SupportedFormat> getSupportedFormats() {
        return this.supportedFormats;
    }

    SupportedFormat getDefaultFormat() {
        return this.defaultFormat;
    }

    public static SupportedFormat isSupportedFormat(String format, SupportedOperation operation) throws UnsupportedResponseFormatException {
        int cont;
        List<SupportedFormat> supportedFormats = operation.getSupportedFormats();
        int len = supportedFormats.size();
        boolean found = false;
        for (cont = 0; !found && cont < len; ++cont) {
            if (!supportedFormats.get(cont).getAliases().contains(format) || !supportedFormats.get(cont).isAvailable()) continue;
            found = true;
        }
        if (found) {
            return supportedFormats.get(cont - 1);
        }
        throw new UnsupportedResponseFormatException("Format " + format + " is not supported for " + operation.getOperation());
    }
}

