/*
 * Decompiled with CFR 0.152.
 */
package thredds.server.ncSubset.view;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jfree.util.Log;
import org.springframework.http.HttpHeaders;
import thredds.server.ncSubset.util.NcssRequestUtils;
import thredds.server.ncSubset.view.PointDataWriter;
import ucar.nc2.dataset.CoordinateAxis1D;
import ucar.nc2.dt.GridDataset;
import ucar.nc2.dt.GridDatatype;
import ucar.nc2.dt.grid.GridAsPointDataset;
import ucar.nc2.time.CalendarDate;
import ucar.nc2.units.DateUnit;
import ucar.unidata.geoloc.LatLonPoint;

class CSVPointDataWriter
implements PointDataWriter {
    private PrintWriter printWriter;
    private List<String> allVars;
    private boolean headersSet = false;
    private HttpHeaders httpHeaders;

    private CSVPointDataWriter(OutputStream os) {
        this.printWriter = new PrintWriter(os);
    }

    public static CSVPointDataWriter createCSVPointDataWriter(OutputStream os) {
        return new CSVPointDataWriter(os);
    }

    @Override
    public boolean header(Map<String, List<String>> groupedVars, GridDataset gridDataset, List<CalendarDate> wDates, DateUnit dateUnit, LatLonPoint point) {
        ArrayList<String> keys = new ArrayList<String>(groupedVars.keySet());
        List<String> varsGroup = groupedVars.get(keys.get(0));
        this.writeGroupHeader(varsGroup, gridDataset);
        return true;
    }

    @Override
    public boolean write(Map<String, List<String>> groupedVars, GridDataset gridDataset, CalendarDate date, LatLonPoint point, Double targetLevel) {
        boolean allDone = true;
        ArrayList<String> keys = new ArrayList<String>(groupedVars.keySet());
        for (String key : keys) {
            List<String> varsGroup = groupedVars.get(key);
            GridAsPointDataset gap = NcssRequestUtils.buildGridAsPointDataset(gridDataset, varsGroup);
            CoordinateAxis1D verticalAxisForGroup = gridDataset.findGridDatatype(varsGroup.get(0)).getCoordinateSystem().getVerticalAxis();
            if (verticalAxisForGroup == null) {
                allDone = allDone && this.write(varsGroup, gridDataset, gap, date, point);
                continue;
            }
            if (targetLevel != null) {
                Double vertCoord = NcssRequestUtils.getTargetLevelForVertCoord(verticalAxisForGroup, targetLevel);
                allDone = this.write(varsGroup, gridDataset, gap, date, point, vertCoord, verticalAxisForGroup.getUnitsString());
                continue;
            }
            double[] arr$ = verticalAxisForGroup.getCoordValues();
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                Double vertCoord = arr$[i$];
                if (verticalAxisForGroup.getCoordValues().length == 1) {
                    vertCoord = NcssRequestUtils.getTargetLevelForVertCoord(verticalAxisForGroup, vertCoord);
                }
                allDone = allDone && this.write(varsGroup, gridDataset, gap, date, point, vertCoord, verticalAxisForGroup.getUnitsString());
            }
        }
        return allDone;
    }

    private void writeGroupHeader(List<String> varGroup, GridDataset gridDataset) {
        StringBuilder sb = new StringBuilder();
        sb.append("date,");
        sb.append("lat[unit=\"degrees_north\"],");
        sb.append("lon[unit=\"degrees_east\"],");
        CoordinateAxis1D zAxis = gridDataset.findGridDatatype(varGroup.get(0)).getCoordinateSystem().getVerticalAxis();
        if (zAxis != null) {
            sb.append("vertCoord[unit=\"" + zAxis.getUnitsString() + "\"],");
        }
        Iterator<String> it = varGroup.iterator();
        while (it.hasNext()) {
            GridDatatype grid = gridDataset.findGridDatatype(it.next());
            sb.append(grid.getName());
            if (grid.getUnitsString() != null) {
                sb.append("[unit=\"" + grid.getUnitsString() + "\"]");
            }
            if (!it.hasNext()) continue;
            sb.append(",");
        }
        this.printWriter.write(sb.toString());
        this.printWriter.println();
    }

    private boolean write(List<String> vars, GridDataset gridDataset, GridAsPointDataset gap, CalendarDate date, LatLonPoint point, Double targetLevel, String zUnits) {
        boolean allDone = false;
        this.printWriter.write(date.toString() + ",");
        int contVars = 0;
        Iterator<String> itVars = vars.iterator();
        try {
            while (itVars.hasNext()) {
                GridDatatype grid = gridDataset.findGridDatatype(itVars.next());
                if (gap.hasTime(grid, date) && gap.hasVert(grid, targetLevel.doubleValue())) {
                    GridAsPointDataset.Point p = gap.readData(grid, date, targetLevel.doubleValue(), point.getLatitude(), point.getLongitude());
                    if (contVars == 0) {
                        this.printWriter.write(Double.valueOf(p.lat).toString() + ",");
                        this.printWriter.write(Double.valueOf(p.lon).toString() + ",");
                        this.printWriter.write(Double.valueOf(p.z).toString() + ",");
                    }
                    this.printWriter.write(Double.valueOf(p.dataValue).toString());
                    if (itVars.hasNext()) {
                        this.printWriter.write(",");
                    }
                } else {
                    if (contVars == 0) {
                        this.printWriter.write(point.getLatitude() + ",");
                        this.printWriter.write(point.getLongitude() + ",");
                        this.printWriter.write(targetLevel + ",");
                    }
                    this.printWriter.write(Double.valueOf(gap.getMissingValue(grid)).toString());
                }
                ++contVars;
            }
            allDone = true;
        }
        catch (IOException ioe) {
            Log.error((Object)"Error reading data", (Exception)ioe);
        }
        this.printWriter.println();
        return allDone;
    }

    private boolean write(List<String> vars, GridDataset gridDataset, GridAsPointDataset gap, CalendarDate date, LatLonPoint point) {
        boolean allDone = false;
        this.printWriter.write(date.toString() + ",");
        int contVars = 0;
        Iterator<String> itVars = vars.iterator();
        try {
            while (itVars.hasNext()) {
                GridDatatype grid = gridDataset.findGridDatatype(itVars.next());
                if (gap.hasTime(grid, date)) {
                    GridAsPointDataset.Point p = gap.readData(grid, date, point.getLatitude(), point.getLongitude());
                    if (contVars == 0) {
                        this.printWriter.write(Double.valueOf(p.lat).toString() + ",");
                        this.printWriter.write(Double.valueOf(p.lon).toString() + ",");
                    }
                    this.printWriter.write(Double.valueOf(p.dataValue).toString());
                    if (itVars.hasNext()) {
                        this.printWriter.write(",");
                    }
                } else {
                    if (contVars == 0) {
                        this.printWriter.write(point.getLatitude() + ",");
                        this.printWriter.write(point.getLongitude() + ",");
                    }
                    this.printWriter.write(Double.valueOf(gap.getMissingValue(grid)).toString());
                }
                ++contVars;
            }
            allDone = true;
        }
        catch (IOException ioe) {
            Log.error((Object)"Error reading data", (Exception)ioe);
        }
        this.printWriter.println();
        return allDone;
    }

    @Override
    public boolean trailer() {
        this.printWriter.flush();
        return true;
    }

    @Override
    public HttpHeaders getResponseHeaders() {
        return this.httpHeaders;
    }

    @Override
    public void setHTTPHeaders(GridDataset gridDataset) {
        if (!this.headersSet) {
            this.httpHeaders = new HttpHeaders();
            String filename = gridDataset.getLocationURI();
            int pos = filename.lastIndexOf("/");
            if (!(filename = filename.substring(pos + 1)).endsWith(".csv")) {
                filename = filename + ".csv";
            }
            this.httpHeaders.set("Content-Location", filename);
            this.httpHeaders.set("Content-Disposition", "attachment; filename=\"" + filename + "\"");
            this.headersSet = true;
        }
    }
}

