/*
 * Decompiled with CFR 0.152.
 */
package thredds.server.ncSubset.view.netcdf;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import thredds.server.ncSubset.dataservice.StructureDataFactory;
import thredds.server.ncSubset.util.NcssRequestUtils;
import thredds.server.ncSubset.view.netcdf.CFPointWriterWrapper;
import ucar.ma2.StructureData;
import ucar.nc2.Attribute;
import ucar.nc2.VariableSimpleIF;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dt.GridDataset;
import ucar.nc2.dt.GridDatatype;
import ucar.nc2.dt.grid.GridAsPointDataset;
import ucar.nc2.ft.point.writer.WriterCFStationCollection;
import ucar.nc2.time.CalendarDate;
import ucar.nc2.units.DateUnit;
import ucar.unidata.geoloc.LatLonPoint;
import ucar.unidata.geoloc.StationImpl;

public final class WriterCFStationCollectionWrapper
implements CFPointWriterWrapper {
    private static Logger log = LoggerFactory.getLogger(WriterCFStationCollectionWrapper.class);
    private WriterCFStationCollection writerCFStationCollection;
    private GridAsPointDataset gap;

    private WriterCFStationCollectionWrapper() {
    }

    private WriterCFStationCollectionWrapper(String filePath, List<Attribute> atts) throws IOException {
        this.writerCFStationCollection = new WriterCFStationCollection(filePath, atts);
    }

    @Override
    public boolean header(Map<String, List<String>> groupedVars, GridDataset gridDataset, List<CalendarDate> wDates, DateUnit dateUnit, LatLonPoint point) {
        boolean headerDone = false;
        String stnName = "GridPoint";
        String desc = "Grid Point at lat/lon=" + point.getLatitude() + "," + point.getLongitude();
        StationImpl s = new StationImpl(stnName, desc, "", point.getLatitude(), point.getLongitude(), Double.NaN);
        ArrayList<StationImpl> stnList = new ArrayList<StationImpl>();
        stnList.add(s);
        NetcdfDataset ncfile = (NetcdfDataset)gridDataset.getNetcdfFile();
        List<String> vars = new ArrayList<List<String>>(groupedVars.values()).get(0);
        this.gap = NcssRequestUtils.buildGridAsPointDataset(gridDataset, vars);
        List<VariableSimpleIF> wantedVars = NcssRequestUtils.wantedVars2VariableSimple(vars, gridDataset, ncfile);
        try {
            this.writerCFStationCollection.writeHeader(stnList, wantedVars, dateUnit, "");
            headerDone = true;
        }
        catch (IOException ioe) {
            log.error("Error writing header", (Throwable)ioe);
        }
        return headerDone;
    }

    @Override
    public boolean write(Map<String, List<String>> groupedVars, GridDataset gridDataset, CalendarDate date, LatLonPoint point, Double targetLevel) {
        boolean allDone = false;
        List<String> vars = new ArrayList<List<String>>(groupedVars.values()).get(0);
        StructureData sdata = StructureDataFactory.getFactory().createSingleStructureData(gridDataset, point, vars);
        sdata.findMember("date").getDataArray().setObject(0, (Object)date.toString());
        Iterator<String> itVars = vars.iterator();
        int cont = 0;
        try {
            while (itVars.hasNext()) {
                String varName = itVars.next();
                GridDatatype grid = gridDataset.findGridDatatype(varName);
                if (this.gap.hasTime(grid, date)) {
                    GridAsPointDataset.Point p = this.gap.readData(grid, date, point.getLatitude(), point.getLongitude());
                    sdata.findMember("lat").getDataArray().setDouble(0, p.lat);
                    sdata.findMember("lon").getDataArray().setDouble(0, p.lon);
                    sdata.findMember(varName).getDataArray().setDouble(0, p.dataValue);
                } else {
                    sdata.findMember("lat").getDataArray().setDouble(0, point.getLatitude());
                    sdata.findMember("lon").getDataArray().setDouble(0, point.getLongitude());
                    sdata.findMember(varName).getDataArray().setDouble(0, this.gap.getMissingValue(grid));
                }
                ++cont;
            }
            Double timeCoordValue = NcssRequestUtils.getTimeCoordValue(gridDataset.findGridDatatype(vars.get(0)), date);
            this.writerCFStationCollection.writeRecord((String)sdata.findMember("station").getDataArray().getObject(0), timeCoordValue.doubleValue(), date, sdata);
            allDone = true;
        }
        catch (IOException ioe) {
            log.error("Error writing data", (Throwable)ioe);
        }
        return allDone;
    }

    @Override
    public boolean trailer() {
        boolean finished = false;
        try {
            this.writerCFStationCollection.finish();
            finished = true;
        }
        catch (IOException ioe) {
            log.error("Error finishing  WriterCFStationCollection" + ioe);
        }
        return finished;
    }

    public static WriterCFStationCollectionWrapper createWrapper(String filePath, List<Attribute> atts) throws IOException {
        return new WriterCFStationCollectionWrapper(filePath, atts);
    }
}

