/*
 * Decompiled with CFR 0.152.
 */
package thredds.server.ncSubset.format;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import thredds.server.ncSubset.format.Netcdf4AvailabilityChecker;

public enum SupportedFormat {
    CSV("CSV", true, "text/plain", "text/csv", "csv"),
    XML("XML", true, "application/xml", "text/xml", "xml"),
    NETCDF3("NETCDF3", true, "application/x-netcdf", "netcdf"),
    NETCDF4("NETCDF4", Netcdf4AvailabilityChecker.isNetcdf4Available(), "application/x-netcdf4", "netcdf4");

    private final List<String> aliases;
    private final String formatName;
    private final boolean available;

    private SupportedFormat(String formatName, boolean available, String ... aliases) {
        this.formatName = formatName;
        this.available = available;
        ArrayList<String> aliasesList = new ArrayList<String>();
        for (String alias : aliases) {
            aliasesList.add(alias);
        }
        this.aliases = Collections.unmodifiableList(aliasesList);
    }

    public String getFormatName() {
        return this.formatName;
    }

    public boolean isAvailable() {
        return this.available;
    }

    public List<String> getAliases() {
        return this.aliases;
    }

    public String getResponseContentType() {
        return this.aliases.get(0);
    }
}

