/*
 * Decompiled with CFR 0.152.
 */
package thredds.server.ncSubset.view.netcdf;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import thredds.server.ncSubset.dataservice.StructureDataFactory;
import thredds.server.ncSubset.util.NcssRequestUtils;
import thredds.server.ncSubset.view.netcdf.CFPointWriterWrapper;
import ucar.ma2.StructureData;
import ucar.nc2.Attribute;
import ucar.nc2.NetcdfFileWriter;
import ucar.nc2.VariableSimpleIF;
import ucar.nc2.dataset.CoordinateAxis1D;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dt.GridDataset;
import ucar.nc2.dt.GridDatatype;
import ucar.nc2.dt.grid.GridAsPointDataset;
import ucar.nc2.ft.point.writer.WriterCFPointCollection;
import ucar.nc2.time.CalendarDate;
import ucar.nc2.units.DateUnit;
import ucar.unidata.geoloc.EarthLocationImpl;
import ucar.unidata.geoloc.LatLonPoint;

public final class WriterCFPointCollectionWrapper
implements CFPointWriterWrapper {
    private static Logger log = LoggerFactory.getLogger(WriterCFPointCollectionWrapper.class);
    private WriterCFPointCollection writerCFPointCollection;
    private GridAsPointDataset gap;

    private WriterCFPointCollectionWrapper() {
    }

    private WriterCFPointCollectionWrapper(NetcdfFileWriter.Version version, String filePath, List<Attribute> atts) throws IOException {
        this.writerCFPointCollection = new WriterCFPointCollection(version, filePath, atts);
    }

    @Override
    public boolean header(Map<String, List<String>> groupedVars, GridDataset gridDataset, List<CalendarDate> wDates, DateUnit dateUnit, LatLonPoint point, Double vertCoord) {
        boolean headerDone = false;
        ArrayList<Attribute> atts = new ArrayList<Attribute>();
        atts.add(new Attribute("title", "Extract Points data from Grid file " + gridDataset.getLocationURI()));
        NetcdfDataset ncfile = (NetcdfDataset)gridDataset.getNetcdfFile();
        List<String> vars = new ArrayList<List<String>>(groupedVars.values()).get(0);
        this.gap = NcssRequestUtils.buildGridAsPointDataset(gridDataset, vars);
        List<VariableSimpleIF> wantedVars = NcssRequestUtils.wantedVars2VariableSimple(vars, gridDataset, ncfile);
        CoordinateAxis1D zAxis = gridDataset.findGridDatatype(vars.get(0)).getCoordinateSystem().getVerticalAxis();
        try {
            this.writerCFPointCollection.writeHeader(wantedVars, dateUnit, zAxis.getUnitsString());
            headerDone = true;
        }
        catch (IOException ioe) {
            log.error("Error writing header", (Throwable)ioe);
        }
        return headerDone;
    }

    @Override
    public boolean write(Map<String, List<String>> groupedVars, GridDataset gridDataset, CalendarDate date, LatLonPoint point, Double requestLevel) {
        boolean allDone = false;
        List<String> vars = new ArrayList<List<String>>(groupedVars.values()).get(0);
        CoordinateAxis1D zAxis = gridDataset.findGridDatatype(vars.get(0)).getCoordinateSystem().getVerticalAxis();
        double[] targetLevels = zAxis.getCoordValues();
        if (zAxis.getCoordValues().length == 1) {
            targetLevels[0] = 0.0;
        }
        if (requestLevel != null) {
            targetLevels = new double[]{requestLevel};
        }
        try {
            for (double targetLevel : targetLevels) {
                StructureData sdata = StructureDataFactory.getFactory().createSingleStructureData(gridDataset, point, vars, zAxis.getUnitsString());
                Double timeCoordValue = NcssRequestUtils.getTimeCoordValue(gridDataset.findGridDatatype(vars.get(0)), date);
                sdata.findMember("time").getDataArray().setDouble(0, timeCoordValue.doubleValue());
                EarthLocationImpl earthLocation = null;
                int cont = 0;
                for (String varName : vars) {
                    GridDatatype grid = gridDataset.findGridDatatype(varName);
                    if (this.gap.hasTime(grid, date) && this.gap.hasVert(grid, targetLevel)) {
                        GridAsPointDataset.Point p = this.gap.readData(grid, date, targetLevel, point.getLatitude(), point.getLongitude());
                        sdata.findMember("lat").getDataArray().setDouble(0, p.lat);
                        sdata.findMember("lon").getDataArray().setDouble(0, p.lon);
                        sdata.findMember("vertCoord").getDataArray().setDouble(0, p.z);
                        sdata.findMember(varName).getDataArray().setDouble(0, p.dataValue);
                        if (cont == 0) {
                            earthLocation = new EarthLocationImpl(p.lat, p.lon, p.z);
                        }
                    } else {
                        sdata.findMember("lat").getDataArray().setDouble(0, point.getLatitude());
                        sdata.findMember("lon").getDataArray().setDouble(0, point.getLongitude());
                        sdata.findMember("vertCoord").getDataArray().setDouble(0, targetLevel);
                        sdata.findMember(varName).getDataArray().setDouble(0, this.gap.getMissingValue(grid));
                        earthLocation = new EarthLocationImpl(point.getLatitude(), point.getLongitude(), targetLevel);
                    }
                    ++cont;
                }
                this.writerCFPointCollection.writeRecord(timeCoordValue.doubleValue(), date, earthLocation, sdata);
                allDone = true;
            }
        }
        catch (IOException ioe) {
            log.error("Error writing data", (Throwable)ioe);
        }
        return allDone;
    }

    public static WriterCFPointCollectionWrapper createWrapper(String filePath, List<Attribute> atts) throws IOException {
        return new WriterCFPointCollectionWrapper(null, filePath, atts);
    }

    @Override
    public boolean trailer() {
        boolean finished = false;
        try {
            this.writerCFPointCollection.finish();
            finished = true;
        }
        catch (IOException ioe) {
            log.error("Error finishing  WriterCFPointCollection" + ioe);
        }
        return finished;
    }
}

