/*
 * Decompiled with CFR 0.152.
 */
package thredds.server.ncSubset.view.netcdf;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import thredds.server.ncSubset.dataservice.StructureDataFactory;
import thredds.server.ncSubset.util.NcssRequestUtils;
import thredds.server.ncSubset.view.netcdf.CFPointWriterWrapper;
import thredds.server.ncSubset.view.netcdf.WriterCFTimeSeriesProfileCollection;
import ucar.ma2.StructureData;
import ucar.nc2.Attribute;
import ucar.nc2.NetcdfFileWriter;
import ucar.nc2.dataset.CoordinateAxis1D;
import ucar.nc2.dt.GridDataset;
import ucar.nc2.dt.GridDatatype;
import ucar.nc2.dt.grid.GridAsPointDataset;
import ucar.nc2.time.CalendarDate;
import ucar.nc2.units.DateUnit;
import ucar.unidata.geoloc.EarthLocation;
import ucar.unidata.geoloc.EarthLocationImpl;
import ucar.unidata.geoloc.LatLonPoint;
import ucar.unidata.geoloc.Station;
import ucar.unidata.geoloc.StationImpl;

public final class WriterCFTimeSeriesProfileCollectionWrapper
implements CFPointWriterWrapper {
    private static Logger log = LoggerFactory.getLogger(WriterCFTimeSeriesProfileCollectionWrapper.class);
    private WriterCFTimeSeriesProfileCollection writerCFTimeSeriesProfileCollection;

    private WriterCFTimeSeriesProfileCollectionWrapper(NetcdfFileWriter.Version version, String filePath, List<Attribute> atts) throws IOException {
        this.writerCFTimeSeriesProfileCollection = new WriterCFTimeSeriesProfileCollection(version, filePath, atts);
    }

    @Override
    public boolean header(Map<String, List<String>> groupedVars, GridDataset gds, List<CalendarDate> wDates, DateUnit dateUnit, LatLonPoint point, Double vertCoord) {
        boolean headerDone = false;
        ArrayList<Attribute> atts = new ArrayList<Attribute>();
        atts.add(new Attribute("title", "Extract time series profiles data from Grid file " + gds.getLocationURI()));
        String stnName = "Grid Point";
        String desc = "Grid Point at lat/lon=" + point.getLatitude() + "," + point.getLongitude();
        StationImpl s = new StationImpl(stnName, desc, "", point.getLatitude(), point.getLongitude(), Double.NaN);
        ArrayList<Station> stnList = new ArrayList<Station>();
        stnList.add((Station)s);
        try {
            this.writerCFTimeSeriesProfileCollection.writeHeader(stnList, groupedVars, gds, dateUnit, wDates.size(), vertCoord);
            headerDone = true;
        }
        catch (IOException ioe) {
            log.error("Error writing header", (Throwable)ioe);
        }
        return headerDone;
    }

    @Override
    public boolean write(Map<String, List<String>> groupedVars, GridDataset gridDataset, CalendarDate date, LatLonPoint point, Double targetLevel) {
        boolean allDone = false;
        ArrayList<String> keys = new ArrayList<String>(groupedVars.keySet());
        try {
            for (String key : keys) {
                List<String> varsGroup = groupedVars.get(key);
                CoordinateAxis1D ensAxis = gridDataset.findGridDatatype(varsGroup.get(0)).getCoordinateSystem().getEnsembleAxis();
                double[] ensCoords = new double[]{-1.0};
                if (ensAxis != null) {
                    ensCoords = ensAxis.getCoordValues();
                }
                int ensIdx = 0;
                for (double ensCoord : ensCoords) {
                    if (ensCoord >= 0.0) {
                        this.writerCFTimeSeriesProfileCollection.writeEnsCoord(ensIdx, ensCoord);
                        ++ensIdx;
                    }
                    CoordinateAxis1D zAxis = gridDataset.findGridDatatype(varsGroup.get(0)).getCoordinateSystem().getVerticalAxis();
                    EarthLocationImpl earthLocation = null;
                    GridAsPointDataset gap = NcssRequestUtils.buildGridAsPointDataset(gridDataset, varsGroup);
                    Double timeCoordValue = NcssRequestUtils.getTimeCoordValue(gridDataset.findGridDatatype(varsGroup.get(0)), date);
                    if (zAxis == null) {
                        StructureData sdata = StructureDataFactory.getFactory().createSingleStructureData(gridDataset, point, varsGroup);
                        sdata.findMember("time").getDataArray().setDouble(0, timeCoordValue.doubleValue());
                        gap = NcssRequestUtils.buildGridAsPointDataset(gridDataset, varsGroup);
                        Iterator<String> itVars = varsGroup.iterator();
                        boolean cont = false;
                        while (itVars.hasNext()) {
                            String varName = itVars.next();
                            GridDatatype grid = gridDataset.findGridDatatype(varName);
                            if (gap.hasTime(grid, date)) {
                                GridAsPointDataset.Point p = gap.readData(grid, date, ensCoord, -1.0, point.getLatitude(), point.getLongitude());
                                sdata.findMember(varName).getDataArray().setDouble(0, p.dataValue);
                                if (cont) continue;
                                earthLocation = new EarthLocationImpl(p.lat, p.lon, Double.NaN);
                                continue;
                            }
                            sdata.findMember(varName).getDataArray().setDouble(0, gap.getMissingValue(grid));
                            earthLocation = new EarthLocationImpl(point.getLatitude(), point.getLongitude(), Double.NaN);
                        }
                        if (ensCoord >= 0.0) {
                            this.writerCFTimeSeriesProfileCollection.writeRecord(timeCoordValue, ensCoord, date, (EarthLocation)earthLocation, sdata);
                            continue;
                        }
                        this.writerCFTimeSeriesProfileCollection.writeRecord(timeCoordValue, date, (EarthLocation)earthLocation, sdata);
                        continue;
                    }
                    String profileName = zAxis.getShortName();
                    double[] vertCoords = new double[]{0.0};
                    int vertCoordsIndex = 0;
                    if (targetLevel != null) {
                        vertCoords[0] = targetLevel;
                        vertCoordsIndex = zAxis.findCoordElementBounded(targetLevel.doubleValue());
                    } else if (zAxis.getCoordValues().length > 1) {
                        vertCoords = zAxis.getCoordValues();
                    }
                    int vertCoordsIndexForFile = 0;
                    for (double vertLevel : vertCoords) {
                        StructureData sdata = StructureDataFactory.getFactory().createSingleStructureData(gridDataset, point, varsGroup, zAxis);
                        sdata.findMember("time").getDataArray().setDouble(0, timeCoordValue.doubleValue());
                        sdata.findMember(zAxis.getShortName()).getDataArray().setDouble(0, zAxis.getCoordValues()[vertCoordsIndex]);
                        ++vertCoordsIndex;
                        ++vertCoordsIndexForFile;
                        int cont = 0;
                        for (String varName : varsGroup) {
                            GridDatatype grid = gridDataset.findGridDatatype(varName);
                            if (gap.hasTime(grid, date) && gap.hasVert(grid, vertLevel)) {
                                GridAsPointDataset.Point p = gap.readData(grid, date, ensCoord, vertLevel, point.getLatitude(), point.getLongitude());
                                sdata.findMember(varName).getDataArray().setDouble(0, p.dataValue);
                                if (cont == 0) {
                                    earthLocation = new EarthLocationImpl(p.lat, p.lon, p.z);
                                }
                            } else {
                                sdata.findMember(varName).getDataArray().setDouble(0, gap.getMissingValue(grid));
                                earthLocation = new EarthLocationImpl(point.getLatitude(), point.getLongitude(), vertLevel);
                            }
                            ++cont;
                        }
                        if (ensCoord >= 0.0) {
                            this.writerCFTimeSeriesProfileCollection.writeRecord(profileName, timeCoordValue, ensCoord, date, (EarthLocation)earthLocation, sdata, vertCoordsIndexForFile - 1);
                        } else {
                            this.writerCFTimeSeriesProfileCollection.writeRecord(profileName, timeCoordValue, date, (EarthLocation)earthLocation, sdata, vertCoordsIndexForFile - 1);
                        }
                        allDone = true;
                    }
                }
            }
        }
        catch (IOException ioe) {
            log.error("Error writing data", (Throwable)ioe);
        }
        return allDone;
    }

    @Override
    public boolean trailer() {
        boolean allDone = false;
        try {
            this.writerCFTimeSeriesProfileCollection.finish();
            allDone = true;
        }
        catch (IOException ioe) {
            log.error("Error finishing  WriterCFTimeSeriesProfileCollection: " + ioe);
        }
        return allDone;
    }

    public static WriterCFTimeSeriesProfileCollectionWrapper createWrapper(NetcdfFileWriter.Version version, String filePath, List<Attribute> atts) throws IOException {
        return new WriterCFTimeSeriesProfileCollectionWrapper(version, filePath, atts);
    }
}

