/*
 * Decompiled with CFR 0.152.
 */
package thredds.server.config;

import java.io.File;
import java.util.Calendar;
import java.util.Timer;
import java.util.TimerTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import thredds.catalog.parser.jdom.InvCatalogFactory10;
import thredds.inventory.CollectionManagerAbstract;
import thredds.inventory.CollectionUpdater;
import thredds.inventory.MController;
import thredds.inventory.bdb.MetadataManager;
import thredds.server.config.FormatsAvailabilityService;
import thredds.server.config.TdsContext;
import thredds.server.ncSubset.format.SupportedFormat;
import thredds.servlet.ServletUtil;
import thredds.servlet.ThreddsConfig;
import ucar.nc2.NetcdfFile;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.grib.GribCollection;
import ucar.nc2.grib.TimePartition;
import ucar.nc2.iosp.grid.GridServiceProvider;
import ucar.nc2.jni.netcdf.Nc4Iosp;
import ucar.nc2.ncml.Aggregation;
import ucar.nc2.thredds.ThreddsDataFactory;
import ucar.nc2.util.DiskCache;
import ucar.nc2.util.DiskCache2;
import ucar.nc2.util.cache.FileCache;

@Component
public class CdmInit
implements InitializingBean,
DisposableBean {
    private static Logger startupLog = LoggerFactory.getLogger((String)"serverStartup");
    private DiskCache2 aggCache;
    private DiskCache2 gribCache;
    private Timer timer;
    private MController cacheManager;
    @Autowired
    private TdsContext tdsContext;

    public void afterPropertiesSet() {
        boolean extendIndex;
        ThreddsDataFactory.setPreferCdm((boolean)true);
        String gribIndexDir = ThreddsConfig.get("GribIndex.dir", new File(this.tdsContext.getContentDirectory().getPath(), "/cache/grib/").getPath());
        Boolean gribIndexAlwaysUse = ThreddsConfig.getBoolean("GribIndex.alwaysUse", false);
        String gribIndexPolicy = ThreddsConfig.get("GribIndex.policy", null);
        int gribIndexScourSecs = ThreddsConfig.getSeconds("GribIndex.scour", 0);
        int gribIndexMaxAgeSecs = ThreddsConfig.getSeconds("GribIndex.maxAge", 7776000);
        this.gribCache = new DiskCache2(gribIndexDir, false, gribIndexMaxAgeSecs / 60, gribIndexScourSecs / 60);
        this.gribCache.setPolicy(gribIndexPolicy);
        this.gribCache.setAlwaysUseCache(gribIndexAlwaysUse.booleanValue());
        GribCollection.setDiskCache2((DiskCache2)this.gribCache);
        startupLog.info("CdmInit: GribIndex=" + this.gribCache);
        String fcCache = ThreddsConfig.get("FeatureCollection.dir", null);
        if (fcCache == null) {
            fcCache = ThreddsConfig.get("FeatureCollection.cacheDirectory", this.tdsContext.getContentDirectory().getPath() + "/cache/collection/");
        }
        long maxSizeBytes = ThreddsConfig.getBytes("FeatureCollection.maxSize", 0L);
        int jvmPercent = ThreddsConfig.getInt("FeatureCollection.jvmPercent", 2);
        try {
            MetadataManager.setCacheDirectory((String)fcCache, (long)maxSizeBytes, (int)jvmPercent);
            CollectionManagerAbstract.enableMetadataManager();
            startupLog.info("CdmInit: FeatureCollection.cacheDirectory= " + fcCache);
        }
        catch (Exception e) {
            startupLog.error("CdmInit: Failed to open FeatureCollection.cacheDirectory= " + fcCache, (Throwable)e);
        }
        boolean useBytesForDataSize = ThreddsConfig.getBoolean("catalogWriting.useBytesForDataSize", false);
        InvCatalogFactory10.useBytesForDataSize((boolean)useBytesForDataSize);
        startupLog.info("CdmInit: catalogWriting.useBytesForDataSize= " + useBytesForDataSize);
        int min = ThreddsConfig.getInt("NetcdfFileCache.minFiles", 50);
        int max = ThreddsConfig.getInt("NetcdfFileCache.maxFiles", 100);
        int secs = ThreddsConfig.getSeconds("NetcdfFileCache.scour", 660);
        if (max > 0) {
            NetcdfDataset.initNetcdfFileCache((int)min, (int)max, (int)secs);
            startupLog.info("CdmInit  private boolean isNetcdf4Available = false;: NetcdfDataset.initNetcdfFileCache= [" + min + "," + max + "] scour = " + secs);
        }
        min = ThreddsConfig.getInt("TimePartition.minFiles", 50);
        max = ThreddsConfig.getInt("TimePartition.maxFiles", 100);
        secs = ThreddsConfig.getSeconds("TimePartition.scour", 720);
        if (max > 0) {
            TimePartition.initPartitionCache((int)min, (int)max, (int)secs);
            startupLog.info("CdmInit: TimePartition.initPartitionCache= [" + min + "," + max + "] scour = " + secs);
        }
        min = ThreddsConfig.getInt("GribCollection.minFiles", 50);
        max = ThreddsConfig.getInt("GribCollection.maxFiles", 100);
        secs = ThreddsConfig.getSeconds("GribCollection.scour", 780);
        if (max > 0) {
            GribCollection.initDataRafCache((int)min, (int)max, (int)secs);
            startupLog.info("CdmInit: GribCollection.initDataRafCache= [" + min + "," + max + "] scour = " + secs);
        }
        min = ThreddsConfig.getInt("HTTPFileCache.minFiles", 10);
        max = ThreddsConfig.getInt("HTTPFileCache.maxFiles", 20);
        secs = ThreddsConfig.getSeconds("HTTPFileCache.scour", 1020);
        if (max > 0) {
            ServletUtil.setFileCache(new FileCache("HTTP File Cache", min, max, -1, secs));
            startupLog.info("CdmInit: HTTPFileCache.initCache= [" + min + "," + max + "] scour = " + secs);
        }
        GridServiceProvider.IndexExtendMode mode = (extendIndex = ThreddsConfig.getBoolean("GribIndexing.setExtendIndex", false)) ? GridServiceProvider.IndexExtendMode.extendwrite : GridServiceProvider.IndexExtendMode.readonly;
        GridServiceProvider.setIndexFileModeOnOpen((GridServiceProvider.IndexExtendMode)mode);
        GridServiceProvider.setIndexFileModeOnSync((GridServiceProvider.IndexExtendMode)mode);
        startupLog.info("CdmInit: GridServiceProvider.IndexExtendMode= " + mode);
        boolean alwaysUseCache = ThreddsConfig.getBoolean("GribIndexing.alwaysUseCache", false);
        GridServiceProvider.setIndexAlwaysInCache((boolean)alwaysUseCache);
        startupLog.info("CdmInit: GribIndexing.alwaysUseCache= " + alwaysUseCache);
        NetcdfFile.setProperty((String)"syncExtendOnly", (String)"true");
        String dir = ThreddsConfig.get("AggregationCache.dir", new File(this.tdsContext.getContentDirectory().getPath(), "/cache/agg/").getPath());
        int scourSecs = ThreddsConfig.getSeconds("AggregationCache.scour", 86400);
        int maxAgeSecs = ThreddsConfig.getSeconds("AggregationCache.maxAge", 7776000);
        this.aggCache = new DiskCache2(dir, false, maxAgeSecs / 60, scourSecs / 60);
        Aggregation.setPersistenceCache((DiskCache2)this.aggCache);
        startupLog.info("CdmInit:  AggregationCache= " + dir + " scour = " + scourSecs + " maxAgeSecs = " + maxAgeSecs);
        String typicalDataset = ThreddsConfig.get("Aggregation.typicalDataset", "penultimate");
        Aggregation.setTypicalDatasetMode((String)typicalDataset);
        startupLog.info("CdmInit: Aggregation.setTypicalDatasetMode= " + typicalDataset);
        dir = ThreddsConfig.get("DiskCache.dir", new File(this.tdsContext.getContentDirectory(), "/cache/cdm/").getPath());
        boolean alwaysUse = ThreddsConfig.getBoolean("DiskCache.alwaysUse", false);
        scourSecs = ThreddsConfig.getSeconds("DiskCache.scour", 3600);
        long maxSize = ThreddsConfig.getBytes("DiskCache.maxSize", 1000000000L);
        DiskCache.setRootDirectory((String)dir);
        DiskCache.setCachePolicy((boolean)alwaysUse);
        startupLog.info("CdmInit:  CdmCache= " + dir + " scour = " + scourSecs + " maxSize = " + maxSize);
        if (scourSecs > 0) {
            Calendar c = Calendar.getInstance();
            c.add(13, scourSecs / 2);
            this.timer = new Timer("CdmDiskCache");
            this.timer.scheduleAtFixedRate((TimerTask)new CacheScourTask(maxSize), c.getTime(), 1000L * (long)scourSecs);
        }
        String libraryPath = ThreddsConfig.get("Netcdf4Clibrary.libraryPath", null);
        String libraryName = ThreddsConfig.get("Netcdf4Clibrary.libraryName", null);
        if (libraryPath != null || libraryName != null) {
            Nc4Iosp.setLibraryAndPath((String)libraryPath, (String)libraryName);
        }
        if (!Nc4Iosp.isClibraryPresent()) {
            startupLog.warn("netcdf4 c library not present jna_path='" + libraryPath + "' libname=" + libraryName + "");
        } else {
            FormatsAvailabilityService.setFormatAvailability(SupportedFormat.NETCDF4, true);
            if (libraryName == null) {
                libraryName = "netcdf";
            }
            startupLog.info("netcdf4 c library loaded from jna_path='" + System.getProperty("jna.library.path") + "' libname=" + libraryName + "");
        }
        startupLog.info("CdmInit complete");
    }

    public void destroy() throws Exception {
        if (this.timer != null) {
            this.timer.cancel();
        }
        FileCache.shutdown();
        if (this.aggCache != null) {
            this.aggCache.exit();
        }
        if (this.gribCache != null) {
            this.gribCache.exit();
        }
        if (this.cacheManager != null) {
            this.cacheManager.close();
        }
        MetadataManager.closeAll();
        CollectionUpdater.INSTANCE.shutdown();
        startupLog.info("CdmInit shutdown");
        MDC.clear();
    }

    private class CacheScourTask
    extends TimerTask {
        long maxBytes;

        CacheScourTask(long maxBytes) {
            this.maxBytes = maxBytes;
        }

        @Override
        public void run() {
            StringBuilder sbuff = new StringBuilder();
            DiskCache.cleanCache((long)this.maxBytes, (StringBuilder)sbuff);
            sbuff.append("----------------------\n");
        }
    }
}

