/*
 * Decompiled with CFR 0.152.
 */
package thredds.server.ncSubset.dataservice;

import java.io.IOException;
import java.io.InputStream;
import javax.servlet.ServletContext;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamSource;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;
import org.jdom.transform.JDOMResult;
import org.jdom.transform.JDOMSource;
import org.jdom.xpath.XPath;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.web.context.ServletContextAware;
import org.springframework.web.context.support.ServletContextResource;
import thredds.server.config.FormatsAvailabilityService;
import thredds.server.ncSubset.dataservice.NcssShowDatasetInfo;
import thredds.server.ncSubset.format.SupportedFormat;
import ucar.nc2.dt.GridDataset;
import ucar.nc2.dt.grid.GridDatasetInfo;

@Service
public class NcssShowDatasetInfoImpl
implements NcssShowDatasetInfo,
ServletContextAware {
    private static final Logger log = LoggerFactory.getLogger(NcssShowDatasetInfoImpl.class);
    private ServletContext servletContext;

    @Override
    public String showForm(GridDataset gds, String datsetUrlPath, boolean wantXml, boolean isPoint) {
        boolean isNetcdf4Availalbe = FormatsAvailabilityService.isFormatAvailable(SupportedFormat.NETCDF4);
        String infoString = null;
        GridDatasetInfo writer = new GridDatasetInfo(gds, "path");
        Document datsetDescription = null;
        if (wantXml) {
            datsetDescription = writer.makeDatasetDescription();
            if (isNetcdf4Availalbe) {
                this.addNetcdf4Format(datsetDescription, "/gridDataset");
            }
            infoString = writer.writeXML(datsetDescription);
        } else {
            try {
                InputStream xslt = this.getXSLT(isPoint ? "/WEB-INF/xsl/ncssGridAsPoint.xsl" : "/WEB-INF/xsl/ncssGrid.xsl");
                Document doc = writer.makeGridForm();
                if (isNetcdf4Availalbe) {
                    this.addNetcdf4Format(doc, "/gridForm");
                }
                Element root = doc.getRootElement();
                root.setAttribute("location", datsetUrlPath);
                Transformer xslTransformer = TransformerFactory.newInstance().newTransformer(new StreamSource(xslt));
                String context = this.servletContext.getContextPath();
                xslTransformer.setParameter("tdsContext", context);
                JDOMSource in = new JDOMSource(doc);
                JDOMResult out = new JDOMResult();
                xslTransformer.transform((Source)in, (Result)out);
                Document html = out.getDocument();
                XMLOutputter fmt = new XMLOutputter(Format.getPrettyFormat());
                infoString = fmt.outputString(html);
            }
            catch (IOException ioe) {
                log.error("IO error opening xsl", (Throwable)ioe);
            }
            catch (Throwable e) {
                log.error("ForecastModelRunServlet internal error", e);
            }
        }
        return infoString;
    }

    private InputStream getXSLT(String xslName) throws IOException {
        ServletContextResource r = new ServletContextResource(this.servletContext, xslName);
        return r.getInputStream();
    }

    public void setServletContext(ServletContext servletContext) {
        this.servletContext = servletContext;
    }

    private void addNetcdf4Format(Document datasetDescriptionDoc, String rootElementName) {
        String xPathForGridElement = rootElementName + "/AcceptList/Grid";
        this.addElement(datasetDescriptionDoc, xPathForGridElement, new Element("accept").addContent("netcdf4"));
        String xPathForGridAsPointElement = rootElementName + "/AcceptList/GridAsPoint";
        this.addElement(datasetDescriptionDoc, xPathForGridAsPointElement, new Element("accept").addContent("netcdf4"));
    }

    private void addElement(Document datasetDescriptionDoc, String xPath, Element element) {
        try {
            XPath gridXpath = XPath.newInstance((String)xPath);
            Element acceptListParent = (Element)gridXpath.selectSingleNode((Object)datasetDescriptionDoc);
            acceptListParent.addContent((Content)element);
        }
        catch (JDOMException e) {
            // empty catch block
        }
    }
}

