/*
 * Decompiled with CFR 0.152.
 */
package thredds.server.ncSubset.dataservice;

import java.util.ArrayList;
import java.util.List;
import ucar.ma2.Array;
import ucar.ma2.ArrayDouble;
import ucar.ma2.ArrayObject;
import ucar.ma2.DataType;
import ucar.ma2.StructureData;
import ucar.ma2.StructureDataW;
import ucar.ma2.StructureMembers;
import ucar.nc2.dataset.CoordinateAxis1D;
import ucar.nc2.dt.GridDataset;
import ucar.nc2.dt.GridDatatype;
import ucar.unidata.geoloc.LatLonPoint;
import ucar.unidata.geoloc.StationImpl;

public final class StructureDataFactory {
    private static StructureDataFactory INSTANCE;

    private StructureDataFactory() {
    }

    public static StructureDataFactory getFactory() {
        if (INSTANCE == null) {
            INSTANCE = new StructureDataFactory();
        }
        return INSTANCE;
    }

    public StructureData createStructureDataWithVerticalLevels(GridDataset gds, LatLonPoint point, List<String> vars, List<Double> vertLevels, int arrLen, CoordinateAxis1D zAxis) {
        StructureMembers members = new StructureMembers("");
        int vertLevelsLen = vertLevels.size();
        int[] dimShape = new int[1];
        int[] dataShape = new int[2];
        int[] coordsShape = new int[3];
        StructureMembers.Member timeMember = members.addMember("date", null, null, DataType.STRING, dimShape);
        ArrayObject.D1 timeData = new ArrayObject.D1(String.class, arrLen);
        timeMember.setDataArray((Array)timeData);
        StructureMembers.Member vertCoordMember = members.addMember("vertCoord", null, zAxis.getUnitsString(), DataType.DOUBLE, coordsShape);
        ArrayDouble.D3 vertData = new ArrayDouble.D3(arrLen, vertLevelsLen, vars.size());
        vertCoordMember.setDataArray((Array)vertData);
        StructureMembers.Member latMember = members.addMember("lat", null, "degrees_north", DataType.DOUBLE, coordsShape);
        ArrayDouble.D3 latData = new ArrayDouble.D3(arrLen, vertLevelsLen, vars.size());
        latMember.setDataArray((Array)latData);
        StructureMembers.Member lonMember = members.addMember("lon", null, "degrees_east", DataType.DOUBLE, coordsShape);
        ArrayDouble.D3 lonData = new ArrayDouble.D3(arrLen, vertLevelsLen, vars.size());
        lonMember.setDataArray((Array)lonData);
        StructureDataW sdata = new StructureDataW(members);
        sdata.setMemberData(timeMember, (Array)timeData);
        sdata.setMemberData(vertCoordMember, (Array)timeData);
        sdata.setMemberData(latMember, (Array)latData);
        sdata.setMemberData(lonMember, (Array)lonData);
        for (String varName : vars) {
            GridDatatype grid = gds.findGridDatatype(varName);
            StructureMembers.Member m = members.addMember(grid.getVariable().getShortName(), null, grid.getUnitsString(), grid.getDataType(), dataShape);
            ArrayDouble.D2 data = new ArrayDouble.D2(arrLen, vertLevelsLen);
            m.setDataArray((Array)data);
            sdata.setMemberData(m, (Array)data);
        }
        return sdata;
    }

    public StructureData createStructureData(GridDataset gds, LatLonPoint point, List<String> vars, int arrLen) {
        StructureMembers members = new StructureMembers("");
        int[] dataShape = new int[1];
        ArrayObject.D0 stnData = new ArrayObject.D0(String.class);
        StructureMembers.Member timeMember = members.addMember("date", null, null, DataType.STRING, dataShape);
        ArrayObject.D1 timeData = new ArrayObject.D1(String.class, arrLen);
        timeMember.setDataArray((Array)timeData);
        StructureMembers.Member latMember = members.addMember("lat", null, "degrees_north", DataType.DOUBLE, dataShape);
        ArrayDouble.D1 latData = new ArrayDouble.D1(arrLen);
        latMember.setDataArray((Array)latData);
        StructureMembers.Member lonMember = members.addMember("lon", null, "degrees_east", DataType.DOUBLE, dataShape);
        ArrayDouble.D1 lonData = new ArrayDouble.D1(arrLen);
        lonMember.setDataArray((Array)lonData);
        StructureDataW sdata = new StructureDataW(members);
        sdata.setMemberData(timeMember, (Array)timeData);
        sdata.setMemberData(latMember, (Array)latData);
        sdata.setMemberData(lonMember, (Array)lonData);
        String stnName = "GridPoint";
        String desc = "Grid Point at lat/lon=" + point.getLatitude() + "," + point.getLongitude();
        StationImpl s = new StationImpl(stnName, desc, "", point.getLatitude(), point.getLongitude(), Double.NaN);
        ArrayList<StationImpl> stnList = new ArrayList<StationImpl>();
        stnList.add(s);
        stnData.set((Object)stnName);
        for (String varName : vars) {
            GridDatatype grid = gds.findGridDatatype(varName);
            StructureMembers.Member m = members.addMember(grid.getVariable().getShortName(), null, grid.getUnitsString(), grid.getDataType(), dataShape);
            ArrayDouble.D1 data = new ArrayDouble.D1(arrLen);
            m.setDataArray((Array)data);
            sdata.setMemberData(m, (Array)data);
        }
        return sdata;
    }

    public StructureData createSingleStructureData(GridDataset gds, LatLonPoint point, List<String> vars, boolean hasTime) {
        StructureMembers members = new StructureMembers("");
        int[] scalarShape = new int[]{};
        StructureMembers.Member stnMember = members.addMember("station", null, null, DataType.STRING, scalarShape);
        ArrayObject.D0 stnData = new ArrayObject.D0(String.class);
        stnMember.setDataArray((Array)stnData);
        StructureDataW sdata = new StructureDataW(members);
        sdata.setMemberData(stnMember, (Array)stnData);
        if (hasTime) {
            StructureMembers.Member timeMember = members.addMember("time", null, null, DataType.DOUBLE, scalarShape);
            ArrayDouble.D0 timeData = new ArrayDouble.D0();
            timeMember.setDataArray((Array)timeData);
            sdata.setMemberData(timeMember, (Array)timeData);
        }
        for (String varName : vars) {
            GridDatatype grid = gds.findGridDatatype(varName);
            StructureMembers.Member m = members.addMember(grid.getVariable().getShortName(), null, grid.getUnitsString(), grid.getDataType(), scalarShape);
            Array data = Array.factory((DataType)grid.getDataType(), (int[])scalarShape);
            m.setDataArray(data);
            sdata.setMemberData(m, data);
        }
        String stnName = "GridPoint";
        stnData.set((Object)stnName);
        return sdata;
    }

    public StructureData createSingleStructureData(GridDataset gds, LatLonPoint point, List<String> vars, CoordinateAxis1D zAxis, boolean hasTime) {
        int[] scalarShape = new int[]{};
        StructureDataW sd = (StructureDataW)this.createSingleStructureData(gds, point, vars, hasTime);
        ArrayDouble.D0 zData = new ArrayDouble.D0();
        StructureMembers.Member zMember = sd.getStructureMembers().addMember(zAxis.getShortName(), null, zAxis.getUnitsString(), DataType.DOUBLE, scalarShape);
        zMember.setDataArray((Array)zData);
        sd.setMemberData(zMember, (Array)zData);
        return sd;
    }

    public StructureData createSingleStructureData(GridDataset gds, LatLonPoint point, List<String> vars, String zUnits, boolean hasTime) {
        int[] scalarShape = new int[]{};
        StructureDataW sd = (StructureDataW)this.createSingleStructureData(gds, point, vars, hasTime);
        ArrayDouble.D0 zData = new ArrayDouble.D0();
        StructureMembers.Member zMember = sd.getStructureMembers().addMember("vertCoord", null, zUnits, DataType.DOUBLE, scalarShape);
        zMember.setDataArray((Array)zData);
        sd.setMemberData(zMember, (Array)zData);
        return sd;
    }
}

