/*
 * Decompiled with CFR 0.152.
 */
package thredds.server.root;

import java.io.PrintWriter;
import java.util.Formatter;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.AbstractController;
import thredds.monitor.FmrcCacheMonitorImpl;
import thredds.server.config.TdsContext;
import thredds.servlet.DebugHandler;
import ucar.unidata.util.StringUtil2;

public class FmrcCacheController
extends AbstractController {
    private Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private static final String PATH = "/admin/fmrcCache";
    private static final String COLLECTION = "collection";
    private static final String STATISTICS = "cacheStatistics.txt";
    private static final String CMD = "cmd";
    private static final String FILE = "file";
    private final TdsContext tdsContext;
    private final FmrcCacheMonitorImpl monitor = new FmrcCacheMonitorImpl();

    FmrcCacheController(TdsContext _tdsContext) {
        this.tdsContext = _tdsContext;
        DebugHandler debugHandler = DebugHandler.get("Collections");
        DebugHandler.Action act = new DebugHandler.Action("showFmrcCache", "Show FMRC Cache"){

            @Override
            public void doAction(DebugHandler.Event e) {
                e.pw.println("<p>cache location = " + FmrcCacheController.this.monitor.getCacheLocation() + "<p>");
                String statUrl = FmrcCacheController.this.tdsContext.getContextPath() + FmrcCacheController.PATH + "/" + FmrcCacheController.STATISTICS;
                e.pw.println("<p/> <a href='" + statUrl + "'>Show Cache Statistics</a>");
                for (String name : FmrcCacheController.this.monitor.getCachedCollections()) {
                    String ename = StringUtil2.escape((String)name, (String)"");
                    String url = FmrcCacheController.this.tdsContext.getContextPath() + FmrcCacheController.PATH + "?" + FmrcCacheController.COLLECTION + "=" + ename;
                    e.pw.println("<p/> <a href='" + url + "'>" + name + "</a>");
                }
            }
        };
        debugHandler.addAction(act);
        act = new DebugHandler.Action("syncFmrcCache", "Flush FMRC Cache to disk"){

            @Override
            public void doAction(DebugHandler.Event e) {
                FmrcCacheController.this.monitor.sync();
                e.pw.println("<p>bdb cache location = " + FmrcCacheController.this.monitor.getCacheLocation() + "<p> flushed to disk");
            }
        };
        debugHandler.addAction(act);
    }

    protected ModelAndView handleRequestInternal(HttpServletRequest req, HttpServletResponse res) throws Exception {
        String path = req.getPathInfo();
        if (path == null) {
            path = "";
        }
        PrintWriter pw = res.getWriter();
        if (path.endsWith(STATISTICS)) {
            res.setContentType("text/plain");
            Formatter f = new Formatter();
            this.monitor.getCacheStatistics(f);
            String s = f.toString();
            pw.println(s);
            pw.flush();
            return null;
        }
        String collectName = req.getParameter(COLLECTION);
        String fileName = req.getParameter(FILE);
        String cmd = req.getParameter(CMD);
        if (fileName != null) {
            String contents = this.monitor.getCachedFile(collectName, fileName);
            if (null == contents) {
                pw.println("<p/> Cant find filename=" + fileName + " in collection = " + collectName);
            } else {
                res.setContentType("application/xml");
                pw.println(contents);
            }
            return null;
        }
        if (collectName != null) {
            String ecollectName = StringUtil2.escape((String)collectName, (String)"");
            String url = this.tdsContext.getContextPath() + PATH + "?" + COLLECTION + "=" + ecollectName;
            res.setContentType("text/html");
            pw.println("Files for collection = " + collectName + "");
            String deleteUrl = this.tdsContext.getContextPath() + PATH + "?" + COLLECTION + "=" + ecollectName + "&" + CMD + "=delete";
            pw.println("<a href='" + deleteUrl + "'> Delete" + "</a>");
            pw.println("<ol>");
            for (String filename : this.monitor.getFilesInCollection(collectName)) {
                String efileName = StringUtil2.escape((String)filename, (String)"");
                pw.println("<li> <a href='" + url + "&" + FILE + "=" + efileName + "'>" + filename + "</a>");
            }
            pw.println("</ol>");
        }
        if (cmd != null && cmd.equals("delete")) {
            try {
                this.monitor.deleteCollection(collectName);
                pw.println("<p/>deleted");
            }
            catch (Exception e) {
                pw.println("<pre>delete failed on collection = " + collectName);
                e.printStackTrace(pw);
                pw.println("</pre>");
            }
        }
        return null;
    }
}

