/*
 * Decompiled with CFR 0.152.
 */
package thredds.server.cdmremote;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import thredds.server.cdmremote.CdmRemoteQueryBean;
import ucar.ma2.Array;
import ucar.ma2.StructureData;
import ucar.nc2.Attribute;
import ucar.nc2.VariableSimpleIF;
import ucar.nc2.ft.FeatureDatasetPoint;
import ucar.nc2.ft.PointFeature;
import ucar.nc2.ft.PointFeatureCollection;
import ucar.nc2.ft.StationTimeSeriesFeature;
import ucar.nc2.ft.StationTimeSeriesFeatureCollection;
import ucar.nc2.ft.point.StationPointFeature;
import ucar.nc2.ft.point.remote.PointStream;
import ucar.nc2.ft.point.remote.PointStreamProto;
import ucar.nc2.ft.point.writer.WriterCFStationCollection;
import ucar.nc2.stream.NcStream;
import ucar.nc2.stream.NcStreamProto;
import ucar.nc2.time.CalendarDate;
import ucar.nc2.time.CalendarDateFormatter;
import ucar.nc2.time.CalendarDateRange;
import ucar.nc2.units.DateRange;
import ucar.nc2.units.DateType;
import ucar.nc2.units.TimeUnit;
import ucar.nc2.util.DiskCache2;
import ucar.nc2.util.xml.Parse;
import ucar.unidata.geoloc.LatLonPoint;
import ucar.unidata.geoloc.LatLonPointImpl;
import ucar.unidata.geoloc.LatLonRect;
import ucar.unidata.geoloc.Station;
import ucar.unidata.util.Format;

public class StationWriter {
    private static Logger log = LoggerFactory.getLogger(StationWriter.class);
    private static final boolean debug = false;
    private static final boolean debugDetail = false;
    private final FeatureDatasetPoint fd;
    private final StationTimeSeriesFeatureCollection sfc;
    private final CdmRemoteQueryBean qb;
    private final Date start;
    private final Date end;
    private List<VariableSimpleIF> wantVars;
    private DateRange wantRange;
    private DiskCache2 diskCache;
    private HashMap<String, Station> stationMap;

    public StationWriter(FeatureDatasetPoint fd, StationTimeSeriesFeatureCollection sfc, CdmRemoteQueryBean qb, DiskCache2 diskCache) throws IOException {
        this.fd = fd;
        this.sfc = sfc;
        this.qb = qb;
        this.diskCache = diskCache;
        this.start = fd.getStartDate();
        this.end = fd.getEndDate();
    }

    boolean validate(HttpServletResponse res) throws IOException {
        List<String> varNames;
        if (this.qb.getTemporalSelection() == CdmRemoteQueryBean.TemporalSelection.range) {
            this.wantRange = this.qb.getDateRange();
            DateRange haveRange = this.fd.getDateRange();
            if (haveRange != null && !haveRange.intersects(this.wantRange)) {
                res.sendError(400, "ERROR: This dataset does not include the requested time range= " + this.wantRange + "\ndataset time range = " + haveRange);
                return false;
            }
        }
        List dataVars = this.fd.getDataVariables();
        String[] vars = this.qb.getVarNames();
        List<String> list = varNames = vars == null ? null : Arrays.asList(vars);
        if (varNames == null || varNames.size() == 0) {
            this.wantVars = new ArrayList<VariableSimpleIF>(dataVars);
        } else {
            this.wantVars = new ArrayList<VariableSimpleIF>();
            for (VariableSimpleIF v : dataVars) {
                if (!varNames.contains(v.getShortName())) continue;
                this.wantVars.add(v);
            }
        }
        if (this.qb.getSpatialSelection() == CdmRemoteQueryBean.SpatialSelection.bb) {
            LatLonRect bb = this.sfc.getBoundingBox();
            if (bb != null && bb.intersect(this.qb.getLatLonRect()) == null) {
                res.sendError(400, "ERROR: Bounding Box contains no stations; bb= " + this.qb.getLatLonRect());
                return false;
            }
        } else if (this.qb.getSpatialSelection() == CdmRemoteQueryBean.SpatialSelection.stns && !this.contains(this.sfc, this.qb.getStnNames())) {
            res.sendError(400, "ERROR: No valid stations specified = " + this.qb.getStn());
            return false;
        }
        return true;
    }

    private boolean contains(StationTimeSeriesFeatureCollection sfc, String[] stnNames) {
        for (String name : stnNames) {
            if (sfc.getStation(name) == null) continue;
            return true;
        }
        return false;
    }

    public File writeNetcdf() throws IOException {
        WriterNetcdf w = (WriterNetcdf)this.write(null);
        return w.netcdfResult;
    }

    public Writer write(HttpServletResponse res) throws IOException {
        Writer w;
        long start = System.currentTimeMillis();
        Limit counter = new Limit();
        CdmRemoteQueryBean.ResponseType resType = this.qb.getResponseType();
        if (resType == CdmRemoteQueryBean.ResponseType.xml) {
            w = new WriterXML(res.getWriter());
        } else if (resType == CdmRemoteQueryBean.ResponseType.csv) {
            w = new WriterCSV(res.getWriter());
        } else if (resType == CdmRemoteQueryBean.ResponseType.netcdf) {
            w = new WriterNetcdf();
        } else if (resType == CdmRemoteQueryBean.ResponseType.ncstream) {
            w = new WriterNcstream((OutputStream)res.getOutputStream());
        } else {
            log.error("Unknown result type = " + (Object)((Object)resType));
            return null;
        }
        if (this.qb.getTemporalSelection() == CdmRemoteQueryBean.TemporalSelection.point) {
            TimeUnit hour = null;
            try {
                hour = new TimeUnit(1.0, "hour");
            }
            catch (Exception e) {
                e.printStackTrace();
                log.error("bad time unit", (Throwable)e);
                return null;
            }
            DateType startR = this.qb.getTimePoint().subtract(hour);
            DateType endR = this.qb.getTimePoint().add(hour);
            this.wantRange = new DateRange(startR.getDate(), endR.getDate());
        }
        PointFeatureCollection pfc = null;
        switch (this.qb.getSpatialSelection()) {
            case all: {
                pfc = this.sfc.flatten(null, CalendarDateRange.of((DateRange)this.wantRange));
                break;
            }
            case bb: {
                pfc = this.sfc.flatten(this.qb.getLatLonRect(), CalendarDateRange.of((DateRange)this.wantRange));
                break;
            }
            case point: {
                Station closestStation = this.findClosestStation(this.qb.getLatlonPoint());
                ArrayList<String> stn = new ArrayList<String>();
                stn.add(closestStation.getName());
                pfc = this.sfc.flatten(stn, CalendarDateRange.of((DateRange)this.wantRange), null);
                break;
            }
            case stns: {
                List<String> wantStns = Arrays.asList(this.qb.getStnNames());
                pfc = this.sfc.flatten(wantStns, CalendarDateRange.of((DateRange)this.wantRange), null);
            }
        }
        Action act = w.getAction();
        w.header();
        if (this.qb.getTemporalSelection() == CdmRemoteQueryBean.TemporalSelection.point) {
            this.scanForClosestTime(pfc, this.qb.getTimePoint(), null, act, counter);
        } else {
            this.scan(pfc, this.wantRange, null, act, counter);
        }
        w.trailer();
        return w;
    }

    private boolean isStationListEmpty(List<String> stns) throws IOException {
        this.makeStationMap();
        for (String stn : stns) {
            if (this.stationMap.get(stn) == null) continue;
            return false;
        }
        return true;
    }

    private List<Station> getStationList(String[] stnNames) throws IOException {
        this.makeStationMap();
        ArrayList<Station> result = new ArrayList<Station>(stnNames.length);
        for (String s : stnNames) {
            Station stn = this.stationMap.get(s);
            if (stn == null) continue;
            result.add(stn);
        }
        return result;
    }

    private void makeStationMap() throws IOException {
        if (null == this.stationMap) {
            this.stationMap = new HashMap();
            for (Station station : this.sfc.getStations()) {
                this.stationMap.put(station.getName(), station);
            }
        }
    }

    public List<String> getStationNames(LatLonRect boundingBox) throws IOException {
        LatLonPointImpl latlonPt = new LatLonPointImpl();
        ArrayList<String> result = new ArrayList<String>();
        for (Station s : this.sfc.getStations()) {
            latlonPt.set(s.getLatitude(), s.getLongitude());
            if (!boundingBox.contains((LatLonPoint)latlonPt)) continue;
            result.add(s.getName());
        }
        return result;
    }

    public Station findClosestStation(LatLonPoint pt) throws IOException {
        double lat = pt.getLatitude();
        double lon = pt.getLongitude();
        double cos = Math.cos(Math.toRadians(lat));
        List stations = this.sfc.getStations();
        Station min_station = (Station)stations.get(0);
        double min_dist = Double.MAX_VALUE;
        for (Station s : stations) {
            double dx;
            double lat1 = s.getLatitude();
            double lon1 = LatLonPointImpl.lonNormal((double)s.getLongitude(), (double)lon);
            double dy = Math.toRadians(lat - lat1);
            double dist = dy * dy + (dx = cos * Math.toRadians(lon - lon1)) * dx;
            if (!(dist < min_dist)) continue;
            min_dist = dist;
            min_station = s;
        }
        return min_station;
    }

    public boolean intersect(DateRange dr) throws IOException {
        return dr.intersects(this.start, this.end);
    }

    private void scan(PointFeatureCollection collection, DateRange range, Predicate p, Action a, Limit limit) throws IOException {
        collection.resetIteration();
        while (collection.hasNext()) {
            Date obsDate;
            PointFeature pf = collection.next();
            if (range != null && !range.contains(obsDate = pf.getObservationTimeAsDate())) continue;
            ++limit.count;
            StructureData sdata = pf.getData();
            if (p == null || p.match(sdata)) {
                a.act(pf, sdata);
                ++limit.matches;
            }
            if (limit.matches <= limit.limit) continue;
            collection.finish();
            break;
        }
        collection.finish();
    }

    private void scanForClosestTime(PointFeatureCollection collection, DateType time, Predicate p, Action a, Limit limit) throws IOException {
        HashMap<String, StationDataTracker> map = new HashMap<String, StationDataTracker>();
        long wantTime = time.getDate().getTime();
        collection.resetIteration();
        while (collection.hasNext()) {
            StructureData sdata;
            PointFeature pf = collection.next();
            if (p != null && !p.match(sdata = pf.getData())) continue;
            long obsTime = pf.getObservationTimeAsDate().getTime();
            long diff = Math.abs(obsTime - wantTime);
            Station s = ((StationPointFeature)pf).getStation();
            StationDataTracker track = (StationDataTracker)map.get(s.getName());
            if (track == null) {
                map.put(s.getName(), new StationDataTracker(pf, diff));
                continue;
            }
            if (diff >= track.timeDiff) continue;
            track.sobs = pf;
            track.timeDiff = diff;
        }
        for (String name : map.keySet()) {
            StationDataTracker track = (StationDataTracker)map.get(name);
            a.act(track.sobs, track.sobs.getData());
            ++limit.matches;
            ++limit.count;
            if (limit.count <= limit.limit) continue;
            break;
        }
    }

    private void scan(StationTimeSeriesFeatureCollection collection, DateRange range, Predicate p, Action a, Limit limit) throws IOException {
        while (collection.hasNext()) {
            StationTimeSeriesFeature sf = collection.next();
            while (sf.hasNext()) {
                Date obsDate;
                PointFeature pf = sf.next();
                if (range != null && !range.contains(obsDate = pf.getObservationTimeAsDate())) continue;
                ++limit.count;
                StructureData sdata = pf.getData();
                if (p == null || p.match(sdata)) {
                    a.act(pf, sdata);
                    ++limit.matches;
                }
                if (limit.matches <= limit.limit) continue;
                sf.finish();
                break;
            }
            if (limit.matches <= limit.limit) continue;
            collection.finish();
            break;
        }
    }

    public static void main(String[] args) throws IOException {
    }

    class WriterCSV
    extends Writer {
        WriterCSV(PrintWriter writer) {
            super(writer);
        }

        @Override
        public void header() {
            this.writer.print("time,station,latitude[unit=\"degrees_north\"],longitude[unit=\"degrees_east\"]");
            for (VariableSimpleIF var : StationWriter.this.wantVars) {
                this.writer.print(",");
                this.writer.print(var.getShortName());
                if (var.getUnitsString() == null) continue;
                this.writer.print("[unit=\"" + var.getUnitsString() + "\"]");
            }
            this.writer.println();
        }

        @Override
        public void trailer() {
            this.writer.flush();
        }

        @Override
        Action getAction() {
            return new Action(){

                @Override
                public void act(PointFeature pf, StructureData sdata) throws IOException {
                    Station s = StationWriter.this.sfc.getStation(pf);
                    WriterCSV.this.writer.print(CalendarDateFormatter.toDateTimeString((CalendarDate)pf.getObservationTimeAsCalendarDate()));
                    WriterCSV.this.writer.print(',');
                    WriterCSV.this.writer.print(s.getName());
                    WriterCSV.this.writer.print(',');
                    WriterCSV.this.writer.print(Format.dfrac((double)s.getLatitude(), (int)3));
                    WriterCSV.this.writer.print(',');
                    WriterCSV.this.writer.print(Format.dfrac((double)s.getLongitude(), (int)3));
                    for (VariableSimpleIF var : StationWriter.this.wantVars) {
                        WriterCSV.this.writer.print(',');
                        Array sdataArray = sdata.getArray(var.getShortName());
                        WriterCSV.this.writer.print(sdataArray.toString());
                    }
                    WriterCSV.this.writer.println();
                    ++WriterCSV.this.count;
                }
            };
        }
    }

    class WriterXML
    extends Writer {
        XMLStreamWriter staxWriter;

        WriterXML(PrintWriter writer) {
            super(writer);
            XMLOutputFactory f = XMLOutputFactory.newInstance();
            try {
                this.staxWriter = f.createXMLStreamWriter(writer);
            }
            catch (XMLStreamException e) {
                throw new RuntimeException(e.getMessage());
            }
        }

        @Override
        public void header() {
            try {
                this.staxWriter.writeStartDocument("UTF-8", "1.0");
                this.staxWriter.writeCharacters("\n");
                this.staxWriter.writeStartElement("stationFeatureCollection");
                this.staxWriter.writeCharacters("\n ");
            }
            catch (XMLStreamException e) {
                throw new RuntimeException(e.getMessage());
            }
        }

        @Override
        public void trailer() {
            try {
                this.staxWriter.writeEndElement();
                this.staxWriter.writeCharacters("\n");
                this.staxWriter.writeEndDocument();
                this.staxWriter.close();
            }
            catch (XMLStreamException e) {
                throw new RuntimeException(e.getMessage());
            }
            this.writer.flush();
        }

        @Override
        Action getAction() {
            return new Action(){

                @Override
                public void act(PointFeature pf, StructureData sdata) throws IOException {
                    Station s = StationWriter.this.sfc.getStation(pf);
                    try {
                        WriterXML.this.staxWriter.writeStartElement("pointFeature");
                        WriterXML.this.staxWriter.writeAttribute("date", CalendarDateFormatter.toDateTimeString((CalendarDate)pf.getObservationTimeAsCalendarDate()));
                        WriterXML.this.staxWriter.writeCharacters("\n  ");
                        WriterXML.this.staxWriter.writeStartElement("station");
                        WriterXML.this.staxWriter.writeAttribute("name", s.getName());
                        WriterXML.this.staxWriter.writeAttribute("latitude", Format.dfrac((double)s.getLatitude(), (int)3));
                        WriterXML.this.staxWriter.writeAttribute("longitude", Format.dfrac((double)s.getLongitude(), (int)3));
                        if (!Double.isNaN(s.getAltitude())) {
                            WriterXML.this.staxWriter.writeAttribute("altitude", Format.dfrac((double)s.getAltitude(), (int)0));
                        }
                        if (s.getDescription() != null) {
                            WriterXML.this.staxWriter.writeCharacters(s.getDescription());
                        }
                        WriterXML.this.staxWriter.writeEndElement();
                        WriterXML.this.staxWriter.writeCharacters("\n ");
                        for (VariableSimpleIF var : StationWriter.this.wantVars) {
                            WriterXML.this.staxWriter.writeCharacters(" ");
                            WriterXML.this.staxWriter.writeStartElement("data");
                            WriterXML.this.staxWriter.writeAttribute("name", var.getShortName());
                            if (var.getUnitsString() != null) {
                                WriterXML.this.staxWriter.writeAttribute("units", var.getUnitsString());
                            }
                            Array sdataArray = sdata.getArray(var.getShortName());
                            String ss = sdataArray.toString();
                            Class elemType = sdataArray.getElementType();
                            if (elemType == String.class || elemType == Character.TYPE || elemType == StructureData.class) {
                                ss = Parse.cleanCharacterData((String)ss);
                            }
                            WriterXML.this.staxWriter.writeCharacters(ss);
                            WriterXML.this.staxWriter.writeEndElement();
                            WriterXML.this.staxWriter.writeCharacters("\n ");
                        }
                        WriterXML.this.staxWriter.writeEndElement();
                        WriterXML.this.staxWriter.writeCharacters("\n");
                        ++WriterXML.this.count;
                    }
                    catch (XMLStreamException e) {
                        throw new RuntimeException(e.getMessage());
                    }
                }
            };
        }
    }

    class WriterRaw
    extends Writer {
        WriterRaw(PrintWriter writer) {
            super(writer);
        }

        @Override
        public void header() {
        }

        @Override
        public void trailer() {
            this.writer.flush();
        }

        @Override
        Action getAction() {
            return new Action(){

                @Override
                public void act(PointFeature pf, StructureData sdata) throws IOException {
                    WriterRaw.this.writer.print(CalendarDateFormatter.toDateTimeString((CalendarDate)pf.getObservationTimeAsCalendarDate()));
                    WriterRaw.this.writer.print("= ");
                    String report = sdata.getScalarString("report");
                    WriterRaw.this.writer.println(report);
                    ++WriterRaw.this.count;
                }
            };
        }
    }

    class WriterNcstream
    extends Writer {
        OutputStream out;

        WriterNcstream(OutputStream os) throws IOException {
            super(null);
            this.out = os;
        }

        @Override
        public void header() throws IOException {
        }

        @Override
        public void trailer() throws IOException {
            PointStream.writeMagic((OutputStream)this.out, (PointStream.MessageType)PointStream.MessageType.End);
            this.out.flush();
        }

        @Override
        Action getAction() {
            return new Action(){

                @Override
                public void act(PointFeature pf, StructureData sdata) throws IOException {
                    try {
                        byte[] b;
                        if (WriterNcstream.this.count == 0) {
                            PointStreamProto.PointFeatureCollection proto = PointStream.encodePointFeatureCollection((String)StationWriter.this.fd.getLocation(), (PointFeature)pf);
                            b = proto.toByteArray();
                            PointStream.writeMagic((OutputStream)WriterNcstream.this.out, (PointStream.MessageType)PointStream.MessageType.PointFeatureCollection);
                            NcStream.writeVInt((OutputStream)WriterNcstream.this.out, (int)b.length);
                            WriterNcstream.this.out.write(b);
                        }
                        PointStreamProto.PointFeature pfp = PointStream.encodePointFeature((PointFeature)pf);
                        b = pfp.toByteArray();
                        PointStream.writeMagic((OutputStream)WriterNcstream.this.out, (PointStream.MessageType)PointStream.MessageType.PointFeature);
                        NcStream.writeVInt((OutputStream)WriterNcstream.this.out, (int)b.length);
                        WriterNcstream.this.out.write(b);
                        ++WriterNcstream.this.count;
                    }
                    catch (Throwable t) {
                        String mess = t.getMessage();
                        if (mess == null) {
                            mess = t.getClass().getName();
                        }
                        NcStreamProto.Error err = NcStream.encodeErrorMessage((String)t.getMessage());
                        byte[] b = err.toByteArray();
                        PointStream.writeMagic((OutputStream)WriterNcstream.this.out, (PointStream.MessageType)PointStream.MessageType.Error);
                        NcStream.writeVInt((OutputStream)WriterNcstream.this.out, (int)b.length);
                        WriterNcstream.this.out.write(b);
                        throw new IOException(t);
                    }
                }
            };
        }
    }

    class WriterNetcdf
    extends Writer {
        File netcdfResult;
        WriterCFStationCollection cfWriter;
        boolean headerWritten;
        private List<Station> wantStations;

        WriterNetcdf() throws IOException {
            super(null);
            this.headerWritten = false;
            this.netcdfResult = StationWriter.this.diskCache.createUniqueFile("cdmSW", ".nc");
            ArrayList<Attribute> atts = new ArrayList<Attribute>();
            atts.add(new Attribute("title", "Extracted data from TDS using CDM remote subsetting"));
            this.cfWriter = new WriterCFStationCollection(null, this.netcdfResult.getAbsolutePath(), atts);
            if (StationWriter.this.qb.getSpatialSelection() == CdmRemoteQueryBean.SpatialSelection.bb) {
                this.wantStations = StationWriter.this.sfc.getStations(StationWriter.this.qb.getLatLonRect());
            } else if (StationWriter.this.qb.getSpatialSelection() == CdmRemoteQueryBean.SpatialSelection.stns) {
                List<String> stnNames = Arrays.asList(StationWriter.this.qb.getStnNames());
                this.wantStations = StationWriter.this.sfc.getStations(stnNames);
            } else {
                this.wantStations = StationWriter.this.sfc.getStations();
            }
        }

        @Override
        public void header() {
        }

        @Override
        public void trailer() throws IOException {
            this.cfWriter.finish();
        }

        @Override
        Action getAction() {
            return new Action(){

                @Override
                public void act(PointFeature pf, StructureData sdata) throws IOException {
                    if (!WriterNetcdf.this.headerWritten) {
                        try {
                            WriterNetcdf.this.cfWriter.writeHeader(WriterNetcdf.this.wantStations, StationWriter.this.wantVars, pf.getTimeUnit(), null);
                            WriterNetcdf.this.headerWritten = true;
                        }
                        catch (IOException e) {
                            log.error("WriterNetcdf.header", (Throwable)e);
                        }
                    }
                    WriterNetcdf.this.cfWriter.writeRecord(StationWriter.this.sfc.getStation(pf), pf, sdata);
                    ++WriterNetcdf.this.count;
                }
            };
        }
    }

    abstract class Writer {
        PrintWriter writer;
        int count = 0;

        abstract void header() throws IOException;

        abstract Action getAction();

        abstract void trailer() throws IOException;

        Writer(PrintWriter writer) {
            this.writer = writer;
        }
    }

    private class Limit {
        int count;
        int limit = Integer.MAX_VALUE;
        int matches;

        private Limit() {
        }
    }

    private static interface Action {
        public void act(PointFeature var1, StructureData var2) throws IOException;
    }

    private static interface Predicate {
        public boolean match(StructureData var1);
    }

    private class StationDataTracker {
        PointFeature sobs;
        long timeDiff = Long.MAX_VALUE;

        StationDataTracker(PointFeature sobs, long timeDiff) {
            this.sobs = sobs;
            this.timeDiff = timeDiff;
        }
    }
}

