/*
 * Decompiled with CFR 0.152.
 */
package thredds.server.ncSubset.view.netcdf;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import thredds.server.ncSubset.dataservice.StructureDataFactory;
import thredds.server.ncSubset.util.NcssRequestUtils;
import thredds.server.ncSubset.view.netcdf.CFPointWriterWrapper;
import thredds.server.ncSubset.view.netcdf.WriterCFStationCollection;
import ucar.ma2.StructureData;
import ucar.nc2.Attribute;
import ucar.nc2.NetcdfFileWriter;
import ucar.nc2.VariableSimpleIF;
import ucar.nc2.dataset.CoordinateAxis1D;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dt.GridDataset;
import ucar.nc2.dt.GridDatatype;
import ucar.nc2.dt.grid.GridAsPointDataset;
import ucar.nc2.time.CalendarDate;
import ucar.nc2.units.DateUnit;
import ucar.unidata.geoloc.LatLonPoint;
import ucar.unidata.geoloc.Station;
import ucar.unidata.geoloc.StationImpl;

public final class CFStationCollectionWriterWrapper
implements CFPointWriterWrapper {
    private static Logger log = LoggerFactory.getLogger(CFStationCollectionWriterWrapper.class);
    private WriterCFStationCollection writerCFStationCollection;
    private GridAsPointDataset gap;
    private CalendarDate timeOrigin;

    private CFStationCollectionWriterWrapper() {
    }

    private CFStationCollectionWriterWrapper(NetcdfFileWriter.Version version, String filePath, List<Attribute> atts) throws IOException {
        this.writerCFStationCollection = new WriterCFStationCollection(version, filePath, atts);
    }

    @Override
    public boolean header(Map<String, List<String>> groupedVars, GridDataset gridDataset, List<CalendarDate> wDates, DateUnit dateUnit, LatLonPoint point, Double vertCoord) {
        this.timeOrigin = dateUnit.makeCalendarDate(0.0);
        boolean headerDone = false;
        String stnName = "GridPoint";
        String desc = "Grid Point at lat/lon=" + point.getLatitude() + "," + point.getLongitude();
        StationImpl s = new StationImpl(stnName, desc, "", point.getLatitude(), point.getLongitude(), Double.NaN);
        ArrayList<Station> stnList = new ArrayList<Station>();
        stnList.add((Station)s);
        NetcdfDataset ncfile = (NetcdfDataset)gridDataset.getNetcdfFile();
        List<String> vars = new ArrayList<List<String>>(groupedVars.values()).get(0);
        this.gap = NcssRequestUtils.buildGridAsPointDataset(gridDataset, vars);
        List<VariableSimpleIF> wantedVars = NcssRequestUtils.wantedVars2VariableSimple(vars, gridDataset, ncfile);
        try {
            this.writerCFStationCollection.writeHeader(stnList, wantedVars, gridDataset, dateUnit, "");
            headerDone = true;
        }
        catch (IOException ioe) {
            log.error("Error writing header", (Throwable)ioe);
        }
        return headerDone;
    }

    @Override
    public boolean write(Map<String, List<String>> groupedVars, GridDataset gridDataset, CalendarDate date, LatLonPoint point, Double targetLevel) {
        boolean allDone = false;
        List<String> vars = new ArrayList<List<String>>(groupedVars.values()).get(0);
        StructureData sdata = StructureDataFactory.getFactory().createSingleStructureData(gridDataset, point, vars, true);
        Double timeCoordValue = NcssRequestUtils.getTimeCoordValue(gridDataset.findGridDatatype(vars.get(0)), date, this.timeOrigin);
        sdata.findMember("time").getDataArray().setDouble(0, timeCoordValue.doubleValue());
        CoordinateAxis1D ensAxis = gridDataset.findGridDatatype(vars.get(0)).getCoordinateSystem().getEnsembleAxis();
        double[] ensCoords = new double[]{-1.0};
        if (ensAxis != null) {
            ensCoords = ensAxis.getCoordValues();
        }
        try {
            int ensIdx = 0;
            for (double ensCoord : ensCoords) {
                if (ensCoord >= 0.0) {
                    this.writerCFStationCollection.writeEnsCoord(ensIdx, ensCoord);
                    ++ensIdx;
                }
                for (String varName : vars) {
                    GridDatatype grid = gridDataset.findGridDatatype(varName);
                    if (this.gap.hasTime(grid, date)) {
                        GridAsPointDataset.Point p = this.gap.readData(grid, date, ensCoord, -1.0, point.getLatitude(), point.getLongitude());
                        sdata.findMember(varName).getDataArray().setDouble(0, p.dataValue);
                        continue;
                    }
                    sdata.findMember(varName).getDataArray().setDouble(0, this.gap.getMissingValue(grid));
                }
                if (ensCoord < 0.0) {
                    this.writerCFStationCollection.writeRecord((String)sdata.findMember("station").getDataArray().getObject(0), timeCoordValue, date, sdata);
                } else {
                    this.writerCFStationCollection.writeRecord((String)sdata.findMember("station").getDataArray().getObject(0), timeCoordValue, date, ensCoord, sdata);
                }
                allDone = true;
            }
        }
        catch (IOException ioe) {
            log.error("Error writing data", (Throwable)ioe);
        }
        return allDone;
    }

    @Override
    public boolean trailer() {
        boolean finished = false;
        try {
            this.writerCFStationCollection.finish();
            finished = true;
        }
        catch (IOException ioe) {
            log.error("Error finishing  WriterCFStationCollection" + ioe);
        }
        return finished;
    }

    public static CFStationCollectionWriterWrapper createWrapper(NetcdfFileWriter.Version version, String filePath, List<Attribute> atts) throws IOException {
        return new CFStationCollectionWriterWrapper(version, filePath, atts);
    }
}

