/*
 * Decompiled with CFR 0.152.
 */
package thredds.util.filesource;

import java.io.File;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;
import thredds.util.filesource.DescendantFileSource;

public class BasicDescendantFileSource
implements DescendantFileSource {
    private static Logger log = LoggerFactory.getLogger(BasicDescendantFileSource.class);
    private final String rootDirectoryPath;
    private final File rootDirectory;

    public BasicDescendantFileSource(File rootDirectory) {
        if (rootDirectory == null) {
            throw new IllegalArgumentException("Root directory must not be null.");
        }
        if (!rootDirectory.exists()) {
            throw new IllegalArgumentException("Root directory must exist: " + rootDirectory.getAbsolutePath() + ".");
        }
        if (!rootDirectory.isDirectory()) {
            throw new IllegalArgumentException("Root directory must be a directory: " + rootDirectory.getAbsolutePath() + ".");
        }
        this.rootDirectoryPath = StringUtils.cleanPath((String)rootDirectory.getAbsolutePath());
        this.rootDirectory = new File(this.rootDirectoryPath);
    }

    public BasicDescendantFileSource(String rootDirectoryPath) {
        if (rootDirectoryPath == null) {
            throw new IllegalArgumentException("Root directory must not be null.");
        }
        File file = new File(rootDirectoryPath);
        if (!file.exists()) {
            throw new IllegalArgumentException("Root directory must exist: " + rootDirectoryPath + ".");
        }
        if (!file.isDirectory()) {
            throw new IllegalArgumentException("Root directory must be a directory: " + rootDirectoryPath + ".");
        }
        this.rootDirectoryPath = StringUtils.cleanPath((String)file.getAbsolutePath());
        this.rootDirectory = new File(this.rootDirectoryPath);
    }

    @Override
    public File getFile(String path) {
        if (path == null) {
            return null;
        }
        String workPath = StringUtils.cleanPath((String)path);
        if (workPath.startsWith("../")) {
            return null;
        }
        if (new File(workPath).isAbsolute()) {
            return null;
        }
        File file = new File(this.rootDirectory, workPath);
        if (file.exists()) {
            return file;
        }
        return null;
    }

    @Override
    public DescendantFileSource getDescendant(String relativePath) {
        File descendantFile = this.getFile(relativePath);
        if (descendantFile == null || !descendantFile.isDirectory()) {
            return null;
        }
        return new BasicDescendantFileSource(descendantFile);
    }

    @Override
    public File getRootDirectory() {
        return this.rootDirectory;
    }

    @Override
    public String getRootDirectoryPath() {
        return this.rootDirectoryPath;
    }

    @Override
    public boolean isDescendant(File file) {
        if (file == null) {
            return false;
        }
        String relPath = this.getRelativePath(file);
        return relPath != null && !relPath.equals("");
    }

    @Override
    public boolean isDescendant(String filePath) {
        return filePath == null ? false : this.isDescendant(new File(filePath));
    }

    @Override
    public String getRelativePath(File file) {
        if (file == null) {
            return null;
        }
        String cleanPath = StringUtils.cleanPath((String)file.getAbsolutePath()).trim();
        if (cleanPath.startsWith(this.rootDirectoryPath + "/") && cleanPath.length() > this.rootDirectoryPath.length() + 1) {
            String relativePath = cleanPath.substring(this.rootDirectoryPath.length() + 1);
            return relativePath.trim();
        }
        return null;
    }

    @Override
    public String getRelativePath(String filePath) {
        if (filePath == null) {
            return null;
        }
        return this.getRelativePath(new File(filePath));
    }
}

