/*
 * Decompiled with CFR 0.152.
 */
package thredds.server.cataloggen;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import thredds.cataloggen.CatalogGen;
import thredds.server.cataloggen.CatGenTaskConfig;
import thredds.servlet.UsageLog;
import ucar.nc2.units.DateType;

public class CatGenTaskRunner
implements Runnable {
    private static Logger log = LoggerFactory.getLogger(CatGenTaskRunner.class);
    private final CatGenTaskConfig taskConfig;
    private final File configFile;
    private final File resultFile;

    CatGenTaskRunner(CatGenTaskConfig taskConfig, File configDir, File resultDir, File altResultsDir) {
        this.taskConfig = taskConfig;
        this.configFile = new File(configDir, taskConfig.getConfigDocName());
        String resultFileName = taskConfig.getResultFileName();
        this.resultFile = resultFileName.startsWith("/") ? new File(altResultsDir, resultFileName.substring(1)) : new File(resultDir, resultFileName);
    }

    @Override
    public void run() {
        log.info("run(): generating catalog [" + this.resultFile.toString() + "] from config doc [" + this.taskConfig.getConfigDocName() + "] - " + UsageLog.setupNonRequestContext());
        URL configFileURL = null;
        try {
            configFileURL = this.configFile.toURI().toURL();
        }
        catch (MalformedURLException e) {
            log.error("run(): Config file path [" + this.configFile + "] gives malformed URL: " + e.getMessage());
            log.info("run(): done -" + UsageLog.closingMessageNonRequestContext());
            return;
        }
        CatalogGen catGen = new CatalogGen(configFileURL);
        StringBuilder messages = new StringBuilder();
        if (catGen.isValid(messages)) {
            catGen.expand();
            long expireMillis = System.currentTimeMillis() + (long)(this.taskConfig.getPeriodInMinutes() * 60 * 1000);
            Date expireDate = new Date(expireMillis);
            DateType expireDateType = new DateType(false, expireDate);
            catGen.setCatalogExpiresDate(expireDateType);
            try {
                catGen.writeCatalog(this.resultFile.toString());
            }
            catch (IOException e) {
                log.error("run(): couldn't write catalog: " + e.getMessage());
                log.info("run(): done -" + UsageLog.closingMessageNonRequestContext());
                return;
            }
            log.debug("run(): Catalog written (" + this.resultFile.toString() + ").");
        } else {
            log.error("run(): Tried running CatalogGen with invalid config doc, " + this.taskConfig.getConfigDocName() + "\n" + messages.toString());
        }
        log.info("run(): done -" + UsageLog.closingMessageNonRequestContext());
    }
}

