/*
 * Decompiled with CFR 0.152.
 */
package thredds.servlet;

import java.util.Comparator;
import java.util.Iterator;
import java.util.SortedMap;
import java.util.TreeMap;
import ucar.unidata.util.StringUtil2;

public class PathMatcher {
    private final TreeMap<String, Object> treeMap = new TreeMap(new PathComparator());
    private static boolean debug = false;

    public void put(String key, Object value) {
        this.treeMap.put(key, value == null ? key : value);
    }

    public Object get(String key) {
        return this.treeMap.get(key);
    }

    public Iterator iterator() {
        return this.treeMap.values().iterator();
    }

    public Object match(String path) {
        SortedMap<String, Object> tail = this.treeMap.tailMap(path);
        if (tail.isEmpty()) {
            return null;
        }
        String after = tail.firstKey();
        if (path.startsWith(after)) {
            return this.treeMap.get(after);
        }
        for (String key : tail.keySet()) {
            if (path.startsWith(key)) {
                return this.treeMap.get(key);
            }
            if (StringUtil2.match((String)path, (String)key) != 0) continue;
            break;
        }
        return null;
    }

    private void doit(String s) {
        System.out.println(s + " == " + this.match(s));
    }

    public static void main(String[] args) {
        PathMatcher m = new PathMatcher();
        m.put("/thredds/dods/test/longer", null);
        m.put("/thredds/dods/test", null);
        m.put("/thredds/dods/tester", null);
        m.put("/thredds/dods/short", null);
        m.put("/actionable", null);
        m.put("myworld", null);
        m.put("mynot", null);
        m.put("ncmodels", null);
        m.put("ncmodels/bzipped", null);
        m.doit("nope");
        m.doit("/thredds/dods/test");
        m.doit("/thredds/dods/test/lo");
        m.doit("/thredds/dods/test/longer/donger");
        m.doit("myworldly");
        m.doit("/my");
        m.doit("mysnot");
        debug = true;
        m.doit("ncmodels/canonical");
    }

    private class PathComparator
    implements Comparator<String> {
        private PathComparator() {
        }

        @Override
        public int compare(String s1, String s2) {
            int compare = s2.compareTo(s1);
            if (debug) {
                System.out.println(" compare " + s1 + " to " + s2 + " = " + compare);
            }
            return compare;
        }
    }
}

