/*
 * Decompiled with CFR 0.152.
 */
package thredds.servlet;

import java.io.File;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import thredds.servlet.DataRootHandler;
import thredds.servlet.DatasetHandler;
import thredds.servlet.ServletUtil;

public class FileServerServlet
extends HttpServlet {
    protected static Logger log;

    public void init() throws ServletException {
        super.init();
        log = LoggerFactory.getLogger(FileServerServlet.class);
    }

    protected long getLastModified(HttpServletRequest req) {
        File file = this.getFile(req);
        if (file == null) {
            return -1L;
        }
        return file.lastModified();
    }

    public void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        if (!DatasetHandler.resourceControlOk(req, res, null)) {
            return;
        }
        File file = this.getFile(req);
        ServletUtil.returnFile(this, req, res, file, null);
    }

    private File getFile(HttpServletRequest req) {
        File file;
        String reqPath = req.getPathInfo();
        if (reqPath == null) {
            return null;
        }
        if (reqPath.length() > 0 && reqPath.startsWith("/")) {
            reqPath = reqPath.substring(1);
        }
        if ((file = DataRootHandler.getInstance().getCrawlableDatasetAsFile(reqPath)) == null) {
            return null;
        }
        if (!file.exists()) {
            return null;
        }
        return file;
    }
}

