/*
 * Decompiled with CFR 0.152.
 */
package thredds.util;

import java.io.IOException;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestForwardUtils {
    private static Logger log = LoggerFactory.getLogger(RequestForwardUtils.class);

    private RequestForwardUtils() {
    }

    public static void forwardRequestRelativeToCurrentContext(String fwdPath, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        if (fwdPath == null || request == null || response == null) {
            String msg = "Path, request, and response may not be null";
            log.error("forwardRequestRelativeToCurrentContext() ERROR: " + msg + (fwdPath == null ? ": " : "[" + fwdPath + "]: "));
            throw new IllegalArgumentException(msg + ".");
        }
        RequestDispatcher dispatcher = request.getRequestDispatcher(fwdPath);
        if (RequestForwardUtils.dispatcherWasFound(fwdPath, dispatcher, response)) {
            RequestForwardUtils.forwardRequest(fwdPath, dispatcher, request, response);
        }
    }

    public static void forwardRequestRelativeToGivenContext(String fwdPath, ServletContext targetContext, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        if (fwdPath == null || targetContext == null || request == null || response == null) {
            String msg = "Path, context, request, and response may not be null";
            log.error("forwardRequestRelativeToGivenContext() ERROR: " + msg + (fwdPath == null ? ": " : "[" + fwdPath + "]: "));
            throw new IllegalArgumentException(msg + ".");
        }
        RequestDispatcher dispatcher = targetContext.getRequestDispatcher(fwdPath);
        if (RequestForwardUtils.dispatcherWasFound(fwdPath, dispatcher, response)) {
            RequestForwardUtils.forwardRequest(fwdPath, dispatcher, request, response);
        }
    }

    public static void forwardRequest(String fwdPath, RequestDispatcher dispatcher, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        if (fwdPath == null || dispatcher == null || request == null || response == null) {
            String msg = "Path, dispatcher, request, and response may not be null";
            log.error("forwardRequestRelativeToGivenContext() ERROR: " + msg + (fwdPath == null ? ": " : "[" + fwdPath + "]: "));
            throw new IllegalArgumentException(msg + ".");
        }
        dispatcher.forward((ServletRequest)request, (ServletResponse)response);
    }

    private static boolean dispatcherWasFound(String fwdPath, RequestDispatcher dispatcher, HttpServletResponse response) throws IOException {
        if (fwdPath == null || response == null) {
            String msg = "Path and response may not be null";
            log.error("forwardRequestRelativeToGivenContext() ERROR: " + msg + (fwdPath == null ? ": " : "[" + fwdPath + "]: "));
            throw new IllegalArgumentException(msg + ".");
        }
        if (dispatcher == null) {
            log.error("dispatcherWasFound() ERROR : Dispatcher for forwarding [" + fwdPath + "] not found:");
            response.sendError(404);
            return false;
        }
        return true;
    }
}

