/*
 * Decompiled with CFR 0.152.
 */
package thredds.server.admin;

import java.io.PrintWriter;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Formatter;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.quartz.JobKey;
import org.quartz.Scheduler;
import org.quartz.TriggerKey;
import org.quartz.impl.matchers.GroupMatcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.servlet.ModelAndView;
import thredds.catalog.InvDatasetFeatureCollection;
import thredds.inventory.CollectionManager;
import thredds.inventory.CollectionUpdater;
import thredds.inventory.MFile;
import thredds.monitor.FmrcCacheMonitorImpl;
import thredds.server.admin.DebugController;
import thredds.server.config.TdsContext;
import thredds.servlet.DataRootHandler;
import thredds.util.ContentType;
import thredds.util.TdsPathUtils;
import ucar.nc2.time.CalendarDateFormatter;
import ucar.unidata.util.StringUtil2;

@Controller
@RequestMapping(value={"/admin"})
public class CollectionController {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private static final String PATH = "/admin/collection";
    private static final String COLLECTION = "collection";
    private static final String TRIGGER = "trigger";
    private static final String NOCHECK = "nocheck";
    @Autowired
    private TdsContext tdsContext;
    private static final String FMRC_PATH = "/admin/fmrcCache";
    private static final String STATISTICS = "cacheStatistics.txt";
    private static final String CMD = "cmd";
    private static final String FILE = "file";
    private final FmrcCacheMonitorImpl monitor = new FmrcCacheMonitorImpl();

    @PostConstruct
    public void afterPropertiesSet() {
        DebugController.Category debugHandler = DebugController.find("Collections");
        DebugController.Action act = new DebugController.Action("showCollection", "Show Collections"){

            @Override
            public void doAction(DebugController.Event e) {
                List<InvDatasetFeatureCollection> fcList = DataRootHandler.getInstance().getFeatureCollections();
                Collections.sort(fcList, new Comparator<InvDatasetFeatureCollection>(){

                    @Override
                    public int compare(InvDatasetFeatureCollection o1, InvDatasetFeatureCollection o2) {
                        return o1.getName().compareTo(o2.getName());
                    }
                });
                for (InvDatasetFeatureCollection fc : fcList) {
                    String ename = StringUtil2.escape((String)fc.getName(), (String)"");
                    String url = CollectionController.this.tdsContext.getContextPath() + CollectionController.PATH + "?" + CollectionController.COLLECTION + "=" + ename;
                    e.pw.printf("<p/><a href='%s'>%s</a>%n", url, fc.getName());
                }
            }
        };
        debugHandler.addAction(act);
        act = new DebugController.Action("sched", "Show scheduler"){

            @Override
            public void doAction(DebugController.Event e) {
                Scheduler scheduler = CollectionUpdater.INSTANCE.getScheduler();
                if (scheduler == null) {
                    return;
                }
                try {
                    e.pw.println(scheduler.getMetaData());
                    List groups = scheduler.getJobGroupNames();
                    List triggers = scheduler.getTriggerGroupNames();
                    for (String group : scheduler.getJobGroupNames()) {
                        e.pw.println("Group " + group);
                        for (JobKey jobKey : scheduler.getJobKeys(GroupMatcher.groupEquals((String)group))) {
                            e.pw.println("  Job " + jobKey.getName());
                            e.pw.println("    " + scheduler.getJobDetail(jobKey));
                        }
                        for (TriggerKey triggerKey : scheduler.getTriggerKeys(GroupMatcher.groupEquals((String)group))) {
                            e.pw.println("  Trigger " + triggerKey.getName());
                            e.pw.println("    " + scheduler.getTrigger(triggerKey));
                        }
                    }
                }
                catch (Exception e1) {
                    e.pw.println("Error on scheduler " + e1.getMessage());
                    CollectionController.this.log.error("Error on scheduler " + e1.getMessage());
                }
            }
        };
        debugHandler.addAction(act);
        act = new DebugController.Action("showFmrcCache", "Show FMRC Cache"){

            @Override
            public void doAction(DebugController.Event e) {
                e.pw.println("<p>cache location = " + CollectionController.this.monitor.getCacheLocation() + "<p>");
                String statUrl = CollectionController.this.tdsContext.getContextPath() + CollectionController.PATH + "/" + CollectionController.STATISTICS;
                e.pw.println("<p/> <a href='" + statUrl + "'>Show Cache Statistics</a>");
                for (String name : CollectionController.this.monitor.getCachedCollections()) {
                    String ename = StringUtil2.escape((String)name, (String)"");
                    String url = CollectionController.this.tdsContext.getContextPath() + CollectionController.PATH + "?" + CollectionController.COLLECTION + "=" + ename;
                    e.pw.println("<p/> <a href='" + url + "'>" + name + "</a>");
                }
            }
        };
        debugHandler.addAction(act);
        act = new DebugController.Action("syncFmrcCache", "Flush FMRC Cache to disk"){

            @Override
            public void doAction(DebugController.Event e) {
                CollectionController.this.monitor.sync();
                e.pw.println("<p>bdb cache location = " + CollectionController.this.monitor.getCacheLocation() + "<p> flushed to disk");
            }
        };
        debugHandler.addAction(act);
    }

    @RequestMapping(value={"/collection", "/collection/trigger"})
    protected ModelAndView handleCollectionTriggers(HttpServletRequest req, HttpServletResponse res) throws Exception {
        InvDatasetFeatureCollection fc;
        String path = req.getServletPath();
        if (path == null) {
            path = "";
        }
        if (path.startsWith("/admin")) {
            path = path.substring("/admin".length(), path.length());
        }
        res.setContentType(ContentType.html.getContentHeader());
        PrintWriter pw = res.getWriter();
        String collectName = req.getParameter(COLLECTION);
        boolean trigger = false;
        boolean nocheck = false;
        if (path.equals("/collection/trigger")) {
            trigger = true;
            boolean bl = nocheck = req.getParameter(NOCHECK) != null;
        }
        if ((fc = DataRootHandler.getInstance().getFeatureCollection(collectName)) == null) {
            res.setStatus(404);
            pw.append("NOT FOUND");
            pw.flush();
            return null;
        }
        CollectionManager dcm = fc.getDatasetCollectionManager();
        pw.printf("<h3>Collection Name %s</h3>%n", dcm.getCollectionName());
        if (trigger) {
            if (!fc.getConfig().isTrigggerOk()) {
                res.setStatus(403);
                pw.printf(" TRIGGER NOT ENABLED%n", new Object[0]);
                pw.flush();
                return null;
            }
            CollectionUpdater.INSTANCE.triggerUpdate(dcm.getCollectionName(), nocheck ? NOCHECK : TRIGGER);
            pw.printf(" TRIGGER SENT%n", new Object[0]);
        } else {
            this.showFiles(pw, dcm);
            String ename = StringUtil2.escape((String)fc.getName(), (String)"");
            String url = this.tdsContext.getContextPath() + PATH + "/trigger?" + COLLECTION + "=" + ename;
            pw.printf("<p/><a href='%s'>Trigger rescan for %s</a>%n", url, fc.getName());
        }
        pw.flush();
        return null;
    }

    private void showFiles(PrintWriter pw, CollectionManager dcm) {
        boolean unscanned;
        boolean bl = unscanned = dcm.getLastScanned() == 0L;
        if (unscanned) {
            pw.printf("%n<pre>Not Yet Scanned%n", new Object[0]);
            return;
        }
        pw.printf("%n<pre>Last Scanned %-20s%n", CalendarDateFormatter.toDateTimeString((Date)new Date(dcm.getLastScanned())));
        pw.printf("%n%-100s %-20s %9.3s %s%n", "Path", "Last Modified", "MB", "Aux");
        for (MFile mfile : dcm.getFiles()) {
            pw.printf("%-100s %-20s %9.3f %s%n", mfile.getPath(), CalendarDateFormatter.toDateTimeString((Date)new Date(mfile.getLastModified())), (double)mfile.getLength() / 1000000.0, mfile.getAuxInfo());
        }
        pw.printf("</pre>%n", new Object[0]);
    }

    @RequestMapping(value={"/fmrcCache", "/fmrcCache/*"})
    protected ModelAndView showFmrcCache(HttpServletRequest req, HttpServletResponse res) throws Exception {
        String path = TdsPathUtils.extractPath(req, "admin/");
        if (path.endsWith(STATISTICS)) {
            res.setContentType(ContentType.text.getContentHeader());
            Formatter f = new Formatter();
            this.monitor.getCacheStatistics(f);
            String s = f.toString();
            PrintWriter pw = res.getWriter();
            pw.println(s);
            pw.flush();
            return null;
        }
        String collectName = req.getParameter(COLLECTION);
        String fileName = req.getParameter(FILE);
        String cmd = req.getParameter(CMD);
        if (fileName != null) {
            String contents = this.monitor.getCachedFile(collectName, fileName);
            if (null == contents) {
                res.setContentType(ContentType.html.getContentHeader());
                PrintWriter pw = res.getWriter();
                pw.println("<p/> Cant find filename=" + fileName + " in collection = " + collectName);
            } else {
                res.setContentType(ContentType.xml.getContentHeader());
                PrintWriter pw = res.getWriter();
                pw.println(contents);
            }
            return null;
        }
        if (collectName != null) {
            String ecollectName = StringUtil2.escape((String)collectName, (String)"");
            String url = this.tdsContext.getContextPath() + FMRC_PATH + "?" + COLLECTION + "=" + ecollectName;
            res.setContentType(ContentType.html.getContentHeader());
            PrintWriter pw = res.getWriter();
            pw.println("Files for collection = " + collectName + "");
            String deleteUrl = this.tdsContext.getContextPath() + FMRC_PATH + "?" + COLLECTION + "=" + ecollectName + "&" + CMD + "=delete";
            pw.println("<a href='" + deleteUrl + "'> Delete" + "</a>");
            pw.println("<ol>");
            for (String filename : this.monitor.getFilesInCollection(collectName)) {
                String efileName = StringUtil2.escape((String)filename, (String)"");
                pw.println("<li> <a href='" + url + "&" + FILE + "=" + efileName + "'>" + filename + "</a>");
            }
            pw.println("</ol>");
        }
        if (cmd != null && cmd.equals("delete")) {
            res.setContentType(ContentType.html.getContentHeader());
            PrintWriter pw = res.getWriter();
            try {
                this.monitor.deleteCollection(collectName);
                pw.println("<p/>deleted");
            }
            catch (Exception e) {
                pw.println("<pre>delete failed on collection = " + collectName);
                e.printStackTrace(pw);
                pw.println("</pre>");
            }
        }
        return null;
    }
}

