/*
 * Decompiled with CFR 0.152.
 */
package thredds.server.cdmremote;

import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.util.MultiValueMap;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import thredds.server.cdmremote.params.CdmrfQueryBean;
import thredds.server.cdmremote.service.FeatureDatasetPointService;
import thredds.server.cdmremote.stream.CdmrfStreamFactory;
import thredds.server.cdmremote.view.CdmrfTextViewFactory;
import thredds.server.config.TdsContext;
import thredds.servlet.ServletUtil;
import ucar.nc2.ft.FeatureDatasetPoint;

@Deprecated
@Controller
@RequestMapping(value={"/cdmrfeature"})
public class CdmrfController {
    private static final String CDMRF_BASE_SERVICE = "/cdmrfeature/";
    @Autowired
    private TdsContext tdsContext;
    @Autowired
    private FeatureDatasetPointService fdps;
    private boolean allow = true;

    @RequestMapping(value={"/**"}, params={"req!=data", "req!=dataForm", "req!=header"}, method={RequestMethod.GET})
    public ResponseEntity<String> metadataRequestHandler(HttpServletRequest req, HttpServletResponse res, @Valid CdmrfQueryBean query, BindingResult validationResult) throws IOException {
        if (!this.allow) {
            res.sendError(403, "Service not supported");
            return null;
        }
        if (validationResult.hasErrors()) {
            // empty if block
        }
        String absPath = ServletUtil.getRequestServer(req) + req.getContextPath() + req.getServletPath();
        String path = this.getPathForDataset(req);
        FeatureDatasetPoint fdp = this.fdps.findFeatureDatasetPointByPath(req, res, path);
        String content = CdmrfTextViewFactory.getInstance().getFormViewForDataset(req, res, fdp, absPath, query);
        HttpHeaders responseHeaders = new HttpHeaders();
        responseHeaders.setContentLength((long)content.length());
        responseHeaders.setContentType(query.getMediaType());
        return new ResponseEntity((Object)content, (MultiValueMap)responseHeaders, HttpStatus.OK);
    }

    @RequestMapping(value={"/**"}, params={"req=header"}, method={RequestMethod.GET})
    public void headerRequestHandler(HttpServletRequest req, HttpServletResponse res, @Valid CdmrfQueryBean query, BindingResult validationResult) throws IOException {
        if (!this.allow) {
            res.sendError(403, "Service not supported");
            return;
        }
        if (validationResult.hasErrors()) {
            // empty if block
        }
        String absPath = ServletUtil.getRequestServer(req) + req.getContextPath() + req.getServletPath();
        String path = this.getPathForDataset(req);
        FeatureDatasetPoint fdp = this.fdps.findFeatureDatasetPointByPath(req, res, path);
        CdmrfStreamFactory.getInstance(this.tdsContext).headerStream(absPath, res, fdp, query);
    }

    @RequestMapping(value={"/**"}, params={"req=data"}, method={RequestMethod.GET})
    public void dataRequestHandler(HttpServletRequest req, HttpServletResponse res, @Valid CdmrfQueryBean query, BindingResult validationResult) throws IOException {
        if (!this.allow) {
            res.sendError(403, "Service not supported");
            return;
        }
        if (validationResult.hasErrors()) {
            // empty if block
        }
        String absPath = ServletUtil.getRequestServer(req) + req.getContextPath() + req.getServletPath();
        String path = this.getPathForDataset(req);
        FeatureDatasetPoint fdp = this.fdps.findFeatureDatasetPointByPath(req, res, path);
        CdmrfStreamFactory.getInstance(this.tdsContext).dataStream(req, res, fdp, path, query);
    }

    private String getPathForDataset(HttpServletRequest req) {
        return req.getServletPath().substring(CDMRF_BASE_SERVICE.length(), req.getServletPath().length());
    }
}

