/*
 * Decompiled with CFR 0.152.
 */
package thredds.server.radarServer;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;

public class RadarStationCollection {
    private static final long serialVersionUID = 20100119L;
    String dir;
    boolean stnTime = true;
    boolean stnProduct = false;
    String stnName;
    String product = null;
    boolean standardName = true;
    String suffix = ".ar2v";
    ArrayList<String> yyyymmdd = new ArrayList();
    HashMap<String, ArrayList<String>> hhmm = new HashMap();

    public RadarStationCollection() {
    }

    public RadarStationCollection(String dir, String stnName, boolean type, String product) {
        StringBuffer sb = new StringBuffer(dir);
        this.stnTime = type;
        this.stnName = stnName;
        this.product = product;
        this.dir = this.stnTime ? (product == null ? dir : sb.append("/").append(product).toString()) : (product == null ? dir : sb.append("/").append(product).append("/").toString());
    }

    public final ArrayList<String> getDays() {
        return this.yyyymmdd;
    }

    public final ArrayList<String> getHourMinute(String day) {
        return this.hhmm.get(day);
    }

    public String getDir() {
        return this.dir;
    }

    public boolean isStnTime() {
        return this.stnTime;
    }

    public boolean isStnProduct() {
        return this.stnProduct;
    }

    public String getStnName() {
        return this.stnName;
    }

    public String getProduct() {
        return this.product;
    }

    public boolean isStandardName() {
        return this.standardName;
    }

    public ArrayList<String> getYyyymmdd() {
        return this.yyyymmdd;
    }

    public HashMap<String, ArrayList<String>> getHhmm() {
        return this.hhmm;
    }

    public void setDir(String dir) {
        this.dir = dir;
    }

    public void setStnTime(boolean stnTime) {
        this.stnTime = stnTime;
    }

    public void setStnProduct(boolean stnProduct) {
        this.stnProduct = stnProduct;
    }

    public void setStnName(String stnName) {
        this.stnName = stnName;
    }

    public void setProduct(String product) {
        this.product = product;
    }

    public void setStandardName(boolean standardName) {
        this.standardName = standardName;
    }

    public void setSuffix(String suffix) {
        this.suffix = suffix;
    }

    public void setYyyymmdd(ArrayList<String> yyyymmdd) {
        this.yyyymmdd = yyyymmdd;
    }

    public void setHhmm(HashMap<String, ArrayList<String>> hhmm) {
        this.hhmm = hhmm;
    }

    public boolean write(PrintStream ps) {
        ObjectOutputStream out = null;
        try {
            out = new ObjectOutputStream(ps);
            out.writeObject(this);
            out.close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        return true;
    }

    public RadarStationCollection read(String sfile) {
        RadarStationCollection rdc = null;
        FileInputStream fis = null;
        ObjectInputStream in = null;
        try {
            fis = new FileInputStream(sfile);
            in = new ObjectInputStream(fis);
            rdc = (RadarStationCollection)in.readObject();
            in.close();
            return rdc;
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        catch (ClassNotFoundException ex) {
            ex.printStackTrace();
        }
        return null;
    }

    public static void main(String[] args) throws IOException {
        String tdir = null;
        boolean type = true;
        String day = null;
        String product = null;
        if (args.length != 4) {
            System.out.println("Not the correct parameters: tdir, structType, day, product");
            return;
        }
        tdir = args[0];
        type = args[1].equals("true");
        day = args[2];
        product = args[3].equals("null") ? null : args[3];
        RadarStationCollection rdc = new RadarStationCollection();
    }

    protected class CompareKeyDescend
    implements Comparator<String> {
        protected CompareKeyDescend() {
        }

        @Override
        public int compare(String s1, String s2) {
            return s2.compareTo(s1);
        }
    }
}

