/*
 * Decompiled with CFR 0.152.
 */
package thredds.server.dl;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.URI;
import java.net.URISyntaxException;
import javax.annotation.PostConstruct;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import thredds.catalog.InvCatalogFactory;
import thredds.catalog.InvCatalogImpl;
import thredds.catalog.dl.ADNWriter;
import thredds.catalog.dl.DIFWriter;
import thredds.server.config.TdsContext;
import thredds.servlet.HtmlWriter;
import thredds.servlet.ServletUtil;
import thredds.servlet.ThreddsConfig;
import thredds.util.ContentType;
import ucar.nc2.constants.CDM;
import ucar.nc2.util.IO;
import ucar.unidata.util.StringUtil2;

@Controller
@RequestMapping(value={"/DLwriter"})
public class DLwriterController {
    private static Logger log = LoggerFactory.getLogger(DLwriterController.class);
    private static Logger logServerStartup = LoggerFactory.getLogger((String)"serverStartup");
    @Autowired
    private TdsContext tdsContext;
    private String adnDir;
    private String difDir;
    private boolean allow;
    private boolean allowRemote;

    @PostConstruct
    public void init() throws ServletException {
        this.allow = ThreddsConfig.getBoolean("DLwriter.allow", false);
        if (!this.allow) {
            logServerStartup.info("DLwriterServlet.init(): DLwriter service not enabled in threddsConfig.xml: ");
            return;
        }
        this.allowRemote = ThreddsConfig.getBoolean("DLwriter.allowRemote", false);
        String contentPath = this.tdsContext.getContentRootPath();
        this.adnDir = contentPath + "/adn/";
        this.difDir = contentPath + "/dif/";
        File file = new File(this.adnDir);
        file.mkdirs();
        file = new File(this.difDir);
        file.mkdirs();
        logServerStartup.info("DLwriterServlet.init() - done: ");
    }

    @RequestMapping(value={"**"})
    public void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        if (!this.allow) {
            res.sendError(403, "DLwriter service not supported");
            log.debug("doGet(): DLwriter service not enabled in threddsConfig.xml.");
            return;
        }
        try {
            URI catUri;
            String type = req.getParameter("type");
            String catURL = req.getParameter("catalog");
            if (catURL == null || catURL.length() == 0) {
                catURL = ServletUtil.getContextPath() + "/idd/models.xml";
            }
            try {
                catUri = new URI(catURL);
            }
            catch (URISyntaxException e) {
                res.sendError(403, "Given catalog URL not a URL.");
                log.debug("doGet(): Given catalog URL not a URL", (Throwable)e);
                return;
            }
            if (catUri.isAbsolute() && !this.allowRemote) {
                res.sendError(403, "Given catalog URL not allowed (remote).");
                log.debug("doGet(): Given catalog URL was absolute, remote catalog handling not enabled.");
                return;
            }
            boolean isDIF = type == null || type.equals("DIF");
            this.doit(req, res, catURL, isDIF);
        }
        catch (Throwable t) {
            log.error("doGet(): req= " + ServletUtil.getRequest(req) + " got Exception", t);
            ServletUtil.handleException(t, res);
        }
    }

    private void doit(HttpServletRequest req, HttpServletResponse res, String catURL, boolean isDIF) throws IOException {
        DIFWriter writer;
        InvCatalogImpl catalog;
        URI catURI;
        try {
            URI reqURI = new URI(req.getRequestURL().toString());
            catURI = reqURI.resolve(catURL);
        }
        catch (URISyntaxException e) {
            res.sendError(403, "Given catalog URL not a URL.");
            log.debug("doGet(): Given catalog URL not a URL", (Throwable)e);
            return;
        }
        InvCatalogFactory catFactory = InvCatalogFactory.getDefaultFactory((boolean)false);
        try {
            catalog = catFactory.readXML(catURI);
        }
        catch (Exception e) {
            ServletUtil.handleException(e, res);
            return;
        }
        StringBuilder sb = new StringBuilder();
        if (!catalog.check(sb, false)) {
            res.setContentType(ContentType.html.getContentHeader());
            res.setHeader("Validate", "FAIL");
            PrintWriter pw = new PrintWriter((OutputStream)res.getOutputStream());
            this.showValidationMesssage(catURI.toString(), sb.toString(), pw);
            pw.flush();
            return;
        }
        StringBuilder mess = new StringBuilder();
        mess.append("Catalog ").append(catURI.toString()).append("\n\n");
        if (isDIF) {
            mess.append("DIF records:\n");
            writer = new DIFWriter();
            writer.writeDatasetEntries(catalog, this.difDir, mess);
        } else {
            mess.append("ADN records:\n");
            writer = new ADNWriter();
            mess.setLength(0);
            writer.writeDatasetEntries(catalog, this.adnDir, mess);
        }
        res.setContentType(ContentType.html.getContentHeader());
        ServletOutputStream out = res.getOutputStream();
        out.write(mess.toString().getBytes(CDM.utf8Charset));
        out.flush();
    }

    private void showValidationMesssage(String catURL, String mess, PrintWriter pw) {
        pw.println(HtmlWriter.getInstance().getHtmlDoctypeAndOpenTag());
        pw.println("<head>");
        pw.println("<title> Catalog Validation</title>");
        pw.println("<meta http-equiv=\"Content-Type\" content=\"text/html\">");
        pw.println("</head>");
        pw.println("<body bgcolor=\"#FFF0FF\">");
        pw.println("<h2> Catalog " + catURL + " has validation errors:</h2>");
        pw.println("<b>");
        pw.println(StringUtil2.quoteHtmlContent((String)mess));
        pw.println("</b>");
        pw.println("<hr><pre>");
        String catString = IO.readURLcontents((String)catURL);
        pw.println(StringUtil2.quoteHtmlContent((String)catString));
        pw.println("</pre>");
        pw.println("</body>");
        pw.println("</html>");
    }
}

