/*
 * Decompiled with CFR 0.152.
 */
package thredds.server.ncss.controller;

import java.io.File;
import java.io.IOException;
import java.text.ParseException;
import java.util.List;
import java.util.Random;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import thredds.server.ncss.controller.GridDatasetResponder;
import thredds.server.ncss.controller.NcssDiskCache;
import thredds.server.ncss.exception.InvalidBBOXException;
import thredds.server.ncss.exception.NcssException;
import thredds.server.ncss.exception.OutOfBoundariesException;
import thredds.server.ncss.exception.RequestTooLargeException;
import thredds.server.ncss.exception.TimeOutOfWindowException;
import thredds.server.ncss.exception.UnsupportedOperationException;
import thredds.server.ncss.exception.VariableNotContainedInDatasetException;
import thredds.server.ncss.params.NcssParamsBean;
import thredds.servlet.ThreddsConfig;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.Range;
import ucar.nc2.NetcdfFileWriter;
import ucar.nc2.dataset.CoordinateAxis1D;
import ucar.nc2.dt.GridCoordSystem;
import ucar.nc2.dt.GridDatatype;
import ucar.nc2.dt.grid.CFGridWriter;
import ucar.nc2.dt.grid.GridDataset;
import ucar.nc2.time.CalendarDate;
import ucar.nc2.time.CalendarDateRange;
import ucar.nc2.util.Misc;
import ucar.unidata.geoloc.LatLonPoint;
import ucar.unidata.geoloc.LatLonPointImpl;
import ucar.unidata.geoloc.LatLonRect;
import ucar.unidata.geoloc.ProjectionRect;

class GridResponder
extends GridDatasetResponder {
    private static final short ESTIMATED_C0MPRESION_RATE = 5;
    private GridDataset gds;
    private String requestPathInfo;
    private long maxFileDownloadSize;

    public static GridResponder factory(GridDataset gds, String requestPathInfo) {
        return new GridResponder(gds, requestPathInfo);
    }

    private GridResponder(GridDataset gds, String requestPathInfo) {
        this.gds = gds;
        this.requestPathInfo = requestPathInfo;
    }

    File getResponseFile(HttpServletRequest request, HttpServletResponse response, NcssParamsBean params, NetcdfFileWriter.Version version) throws NcssException, InvalidRangeException, ParseException, IOException {
        if (!this.checkRequestedVars(this.gds, params) && params.getVertCoord() != null) {
            throw new UnsupportedOperationException("The variables requested: " + params.getVar() + " have different vertical levels. Grid requests with vertCoord must have variables with same vertical levels.");
        }
        File netcdfResult = null;
        netcdfResult = this.isSpatialSubset(params) ? this.spatialSubset(params, version) : this.coordinatesSubset(params, response, version);
        return netcdfResult;
    }

    private boolean isSpatialSubset(NcssParamsBean params) throws InvalidBBOXException {
        boolean spatialSubset = false;
        int contValid = 0;
        if (params.getNorth() != null) {
            ++contValid;
        }
        if (params.getSouth() != null) {
            ++contValid;
        }
        if (params.getEast() != null) {
            ++contValid;
        }
        if (params.getWest() != null) {
            ++contValid;
        }
        if (contValid == 4) {
            if (params.getNorth() < params.getSouth()) {
                throw new InvalidBBOXException("Invalid bbox. Bounding Box must have north > south");
            }
            if (params.getEast() < params.getWest()) {
                throw new InvalidBBOXException("Invalid bbox. Bounding Box must have east > west; if crossing 180 meridian, use east boundary > 180");
            }
            spatialSubset = true;
        } else {
            if (contValid > 0) {
                throw new InvalidBBOXException("Invalid bbox. All params north, south, east and west must be provided");
            }
            if (params.getMaxx() == null && params.getMinx() == null && params.getMaxy() == null && params.getMiny() == null) {
                spatialSubset = true;
            }
        }
        return spatialSubset;
    }

    private File spatialSubset(NcssParamsBean params, NetcdfFileWriter.Version version) throws RequestTooLargeException, OutOfBoundariesException, InvalidRangeException, ParseException, IOException, VariableNotContainedInDatasetException, InvalidBBOXException, TimeOutOfWindowException {
        LatLonRect maxBB = this.gds.getBoundingBox();
        LatLonRect requestedBB = this.setBBForRequest(params, this.gds);
        boolean hasBB = !Misc.closeEnough((double)requestedBB.getUpperRightPoint().getLatitude(), (double)maxBB.getUpperRightPoint().getLatitude()) || !Misc.closeEnough((double)requestedBB.getLowerLeftPoint().getLatitude(), (double)maxBB.getLowerLeftPoint().getLatitude()) || !Misc.closeEnough((double)requestedBB.getUpperRightPoint().getLongitude(), (double)maxBB.getUpperRightPoint().getLongitude()) || !Misc.closeEnough((double)requestedBB.getLowerLeftPoint().getLongitude(), (double)maxBB.getLowerLeftPoint().getLongitude());
        Range zRange = null;
        if (params.getVertCoord() != null || params.getVertStride() > 1) {
            zRange = this.getZRange(this.gds, params.getVertCoord(), params.getVertStride(), params.getVar());
        }
        List<CalendarDate> wantedDates = this.getRequestedDates(this.gds, params);
        CalendarDateRange wantedDateRange = null;
        if (!wantedDates.isEmpty()) {
            wantedDateRange = CalendarDateRange.of((CalendarDate)wantedDates.get(0), (CalendarDate)wantedDates.get(wantedDates.size() - 1));
        }
        CFGridWriter writer = new CFGridWriter();
        this.maxFileDownloadSize = ThreddsConfig.getBytes("NetcdfSubsetService.maxFileDownloadSize", -1L);
        if (this.maxFileDownloadSize > 0L) {
            long estimatedSize = writer.makeGridFileSizeEstimate((ucar.nc2.dt.GridDataset)this.gds, params.getVar(), (LatLonRect)(hasBB ? requestedBB : null), params.getHorizStride().intValue(), zRange, wantedDateRange, params.getTimeStride().intValue(), params.isAddLatLon());
            if (version == NetcdfFileWriter.Version.netcdf4) {
                estimatedSize /= 5L;
            }
            if (estimatedSize > this.maxFileDownloadSize) {
                throw new RequestTooLargeException("NCSS response too large = " + estimatedSize + " max = " + this.maxFileDownloadSize);
            }
        }
        return this.makeGridFile(new CFGridWriter(), this.gds, params.getVar(), (LatLonRect)(hasBB ? requestedBB : null), params.getHorizStride(), zRange, wantedDateRange, params.getTimeStride(), params.isAddLatLon(), version);
    }

    private File coordinatesSubset(NcssParamsBean params, HttpServletResponse response, NetcdfFileWriter.Version version) throws OutOfBoundariesException, ParseException, InvalidRangeException, RequestTooLargeException, IOException, InvalidBBOXException, TimeOutOfWindowException {
        Double minx = params.getMinx();
        Double maxx = params.getMaxx();
        Double miny = params.getMiny();
        Double maxy = params.getMaxy();
        int contValid = 0;
        if (minx != null) {
            ++contValid;
        }
        if (maxx != null) {
            ++contValid;
        }
        if (miny != null) {
            ++contValid;
        }
        if (maxy != null) {
            ++contValid;
        }
        if (contValid == 4) {
            if (minx > maxx) {
                throw new InvalidBBOXException("Invalid bbox. Bounding Box must have minx < maxx");
            }
            if (miny > maxy) {
                throw new InvalidBBOXException("Invalid bbox. Bounding Box must have miny < maxy");
            }
        } else {
            throw new InvalidBBOXException("Invalid bbox. All params minx, maxx. miny, maxy must be provided");
        }
        ProjectionRect rect = new ProjectionRect(minx.doubleValue(), miny.doubleValue(), maxx.doubleValue(), maxy.doubleValue());
        Range zRange = null;
        if (params.getVertCoord() != null || params.getVertStride() > 1) {
            zRange = this.getZRange(this.gds, params.getVertCoord(), params.getVertStride(), params.getVar());
        }
        List<CalendarDate> wantedDates = this.getRequestedDates(this.gds, params);
        CalendarDateRange wantedDateRange = CalendarDateRange.of((CalendarDate)wantedDates.get(0), (CalendarDate)wantedDates.get(wantedDates.size() - 1));
        CFGridWriter writer = new CFGridWriter();
        this.maxFileDownloadSize = ThreddsConfig.getBytes("NetcdfSubsetService.maxFileDownloadSize", -1L);
        if (this.maxFileDownloadSize > 0L) {
            long estimatedSize = writer.makeGridFileSizeEstimate((ucar.nc2.dt.GridDataset)this.gds, params.getVar(), rect, params.getHorizStride().intValue(), zRange, wantedDateRange, params.getTimeStride().intValue(), params.isAddLatLon());
            if (version == NetcdfFileWriter.Version.netcdf4) {
                estimatedSize /= 5L;
            }
            if (estimatedSize > this.maxFileDownloadSize) {
                throw new RequestTooLargeException("NCSS response too large = " + estimatedSize + " max = " + this.maxFileDownloadSize);
            }
        }
        String filename = this.gds.getLocationURI();
        int pos = filename.lastIndexOf("/");
        if (!(filename = filename.substring(pos + 1)).endsWith(".nc")) {
            filename = filename + ".nc";
        }
        Random random = new Random(System.currentTimeMillis());
        int randomInt = random.nextInt();
        String pathname = Integer.toString(randomInt) + "/" + filename;
        File ncFile = NcssDiskCache.getInstance().getDiskCache().getCacheFile(pathname);
        String cacheFilename = ncFile.getPath();
        writer.makeFile(cacheFilename, (ucar.nc2.dt.GridDataset)this.gds, params.getVar(), rect, params.getHorizStride().intValue(), zRange, wantedDateRange, 1, params.isAddLatLon(), version);
        return new File(cacheFilename);
    }

    private LatLonRect setBBForRequest(NcssParamsBean params, GridDataset gds) throws InvalidBBOXException {
        if (params.getNorth() == null && params.getSouth() == null && params.getWest() == null && params.getEast() == null) {
            return gds.getBoundingBox();
        }
        return new LatLonRect((LatLonPoint)new LatLonPointImpl(params.getSouth().doubleValue(), params.getWest().doubleValue()), params.getNorth() - params.getSouth(), params.getEast() - params.getWest());
    }

    private Range getZRange(GridDataset gds, Double verticalCoord, Integer vertStride, List<String> vars) throws OutOfBoundariesException {
        boolean hasVerticalCoord = false;
        Range zRange = null;
        if (verticalCoord != null) {
            boolean bl = hasVerticalCoord = !Double.isNaN(verticalCoord);
            if (hasVerticalCoord) {
                try {
                    for (String varName : vars) {
                        GridDatatype grid = gds.findGridDatatype(varName);
                        GridCoordSystem gcs = grid.getCoordinateSystem();
                        CoordinateAxis1D vaxis = gcs.getVerticalAxis();
                        if (vaxis == null || vaxis.getSize() <= 1L) continue;
                        int bestIndex = -1;
                        double bestDiff = Double.MAX_VALUE;
                        int i = 0;
                        while ((long)i < vaxis.getSize()) {
                            double diff = Math.abs(vaxis.getCoordValue(i) - verticalCoord);
                            if (diff < bestDiff) {
                                bestIndex = i;
                                bestDiff = diff;
                            }
                            ++i;
                        }
                        if (bestIndex < 0) continue;
                        zRange = new Range(bestIndex, bestIndex);
                    }
                }
                catch (InvalidRangeException ire) {
                    throw new OutOfBoundariesException("Invalid vertical level: " + ire.getMessage());
                }
            }
        } else if (vertStride > 1) {
            try {
                zRange = new Range(0, 0, vertStride.intValue());
                for (String varName : vars) {
                    GridDatatype grid = gds.findGridDatatype(varName);
                    GridCoordSystem gcs = grid.getCoordinateSystem();
                    CoordinateAxis1D vaxis = gcs.getVerticalAxis();
                    if (vaxis == null) continue;
                    zRange = new Range(zRange.first(), (long)zRange.last() > vaxis.getSize() ? zRange.last() : (int)vaxis.getSize() - 1, vertStride.intValue());
                }
            }
            catch (InvalidRangeException ire) {
                throw new OutOfBoundariesException("Invalid vertical stride: " + ire.getMessage());
            }
        }
        return zRange;
    }

    private File makeGridFile(CFGridWriter writer, GridDataset gds, List<String> vars, LatLonRect bbox, Integer horizStride, Range zRange, CalendarDateRange dateRange, Integer timeStride, boolean addLatLon, NetcdfFileWriter.Version version) throws RequestTooLargeException, InvalidRangeException, IOException {
        Random random = new Random(System.currentTimeMillis());
        int randomInt = random.nextInt();
        String filename = this.getFileNameForResponse(version);
        String pathname = Integer.toString(randomInt) + "/" + filename;
        File ncFile = NcssDiskCache.getInstance().getDiskCache().getCacheFile(pathname);
        String cacheFilename = ncFile.getPath();
        writer.makeFile(cacheFilename, (ucar.nc2.dt.GridDataset)gds, vars, bbox, horizStride.intValue(), zRange, dateRange, timeStride.intValue(), addLatLon, version);
        return new File(cacheFilename);
    }

    private String getFileNameForResponse(NetcdfFileWriter.Version version) {
        String fileExtension = ".nc";
        if (version == NetcdfFileWriter.Version.netcdf4) {
            fileExtension = ".nc4";
        }
        String[] tmp = this.requestPathInfo.split("/");
        StringBuilder sb = new StringBuilder();
        sb.append(tmp[tmp.length - 2]).append("_").append(tmp[tmp.length - 1]);
        String filename = sb.toString().split("\\.")[0] + fileExtension;
        return filename;
    }
}

