/*
 * Decompiled with CFR 0.152.
 */
package thredds.server.ncss.params;

import java.text.ParseException;
import java.util.Date;
import java.util.Formatter;
import java.util.List;
import org.springframework.format.annotation.DateTimeFormat;
import thredds.server.ncss.exception.NcssException;
import thredds.server.ncss.validation.NcssRequestConstraint;
import thredds.server.ncss.validation.TimeParamsConstraint;
import thredds.server.ncss.validation.VarParamConstraint;
import ucar.nc2.ft.FeatureDataset;
import ucar.nc2.time.Calendar;
import ucar.nc2.time.CalendarDate;
import ucar.nc2.time.CalendarDateFormatter;
import ucar.nc2.time.CalendarDateRange;
import ucar.nc2.units.DateRange;
import ucar.nc2.units.DateType;
import ucar.nc2.units.TimeDuration;
import ucar.unidata.geoloc.LatLonPoint;
import ucar.unidata.geoloc.LatLonPointImpl;
import ucar.unidata.geoloc.LatLonRect;

@TimeParamsConstraint
@NcssRequestConstraint
public class NcssParamsBean {
    private String accept;
    @VarParamConstraint
    private List<String> var;
    @DateTimeFormat
    private String time_start;
    @DateTimeFormat
    private String time_end;
    @DateTimeFormat
    private String time_duration;
    @DateTimeFormat
    private String time_window;
    @DateTimeFormat
    private String time;
    private String temporal;
    private Double north;
    private Double south;
    private Double east;
    private Double west;
    private Double latitude;
    private Double longitude;
    private Double minx;
    private Double maxx;
    private Double miny;
    private Double maxy;
    private boolean addLatLon;
    private Integer horizStride = 1;
    private Integer timeStride = 1;
    private Double vertCoord;
    private Integer vertStride = 1;
    private List<String> stns;
    private boolean hasValidTime;
    private boolean hasValidDateRange;

    public String getAccept() {
        return this.accept;
    }

    public void setAccept(String accept) {
        this.accept = accept;
    }

    public List<String> getVar() {
        return this.var;
    }

    public void setVar(List<String> var) {
        this.var = var;
    }

    public String getTime_start() {
        return this.time_start;
    }

    public void setTime_start(String time_start) {
        this.time_start = time_start;
    }

    public String getTime_end() {
        return this.time_end;
    }

    public void setTime_end(String time_end) {
        this.time_end = time_end;
    }

    public String getTime_duration() {
        return this.time_duration;
    }

    public void setTime_duration(String time_duration) {
        this.time_duration = time_duration;
    }

    public String getTime_window() {
        return this.time_window;
    }

    public void setTime_window(String time_window) {
        this.time_window = time_window;
    }

    public String getTime() {
        return this.time;
    }

    public void setTime(String time) {
        this.time = time;
    }

    public Double getVertCoord() {
        return this.vertCoord;
    }

    public void setVertCoord(Double vertCoord) {
        this.vertCoord = vertCoord;
    }

    public Double getNorth() {
        return this.north;
    }

    public void setNorth(Double north) {
        this.north = north;
    }

    public Double getSouth() {
        return this.south;
    }

    public void setSouth(Double south) {
        this.south = south;
    }

    public Double getEast() {
        return this.east;
    }

    public void setEast(Double east) {
        this.east = east;
    }

    public Double getWest() {
        return this.west;
    }

    public void setWest(Double west) {
        this.west = west;
    }

    public Double getLatitude() {
        return this.latitude;
    }

    public void setLatitude(Double latitude) {
        this.latitude = latitude;
    }

    public Double getLongitude() {
        return this.longitude;
    }

    public void setLongitude(Double longitude) {
        this.longitude = longitude;
    }

    public Double getMinx() {
        return this.minx;
    }

    public void setMinx(Double minx) {
        this.minx = minx;
    }

    public Double getMaxx() {
        return this.maxx;
    }

    public void setMaxx(Double maxx) {
        this.maxx = maxx;
    }

    public Double getMiny() {
        return this.miny;
    }

    public void setMiny(Double miny) {
        this.miny = miny;
    }

    public Double getMaxy() {
        return this.maxy;
    }

    public void setMaxy(Double maxy) {
        this.maxy = maxy;
    }

    public boolean isAddLatLon() {
        return this.addLatLon;
    }

    public void setAddLatLon(boolean addLatLon) {
        this.addLatLon = addLatLon;
    }

    public Integer getHorizStride() {
        return this.horizStride;
    }

    public void setHorizStride(Integer horizStride) {
        this.horizStride = horizStride;
    }

    public Integer getTimeStride() {
        return this.timeStride;
    }

    public void setTimeStride(Integer timeStride) {
        this.timeStride = timeStride;
    }

    public Integer getVertStride() {
        return this.vertStride;
    }

    public void setVertStride(Integer vertStride) {
        this.vertStride = vertStride;
    }

    public List<String> getStns() {
        return this.stns;
    }

    public void setStns(List<String> stns) {
        this.stns = stns;
    }

    public boolean hasLatLonPoint() {
        return this.latitude != null && this.longitude != null;
    }

    public boolean hasLatLonBB() {
        return this.east != null && this.west != null && this.north != null && this.south != null;
    }

    public boolean hasProjectionBB() {
        return this.minx != null && this.miny != null && this.maxx != null && this.maxy != null;
    }

    public boolean hasStations() {
        return this.stns != null && !this.stns.isEmpty();
    }

    public String getTemporal() {
        return this.temporal;
    }

    public void setTemporal(String temporal) {
        this.temporal = temporal;
    }

    public boolean isAllTimes() {
        return this.temporal != null && this.temporal.equalsIgnoreCase("all");
    }

    public TimeDuration parseTimeDuration() throws NcssException {
        if (this.getTime_duration() == null) {
            return null;
        }
        try {
            return TimeDuration.parseW3CDuration((String)this.getTime_duration());
        }
        catch (ParseException e) {
            throw new NcssException("invalid time duration");
        }
    }

    public LatLonRect getBB() {
        double width = this.getEast() - this.getWest();
        double height = this.getNorth() - this.getSouth();
        return new LatLonRect((LatLonPoint)new LatLonPointImpl(this.getSouth().doubleValue(), this.getWest().doubleValue()), height, width);
    }

    public void setHasValidTime(boolean hasValidTime) {
        this.hasValidTime = hasValidTime;
    }

    public void setHasValidDateRange(boolean hasValidDateRange) {
        this.hasValidDateRange = hasValidDateRange;
    }

    public CalendarDateRange getCalendarDateRange(Calendar cal) throws ParseException {
        if (!this.hasValidDateRange) {
            return null;
        }
        DateRange dr = this.time == null ? new DateRange(new DateType(this.time_start, null, null, cal), new DateType(this.time_end, null, null, cal), new TimeDuration(this.time_duration), null) : new DateRange(new DateType(this.time, null, null, cal), new DateType(this.time, null, null, cal), new TimeDuration(this.time_duration), null);
        return CalendarDateRange.of((CalendarDate)dr.getStart().getCalendarDate(), (CalendarDate)dr.getEnd().getCalendarDate());
    }

    public CalendarDate getRequestedTime(Calendar cal) throws ParseException {
        if (!this.hasValidTime) {
            return null;
        }
        Object date = null;
        if (this.getTime().equalsIgnoreCase("present")) {
            java.util.Calendar c = java.util.Calendar.getInstance();
            c.setTime(new Date());
            return CalendarDate.of((Calendar)cal, (long)c.getTimeInMillis());
        }
        return CalendarDateFormatter.isoStringToCalendarDate((Calendar)cal, (String)this.getTime());
    }

    public boolean isValidGridRequest() {
        return true;
    }

    public boolean intersectsTime(FeatureDataset fd, Formatter errs) throws ParseException {
        CalendarDateRange have = fd.getCalendarDateRange();
        if (have == null) {
            return true;
        }
        Calendar dataCal = have.getStart().getCalendar();
        CalendarDateRange want = this.getCalendarDateRange(dataCal);
        if (want != null) {
            if (have.intersects(want)) {
                return true;
            }
            errs.format("Requested time range %s does not intersect actual time range %s", want, have);
            return false;
        }
        CalendarDate wantTime = this.getRequestedTime(dataCal);
        if (wantTime == null) {
            return true;
        }
        if (!have.includes(wantTime)) {
            errs.format("Requested time %s does not intersect actual time range %s", wantTime, have);
            return false;
        }
        return true;
    }
}

