/*
 * Decompiled with CFR 0.152.
 */
package thredds.wcs.v1_1_0;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.Namespace;
import org.jdom2.output.Format;
import org.jdom2.output.XMLOutputter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import thredds.wcs.v1_1_0.Request;
import ucar.nc2.dt.GridDataset;

public class GetCapabilities {
    private Logger logger = LoggerFactory.getLogger(GetCapabilities.class);
    protected static final Namespace wcsNS = Namespace.getNamespace((String)"http://www.opengis.net/wcs/1.1");
    protected static final Namespace owcsNS = Namespace.getNamespace((String)"owcs", (String)"http://www.opengis.net/wcs/1.1/ows");
    protected static final Namespace owsNS = Namespace.getNamespace((String)"ows", (String)"http://www.opengis.net/ows");
    protected static final Namespace xlinkNS = Namespace.getNamespace((String)"xlink", (String)"http://www.w3.org/1999/xlink");
    private URI serverURI;
    private List<Section> sections;
    private String version = "1.1.0";
    private ServiceId serviceId;
    private ServiceProvider serviceProvider;
    private GridDataset dataset;
    private Document capabilitiesReport;

    public GetCapabilities(URI serverURI, List<Section> sections, ServiceId serviceId, ServiceProvider serviceProvider, GridDataset dataset) {
        this.serverURI = serverURI;
        this.sections = sections;
        this.serviceId = serviceId;
        this.serviceProvider = serviceProvider;
        this.dataset = dataset;
        if (this.serverURI == null) {
            throw new IllegalArgumentException("Non-null server URI required.");
        }
        if (this.sections == null) {
            throw new IllegalArgumentException("Non-null sections list required (may be empty).");
        }
        if (this.dataset == null) {
            throw new IllegalArgumentException("Non-null dataset required.");
        }
    }

    public Document getCapabilitiesReport() {
        if (this.capabilitiesReport == null) {
            this.capabilitiesReport = this.generateCapabilities();
        }
        return this.capabilitiesReport;
    }

    public void writeCapabilitiesReport(PrintWriter pw) throws IOException {
        XMLOutputter xmlOutputter = new XMLOutputter(Format.getPrettyFormat());
        xmlOutputter.output(this.getCapabilitiesReport(), (Writer)pw);
    }

    public Document generateCapabilities() {
        Element capabilitiesElem = new Element("Capabilities", wcsNS);
        capabilitiesElem.addNamespaceDeclaration(owcsNS);
        capabilitiesElem.addNamespaceDeclaration(owsNS);
        capabilitiesElem.addNamespaceDeclaration(xlinkNS);
        capabilitiesElem.setAttribute("version", this.version);
        boolean allSections = false;
        if (this.sections == null || this.sections.size() == 0 || this.sections.size() == 1 && this.sections.get(0).equals((Object)Section.All)) {
            allSections = true;
        }
        if (allSections || this.sections.contains((Object)Section.ServiceIdentification)) {
            capabilitiesElem.addContent((Content)this.generateServiceIdentification(this.serviceId));
        }
        if (allSections || this.sections.contains((Object)Section.ServiceProvider)) {
            capabilitiesElem.addContent((Content)this.generateServiceProvider(this.serviceProvider));
        }
        if (allSections || this.sections.contains((Object)Section.OperationsMetadata)) {
            capabilitiesElem.addContent((Content)this.generateOperationsMetadata());
        }
        if (allSections || this.sections.contains((Object)Section.Contents)) {
            capabilitiesElem.addContent((Content)this.generateContents());
        }
        return new Document(capabilitiesElem);
    }

    public Element generateServiceIdentification(ServiceId serviceId) {
        Element serviceIdElem = new Element("ServiceIdentification", owcsNS);
        if (serviceId != null) {
            if (serviceId.getTitle() != null) {
                Element titleElem = new Element("Title", owsNS);
                titleElem.addContent(serviceId.getTitle());
                serviceIdElem.addContent((Content)titleElem);
            }
            if (serviceId.getAbstract() != null) {
                Element abstractElem = new Element("Abstract", owsNS);
                abstractElem.addContent(serviceId.getAbstract());
                serviceIdElem.addContent((Content)abstractElem);
            }
            if (serviceId.getKeywords() != null && serviceId.getKeywords().size() > 0) {
                Element keywordsElem = new Element("Keywords", owsNS);
                for (String curKey : serviceId.getKeywords()) {
                    Element keywordElem = new Element("Keyword", owsNS);
                    keywordElem.addContent(curKey);
                    keywordsElem.addContent((Content)keywordElem);
                }
                serviceIdElem.addContent((Content)keywordsElem);
            }
            if (serviceId.getServiceType() != null) {
                Element serviceTypeElem = new Element("ServiceType", owcsNS);
                serviceTypeElem.addContent(serviceId.getServiceType());
                serviceIdElem.addContent((Content)serviceTypeElem);
            }
            if (serviceId.getServiceTypeVersion() != null && serviceId.getServiceTypeVersion().size() > 0) {
                for (String curVer : serviceId.getServiceTypeVersion()) {
                    Element serviceTypeVersionElem = new Element("ServiceTypeVersion", owcsNS);
                    serviceTypeVersionElem.addContent(curVer);
                    serviceIdElem.addContent((Content)serviceTypeVersionElem);
                }
            }
            if (serviceId.getFees() != null) {
                Element feesElem = new Element("Fees", owcsNS);
                feesElem.addContent(serviceId.getFees());
                serviceIdElem.addContent((Content)feesElem);
            }
            if (serviceId.getAccessConstraints() != null && serviceId.getAccessConstraints().size() > 0) {
                for (String curAC : serviceId.getAccessConstraints()) {
                    Element accessConstraintsElem = new Element("AccessConstraints", owcsNS);
                    accessConstraintsElem.addContent(curAC);
                    serviceIdElem.addContent((Content)accessConstraintsElem);
                }
            }
        }
        return serviceIdElem;
    }

    public Element generateServiceProvider(ServiceProvider serviceProvider) {
        Element servProvElem = new Element("ServiceProvider", owsNS);
        if (serviceProvider != null) {
            if (serviceProvider.name != null) {
                servProvElem.addContent((Content)new Element("ProviderName", owsNS).addContent(serviceProvider.name));
            }
            if (serviceProvider.site != null) {
                Element provSiteElem = new Element("ProviderSite", owsNS);
                provSiteElem.setAttribute("type", "simple");
                if (serviceProvider.site.title != null) {
                    provSiteElem.setAttribute("title", serviceProvider.site.title, xlinkNS);
                }
                if (serviceProvider.site.link != null) {
                    provSiteElem.setAttribute("href", serviceProvider.site.link.toString(), xlinkNS);
                }
                servProvElem.addContent((Content)provSiteElem);
            }
            if (serviceProvider.contact != null) {
                Element servContactElem = new Element("ServiceContact", owsNS);
                if (serviceProvider.contact.individualName != null) {
                    Element individualNameElem = new Element("IndividualName", owsNS);
                    individualNameElem.addContent(serviceProvider.contact.individualName);
                    servContactElem.addContent((Content)individualNameElem);
                }
                if (serviceProvider.contact.positionName != null) {
                    Element positionNameElem = new Element("PositionName", owsNS);
                    positionNameElem.addContent(serviceProvider.contact.positionName);
                    servContactElem.addContent((Content)positionNameElem);
                }
                if (serviceProvider.contact.contactInfo != null) {
                    Element contactInfoElem = new Element("ContactInfo", owsNS);
                    if (serviceProvider.contact.contactInfo.voicePhone != null || serviceProvider.contact.contactInfo.faxPhone != null) {
                        Element phoneElem = new Element("Phone", owsNS);
                        if (serviceProvider.contact.contactInfo.voicePhone != null) {
                            for (String curPhone : serviceProvider.contact.contactInfo.voicePhone) {
                                phoneElem.addContent((Content)new Element("Voice", owsNS).addContent(curPhone));
                            }
                        }
                        if (serviceProvider.contact.contactInfo.faxPhone != null) {
                            for (String curPhone : serviceProvider.contact.contactInfo.faxPhone) {
                                phoneElem.addContent((Content)new Element("Facsimile", owsNS).addContent(curPhone));
                            }
                        }
                        contactInfoElem.addContent((Content)phoneElem);
                    }
                    if (serviceProvider.contact.contactInfo.address != null) {
                        Element addressElem = new Element("Address", owsNS);
                        if (serviceProvider.contact.contactInfo.address.deliveryPoint != null) {
                            for (String curDP : serviceProvider.contact.contactInfo.address.deliveryPoint) {
                                addressElem.addContent((Content)new Element("DeliveryPoint", owsNS).addContent(curDP));
                            }
                        }
                        if (serviceProvider.contact.contactInfo.address.city != null) {
                            addressElem.addContent((Content)new Element("City", owsNS).addContent(serviceProvider.contact.contactInfo.address.city));
                        }
                        if (serviceProvider.contact.contactInfo.address.adminArea != null) {
                            addressElem.addContent((Content)new Element("AdministrativeArea", owsNS).addContent(serviceProvider.contact.contactInfo.address.adminArea));
                        }
                        if (serviceProvider.contact.contactInfo.address.postalCode != null) {
                            addressElem.addContent((Content)new Element("PostalCode", owsNS).addContent(serviceProvider.contact.contactInfo.address.postalCode));
                        }
                        if (serviceProvider.contact.contactInfo.address.country != null) {
                            addressElem.addContent((Content)new Element("Country", owsNS).addContent(serviceProvider.contact.contactInfo.address.country));
                        }
                        if (serviceProvider.contact.contactInfo.address.email != null) {
                            for (String curEmail : serviceProvider.contact.contactInfo.address.email) {
                                addressElem.addContent((Content)new Element("ElectronicMailAddress", owsNS).addContent(curEmail));
                            }
                        }
                        contactInfoElem.addContent((Content)addressElem);
                    }
                    if (serviceProvider.contact.contactInfo.onlineResource != null) {
                        Element onlineResourceElem = new Element("OnlineResource", owsNS);
                        onlineResourceElem.setAttribute("type", "simple");
                        if (serviceProvider.contact.contactInfo.onlineResource.title != null) {
                            onlineResourceElem.setAttribute("title", serviceProvider.contact.contactInfo.onlineResource.title, xlinkNS);
                        }
                        if (serviceProvider.contact.contactInfo.onlineResource.link != null) {
                            onlineResourceElem.setAttribute("href", serviceProvider.contact.contactInfo.onlineResource.link.toString(), xlinkNS);
                        }
                        contactInfoElem.addContent((Content)onlineResourceElem);
                    }
                    if (serviceProvider.contact.contactInfo.hoursOfService != null) {
                        contactInfoElem.addContent((Content)new Element("HoursOfService", owsNS).addContent(serviceProvider.contact.contactInfo.hoursOfService));
                    }
                    if (serviceProvider.contact.contactInfo.contactInstructions != null) {
                        contactInfoElem.addContent((Content)new Element("ContactInstructions", owsNS).addContent(serviceProvider.contact.contactInfo.contactInstructions));
                    }
                    servContactElem.addContent((Content)contactInfoElem);
                }
                if (serviceProvider.contact.role != null) {
                    servContactElem.addContent((Content)new Element("Role", owsNS).addContent(serviceProvider.contact.role));
                }
                servProvElem.addContent((Content)servContactElem);
            }
        }
        return servProvElem;
    }

    public Element generateOperationsMetadata() {
        Element opsMetadataElem = new Element("OperationsMetadata", owcsNS);
        opsMetadataElem.addContent((Content)this.genGetCapOpsElement());
        opsMetadataElem.addContent((Content)this.genDescCovOpsElement());
        opsMetadataElem.addContent((Content)this.genGetCovOpsElement());
        return opsMetadataElem;
    }

    private Element genGetCapOpsElement() {
        Element getCapOpsElem = new Element("Operation", owcsNS);
        getCapOpsElem.setAttribute("name", Request.Operation.GetCapabilities.toString());
        getCapOpsElem.addContent((Content)new Element("DCP", owcsNS).addContent((Content)new Element("HTTP", owcsNS).addContent((Content)new Element("GET", owcsNS).setAttribute("href", this.serverURI.toString(), xlinkNS))));
        getCapOpsElem.addContent((Content)this.genParamElement("service", Collections.singletonList("WCS")));
        ArrayList<String> allowedValList = new ArrayList<String>();
        allowedValList.add("1.1.0");
        allowedValList.add("1.0.0");
        getCapOpsElem.addContent((Content)this.genParamElement("AcceptVersions", allowedValList));
        ArrayList<String> sectList = new ArrayList<String>();
        sectList.add("ServiceIdentification");
        sectList.add("ServiceProvider");
        sectList.add("OperationsMetadata");
        sectList.add("Content");
        sectList.add("All");
        getCapOpsElem.addContent((Content)this.genParamElement("Sections", sectList));
        return getCapOpsElem;
    }

    private Element genDescCovOpsElement() {
        Element descCovOpsElem = new Element("Operation", owcsNS);
        descCovOpsElem.setAttribute("name", Request.Operation.DescribeCoverage.toString());
        descCovOpsElem.addContent((Content)new Element("DCP", owcsNS).addContent((Content)new Element("HTTP", owcsNS).addContent((Content)new Element("GET", owcsNS).setAttribute("href", this.serverURI.toString(), xlinkNS))));
        descCovOpsElem.addContent((Content)this.genParamElement("service", Collections.singletonList("WCS")));
        descCovOpsElem.addContent((Content)this.genParamElement("version", Collections.singletonList("1.1.0")));
        ArrayList<String> idList = new ArrayList<String>();
        for (GridDataset.Gridset gs : this.dataset.getGridsets()) {
            idList.add(gs.getGeoCoordSystem().getName());
        }
        descCovOpsElem.addContent((Content)this.genParamElement("Identifier", idList));
        return descCovOpsElem;
    }

    private Element genGetCovOpsElement() {
        Element getCovOpsElem = new Element("Operation", owcsNS);
        getCovOpsElem.setAttribute("name", Request.Operation.GetCoverage.toString());
        getCovOpsElem.addContent((Content)new Element("DCP", owcsNS).addContent((Content)new Element("HTTP", owcsNS).addContent((Content)new Element("GET", owcsNS).setAttribute("href", this.serverURI.toString(), xlinkNS))));
        getCovOpsElem.addContent((Content)this.genParamElement("service", Collections.singletonList("WCS")));
        getCovOpsElem.addContent((Content)this.genParamElement("version", Collections.singletonList("1.1.0")));
        getCovOpsElem.addContent((Content)this.genParamElement("store", Collections.singletonList("False")));
        ArrayList<String> idList = new ArrayList<String>();
        for (GridDataset.Gridset gs : this.dataset.getGridsets()) {
            idList.add(gs.getGeoCoordSystem().getName());
        }
        getCovOpsElem.addContent((Content)this.genParamElement("Identifier", idList));
        return getCovOpsElem;
    }

    private Element genParamElement(String name, List<String> allowedValues) {
        Element paramElem = new Element("Parameter", owcsNS).setAttribute("name", name);
        Element allowedValuesElem = new Element("AllowedValues", owcsNS);
        for (String curVal : allowedValues) {
            allowedValuesElem.addContent((Content)new Element("Value", owcsNS).addContent(curVal));
        }
        return paramElem.addContent((Content)allowedValuesElem);
    }

    public Element generateContents() {
        Element contentElem = new Element("Contents", wcsNS);
        for (GridDataset.Gridset gs : this.dataset.getGridsets()) {
            Element curCovSum = new Element("CoverageSummary", wcsNS);
            curCovSum.addContent((Content)new Element("Title", owsNS).addContent(gs.getGeoCoordSystem().getName()));
            curCovSum.addContent((Content)new Element("SupportedFormats", owsNS).addContent("application/x-netcdf"));
            curCovSum.addContent((Content)new Element("Identifier", wcsNS).addContent(gs.getGeoCoordSystem().getName()));
            contentElem.addContent((Content)curCovSum);
        }
        return contentElem;
    }

    public static class ServiceProvider {
        private String name;
        private OnlineResource site;
        private ServiceContact contact;

        public ServiceProvider(String name, OnlineResource site, ServiceContact contact) {
            this.name = name;
            this.site = site;
            this.contact = contact;
        }

        public String getName() {
            return this.name;
        }

        public OnlineResource getSite() {
            return this.site;
        }

        public ServiceContact getContact() {
            return this.contact;
        }

        public static class Address {
            private List<String> deliveryPoint;
            private String city;
            private String adminArea;
            private String postalCode;
            private String country;
            private List<String> email;

            public Address(List<String> deliveryPoint, String city, String adminArea, String postalCode, String country, List<String> email) {
                this.deliveryPoint = new ArrayList<String>(deliveryPoint);
                this.city = city;
                this.adminArea = adminArea;
                this.postalCode = postalCode;
                this.country = country;
                this.email = new ArrayList<String>(email);
            }

            public List<String> getDeliveryPoint() {
                return Collections.unmodifiableList(this.deliveryPoint);
            }

            public String getCity() {
                return this.city;
            }

            public String getAdminArea() {
                return this.adminArea;
            }

            public String getPostalCode() {
                return this.postalCode;
            }

            public String getCountry() {
                return this.country;
            }

            public List<String> getEmail() {
                return Collections.unmodifiableList(this.email);
            }
        }

        public static class ContactInfo {
            private List<String> voicePhone;
            private List<String> faxPhone;
            private Address address;
            private OnlineResource onlineResource;
            private String hoursOfService;
            private String contactInstructions;

            public ContactInfo(List<String> voicePhone, List<String> faxPhone, Address address, OnlineResource onlineResource, String hoursOfService, String contactInstructions) {
                this.voicePhone = new ArrayList<String>(voicePhone);
                this.faxPhone = new ArrayList<String>(faxPhone);
                this.address = address;
                this.onlineResource = onlineResource;
                this.hoursOfService = hoursOfService;
                this.contactInstructions = contactInstructions;
            }

            public List<String> getVoicePhone() {
                return Collections.unmodifiableList(this.voicePhone);
            }

            public List<String> getFaxPhone() {
                return Collections.unmodifiableList(this.faxPhone);
            }

            public Address getAddress() {
                return this.address;
            }

            public OnlineResource getOnlineResource() {
                return this.onlineResource;
            }

            public String getHoursOfService() {
                return this.hoursOfService;
            }

            public String getContactInstructions() {
                return this.contactInstructions;
            }
        }

        public static class ServiceContact {
            private String individualName;
            private String positionName;
            private ContactInfo contactInfo;
            private String role;

            public ServiceContact(String individualName, String positionName, ContactInfo contactInfo, String role) {
                this.individualName = individualName;
                this.positionName = positionName;
                this.contactInfo = contactInfo;
                this.role = role;
            }

            public String getIndividualName() {
                return this.individualName;
            }

            public String getPositionName() {
                return this.positionName;
            }

            public ContactInfo getContactInfo() {
                return this.contactInfo;
            }

            public String getRole() {
                return this.role;
            }
        }

        public static class OnlineResource {
            private URI link;
            private String title;

            public OnlineResource(URI link, String title) {
                this.link = link;
                this.title = title;
            }

            public URI getLink() {
                return this.link;
            }

            public String getTitle() {
                return this.title;
            }
        }
    }

    public static class ServiceId {
        private String title;
        private String _abstract;
        private List<String> keywords;
        private String serviceType;
        private List<String> serviceTypeVersion;
        private String fees;
        private List<String> accessConstraints;

        public ServiceId(String title, String anAbstract, List<String> keywords, String serviceType, List<String> serviceTypeVersion, String fees, List<String> accessConstraints) {
            this.title = title;
            this._abstract = anAbstract;
            this.keywords = new ArrayList<String>(keywords);
            this.serviceType = serviceType;
            this.serviceTypeVersion = new ArrayList<String>(serviceTypeVersion);
            this.fees = fees;
            this.accessConstraints = new ArrayList<String>(accessConstraints);
        }

        public String getTitle() {
            return this.title;
        }

        public String getAbstract() {
            return this._abstract;
        }

        public List<String> getKeywords() {
            return Collections.unmodifiableList(this.keywords);
        }

        public String getServiceType() {
            return this.serviceType;
        }

        public List<String> getServiceTypeVersion() {
            return Collections.unmodifiableList(this.serviceTypeVersion);
        }

        public String getFees() {
            return this.fees;
        }

        public List<String> getAccessConstraints() {
            return Collections.unmodifiableList(this.accessConstraints);
        }
    }

    public static enum Section {
        ServiceIdentification,
        ServiceProvider,
        OperationsMetadata,
        Contents,
        All;

    }
}

