/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.iosp.fysat;

import java.awt.image.BufferedImage;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.Raster;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;
import javax.imageio.ImageIO;
import ucar.ma2.Array;
import ucar.ma2.ArrayByte;
import ucar.ma2.DataType;
import ucar.ma2.Index;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.Section;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Variable;
import ucar.nc2.iosp.AbstractIOServiceProvider;
import ucar.nc2.iosp.fysat.FysatHeader;
import ucar.nc2.iosp.fysat.util.EndianByteBuffer;
import ucar.nc2.util.CancelTask;
import ucar.unidata.io.RandomAccessFile;

public class Fysatiosp
extends AbstractIOServiceProvider {
    private NetcdfFile ncfile;
    protected FysatHeader headerParser;
    static final int Z_DEFLATED = 8;
    static final int DEF_WBITS = 15;
    protected boolean debug = false;
    protected boolean fill;

    public boolean isValidFile(RandomAccessFile raf) throws IOException {
        FysatHeader localHeader = new FysatHeader();
        return localHeader.isValidFile(raf);
    }

    public String getFileTypeId() {
        return "FYSAT";
    }

    public String getFileTypeDescription() {
        return "Chinese FY-2 satellite image data in AWX format";
    }

    public void open(RandomAccessFile raf, NetcdfFile file, CancelTask cancelTask) throws IOException {
        super.open(raf, this.ncfile, cancelTask);
        this.ncfile = file;
        this.headerParser = new FysatHeader();
        this.headerParser.read(raf, this.ncfile);
        this.ncfile.finish();
    }

    public Array readData(Variable v2, Section section) throws IOException, InvalidRangeException {
        int[] origin = section.getOrigin();
        int[] shape = section.getShape();
        int[] stride = section.getStride();
        FysatHeader.Vinfo vinfo = (FysatHeader.Vinfo)v2.getSPobject();
        if (this.headerParser.getCompressType() == 0) {
            return this.readData(v2, vinfo.begin, origin, shape, stride);
        }
        if (this.headerParser.getCompressType() == 2) {
            return this.readCompressedData(v2, vinfo.begin, origin, shape, stride);
        }
        if (this.headerParser.getCompressType() == 1) {
            return this.readCompressedZlib(v2, vinfo.begin, vinfo.nx, vinfo.ny, origin, shape, stride);
        }
        return null;
    }

    private Array readData(Variable v2, long dataPos, int[] origin, int[] shape, int[] stride) throws IOException, InvalidRangeException {
        Array array;
        this.raf.seek(dataPos);
        FysatHeader.Vinfo vi = (FysatHeader.Vinfo)v2.getSPobject();
        int data_size = vi.vsize;
        byte[] data = new byte[data_size];
        this.raf.readFully(data);
        if (vi.classType == DataType.BYTE.getPrimitiveClassType()) {
            array = Array.factory((Class)DataType.BYTE.getPrimitiveClassType(), (int[])v2.getShape(), (Object)data);
        } else if (vi.classType == DataType.SHORT.getPrimitiveClassType()) {
            EndianByteBuffer byteBuff = new EndianByteBuffer(data, vi.byteOrder);
            short[] sdata = byteBuff.getShortArray();
            array = Array.factory((Class)DataType.SHORT.getPrimitiveClassType(), (int[])v2.getShape(), (Object)sdata);
        } else if (vi.classType == DataType.INT.getPrimitiveClassType()) {
            EndianByteBuffer byteBuff = new EndianByteBuffer(data, vi.byteOrder);
            short[] idata = byteBuff.getShortArray();
            array = Array.factory((Class)DataType.INT.getPrimitiveClassType(), (int[])v2.getShape(), (Object)idata);
        } else {
            throw new UnsupportedEncodingException();
        }
        return array.sectionNoReduce(origin, shape, stride);
    }

    public Array readDataOld(Variable v2, long dataPos, int[] origin, int[] shape, int[] stride) throws IOException, InvalidRangeException {
        if (origin == null) {
            origin = new int[v2.getRank()];
        }
        if (shape == null) {
            shape = v2.getShape();
        }
        FysatHeader.Vinfo vinfo = (FysatHeader.Vinfo)v2.getSPobject();
        int nx = vinfo.nx;
        int ny = vinfo.ny;
        int start_l = origin[0];
        int stride_l = stride[0];
        int stop_l = origin[0] + shape[0] - 1;
        int start_p = origin[1];
        int stride_p = stride[1];
        int stop_p = origin[1] + shape[1] - 1;
        if (start_l + stop_l + stride_l == 0) {
            start_l = 0;
            stride_l = 1;
            stop_l = ny - 1;
        }
        if (start_p + stop_p + stride_p == 0) {
            start_p = 0;
            stride_p = 1;
            stop_p = nx - 1;
        }
        int Len = shape[1];
        ArrayByte adata = new ArrayByte(new int[]{shape[0], shape[1]});
        Index indx = adata.getIndex();
        long doff = dataPos + (long)start_p;
        for (int iline = start_l; iline <= stop_l; iline += stride_l) {
            byte[] buf = this.getGiniLine(nx, ny, doff, iline, Len, stride_p);
            for (int i = 0; i < Len; ++i) {
                adata.setByte(indx.set(iline - start_l, i), buf[i]);
            }
        }
        return adata;
    }

    public Array readCompressedData(Variable v2, long dataPos, int[] origin, int[] shape, int[] stride) throws IOException, InvalidRangeException {
        long length = this.raf.length();
        this.raf.seek(dataPos);
        int data_size = (int)(length - dataPos);
        byte[] data = new byte[data_size];
        this.raf.readFully(data);
        ByteArrayInputStream ios = new ByteArrayInputStream(data);
        BufferedImage image = ImageIO.read(ios);
        Raster raster = image.getData();
        DataBuffer db = raster.getDataBuffer();
        if (db instanceof DataBufferByte) {
            DataBufferByte dbb = (DataBufferByte)db;
            int t = dbb.getNumBanks();
            byte[] udata = dbb.getData();
            Array array = Array.factory((Class)DataType.BYTE.getPrimitiveClassType(), (int[])v2.getShape(), (Object)udata);
            v2.setCachedData(array, false);
            return array.sectionNoReduce(origin, shape, stride);
        }
        return null;
    }

    public Array readCompressedZlib(Variable v2, long dataPos, int nx, int ny, int[] origin, int[] shape, int[] stride) throws IOException, InvalidRangeException {
        long length = this.raf.length();
        this.raf.seek(dataPos);
        int data_size = (int)(length - dataPos);
        byte[] data = new byte[data_size];
        this.raf.readFully(data);
        int resultLength = 0;
        int result = 0;
        byte[] uncomp = new byte[nx * (ny + 1) + 4000];
        Inflater inflater = new Inflater(false);
        inflater.setInput(data, 0, data_size);
        int offset = 0;
        int limit = nx * ny + nx;
        while (inflater.getRemaining() > 0) {
            try {
                resultLength = inflater.inflate(uncomp, offset, 4000);
            }
            catch (DataFormatException ex) {
                ex.printStackTrace();
                throw new IOException(ex.getMessage());
            }
            offset += resultLength;
            if ((result += resultLength) > limit) {
                byte[] tmp = new byte[result];
                System.arraycopy(uncomp, 0, tmp, 0, result);
                int uncompLen = result + 4000;
                uncomp = new byte[uncompLen];
                System.arraycopy(tmp, 0, uncomp, 0, result);
            }
            if (resultLength != 0) continue;
            int tt = inflater.getRemaining();
            byte[] b2 = new byte[2];
            System.arraycopy(data, data_size - tt, b2, 0, 2);
            if (this.isZlibHed(b2) == 0) {
                System.arraycopy(data, data_size - tt, uncomp, result, tt);
                result += tt;
                break;
            }
            inflater.reset();
            inflater.setInput(data, data_size - tt, tt);
        }
        inflater.end();
        byte[] inflateData = new byte[nx * ny];
        System.arraycopy(uncomp, 0, inflateData, 0, nx * ny);
        Array array = Array.factory((Class)DataType.BYTE.getPrimitiveClassType(), (int[])v2.getShape(), (Object)inflateData);
        if (array.getSize() < 4000L) {
            v2.setCachedData(array, false);
        }
        return array.sectionNoReduce(origin, shape, stride);
    }

    private byte[] getGiniLine(int nx, int ny, long doff, int lineNumber, int len, int stride) throws IOException {
        byte[] data = new byte[len];
        this.raf.seek(doff);
        if (lineNumber >= ny) {
            throw new IOException("Try to access the file at line number= " + lineNumber + " larger then last line number = " + ny);
        }
        int offset = lineNumber * nx + (int)doff;
        for (int i = 0; i < len; ++i) {
            this.raf.seek((long)offset);
            data[i] = this.raf.readByte();
            offset += stride;
        }
        return data;
    }

    public short convertunsignedByte2Short(byte b) {
        return b < 0 ? (short)((short)b + 256) : (short)b;
    }

    int isZlibHed(byte[] buf) {
        short b0 = this.convertunsignedByte2Short(buf[0]);
        short b1 = this.convertunsignedByte2Short(buf[1]);
        if ((b0 & 0xF) == 8 && (b0 >> 4) + 8 <= 15 && ((b0 << 8) + b1) % 31 == 0) {
            return 1;
        }
        return 0;
    }
}

