/*
 * Decompiled with CFR 0.152.
 */
package dap4.cdm.nc2;

import dap4.cdm.NodeMap;
import dap4.cdm.nc2.CDMArray;
import dap4.cdm.nc2.CDMArrayAtomic;
import dap4.cdm.nc2.CDMArraySequence;
import dap4.cdm.nc2.CDMArrayStructure;
import dap4.cdm.nc2.DapNetcdfFile;
import dap4.core.data.DSP;
import dap4.core.data.DataCursor;
import dap4.core.dmr.DapDataset;
import dap4.core.dmr.DapSequence;
import dap4.core.dmr.DapStructure;
import dap4.core.dmr.DapVariable;
import dap4.core.util.DapException;
import dap4.core.util.DapUtil;
import dap4.core.util.Index;
import dap4.core.util.Odometer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import ucar.ma2.Array;
import ucar.nc2.Attribute;
import ucar.nc2.Group;
import ucar.nc2.Variable;

public class DataToCDM {
    public static boolean DEBUG = false;
    protected static final int COUNTSIZE = 8;
    protected static final String LBRACE = "{";
    protected static final String RBRACE = "}";
    protected DapNetcdfFile ncfile = null;
    protected DSP dsp = null;
    protected DapDataset dmr = null;
    protected Group cdmroot = null;
    protected Map<Variable, Array> arraymap = null;
    protected NodeMap nodemap = null;

    public DataToCDM(DapNetcdfFile ncfile, DSP dsp, NodeMap nodemap) throws DapException {
        this.ncfile = ncfile;
        this.dsp = dsp;
        this.dmr = dsp.getDMR();
        this.nodemap = nodemap;
        this.cdmroot = ncfile.getRootGroup();
        this.arraymap = new HashMap<Variable, Array>();
    }

    Map<Variable, Array> create() throws DapException {
        List topvars = this.dmr.getTopVariables();
        Object map = null;
        for (DapVariable var : topvars) {
            DataCursor cursor = this.dsp.getVariableData(var);
            Array array = this.createVar(cursor);
            Variable cdmvar = (Variable)this.nodemap.get(var);
            this.arraymap.put(cdmvar, array);
        }
        return this.arraymap;
    }

    protected Array createVar(DataCursor data) throws DapException {
        CDMArray array = null;
        DapVariable d4var = (DapVariable)data.getTemplate();
        switch (d4var.getBaseType().getTypeSort()) {
            default: {
                array = this.createAtomicVar(data);
                break;
            }
            case Sequence: {
                array = this.createSequence(data);
                break;
            }
            case Structure: {
                array = this.createStructure(data);
            }
        }
        if (d4var.isTopLevel() && this.dsp.getChecksumMode().enabled(this.dsp.getChecksumMode())) {
            int csum = d4var.getChecksum();
            String scsum = String.format("0x%08x", csum);
            Variable cdmvar = (Variable)this.nodemap.get(d4var);
            Attribute acsum = new Attribute("_DAP4_Checksum_CRC32", scsum);
            cdmvar.addAttribute(acsum);
        }
        return array;
    }

    protected CDMArrayAtomic createAtomicVar(DataCursor data) throws DapException {
        CDMArrayAtomic array = new CDMArrayAtomic(data);
        return array;
    }

    protected CDMArrayStructure createStructure(DataCursor data) throws DapException {
        CDMArrayStructure arraystruct = new CDMArrayStructure(this.cdmroot, data);
        DapVariable var = (DapVariable)data.getTemplate();
        DapStructure struct = (DapStructure)var.getBaseType();
        int nmembers = struct.getFields().size();
        List dimset = var.getDimensions();
        Odometer odom = Odometer.factory((List)DapUtil.dimsetToSlices((List)dimset));
        while (odom.hasNext()) {
            Index index = odom.next();
            long offset = index.index();
            DataCursor[] cursors = (DataCursor[])data.read(index);
            DataCursor ithelement = cursors[0];
            for (int f = 0; f < nmembers; ++f) {
                DataCursor dc = ithelement.readField(f);
                Array afield = this.createVar(dc);
                arraystruct.add(offset, f, afield);
            }
        }
        return arraystruct;
    }

    protected CDMArraySequence createSequence(DataCursor data) throws DapException {
        CDMArraySequence arrayseq = new CDMArraySequence(this.cdmroot, data);
        DapVariable var = (DapVariable)data.getTemplate();
        DapSequence template = (DapSequence)var.getBaseType();
        List dimset = var.getDimensions();
        long dimsize = DapUtil.dimProduct((List)dimset);
        int nfields = template.getFields().size();
        Odometer odom = Odometer.factory((List)DapUtil.dimsetToSlices((List)dimset));
        while (odom.hasNext()) {
            odom.next();
            DataCursor seq = ((DataCursor[])data.read(odom.indices()))[0];
            long nrecords = seq.getRecordCount();
            int r = 0;
            while ((long)r < nrecords) {
                DataCursor rec = seq.readRecord((long)r);
                for (int f = 0; f < nfields; ++f) {
                    DataCursor dc = rec.readField(f);
                    Array afield = this.createVar(dc);
                    arrayseq.add(r, f, afield);
                }
                ++r;
            }
        }
        return arrayseq;
    }
}

