/*
 * Decompiled with CFR 0.152.
 */
package dap4.cdm.nc2;

import dap4.cdm.CDMTypeFcns;
import dap4.cdm.NodeMap;
import dap4.cdm.nc2.DapNetcdfFile;
import dap4.core.data.DSP;
import dap4.core.dmr.DapAttribute;
import dap4.core.dmr.DapDataset;
import dap4.core.dmr.DapDimension;
import dap4.core.dmr.DapEnumConst;
import dap4.core.dmr.DapEnumeration;
import dap4.core.dmr.DapGroup;
import dap4.core.dmr.DapNode;
import dap4.core.dmr.DapSequence;
import dap4.core.dmr.DapStructure;
import dap4.core.dmr.DapType;
import dap4.core.dmr.DapVariable;
import dap4.core.util.Convert;
import dap4.core.util.DapException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import ucar.ma2.DataType;
import ucar.ma2.ForbiddenConversionException;
import ucar.nc2.Attribute;
import ucar.nc2.CDMNode;
import ucar.nc2.Dimension;
import ucar.nc2.EnumTypedef;
import ucar.nc2.Group;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Sequence;
import ucar.nc2.Structure;
import ucar.nc2.Variable;

public class DMRToCDM {
    protected DapNetcdfFile ncfile;
    protected DSP dsp;
    protected DapDataset dmr;
    protected NodeMap<CDMNode, DapNode> nodemap;

    public DMRToCDM(DapNetcdfFile ncfile, DSP dsp) throws DapException {
        this.ncfile = ncfile;
        this.dsp = dsp;
        this.dmr = dsp.getDMR();
        this.nodemap = new NodeMap();
    }

    public NodeMap<CDMNode, DapNode> create() throws DapException {
        Group cdmroot = this.ncfile.getRootGroup();
        this.nodemap.put((CDMNode)cdmroot, (DapNode)this.dmr);
        this.fillGroup(cdmroot, (DapGroup)this.dmr, this.ncfile);
        return this.nodemap;
    }

    protected void fillGroup(Group cdmparent, DapGroup dapparent, NetcdfFile ncfile) throws DapException {
        for (DapDimension dapDimension : dapparent.getDimensions()) {
            if (!dapDimension.isShared()) continue;
            this.createDimension(dapDimension, cdmparent);
        }
        for (DapEnumeration dapEnumeration : dapparent.getEnums()) {
            DapType basetype = dapEnumeration.getBaseType();
            DataType cdmbasetype = CDMTypeFcns.enumTypeFor(basetype);
            HashMap<Integer, String> map = new HashMap<Integer, String>();
            List ecnames = dapEnumeration.getNames();
            for (String ecname : ecnames) {
                DapEnumConst value = dapEnumeration.lookup(ecname);
                map.put(value.getIntValue(), ecname);
            }
            EnumTypedef cdmenum = new EnumTypedef(dapEnumeration.getShortName(), map, cdmbasetype);
            this.nodemap.put((CDMNode)cdmenum, (DapNode)dapEnumeration);
            cdmparent.addEnumeration(cdmenum);
        }
        for (DapVariable dapVariable : dapparent.getVariables()) {
            this.createVar(dapVariable, ncfile, cdmparent, null);
        }
        for (DapGroup dapGroup : dapparent.getGroups()) {
            this.createGroup(dapGroup, cdmparent, ncfile);
        }
        for (Map.Entry entry : dapparent.getAttributes().entrySet()) {
            DapAttribute attr = (DapAttribute)entry.getValue();
            Attribute cdmattr = this.createAttribute(attr);
            cdmparent.addAttribute(cdmattr);
        }
    }

    protected void createGroup(DapGroup dapgroup, Group cdmparent, NetcdfFile ncfile) throws DapException {
        Group cdmgroup = new Group(ncfile, cdmparent, dapgroup.getShortName());
        this.nodemap.put((CDMNode)cdmgroup, (DapNode)dapgroup);
        this.fillGroup(cdmgroup, dapgroup, ncfile);
        if (cdmgroup != null) {
            cdmparent.addGroup(cdmgroup);
        }
    }

    protected void createVar(DapVariable dapvar, NetcdfFile ncfile, Group cdmgroup, Structure cdmparentstruct) throws DapException {
        Variable cdmvar = null;
        DapType basetype = dapvar.getBaseType();
        if (basetype.isAtomic()) {
            DapVariable atomvar = dapvar;
            cdmvar = new Variable(ncfile, cdmgroup, cdmparentstruct, atomvar.getShortName());
            DataType cdmbasetype = basetype.isEnumType() ? CDMTypeFcns.enumTypeFor(basetype) : CDMTypeFcns.daptype2cdmtype(basetype);
            if (cdmbasetype == null) {
                throw new DapException("Unknown basetype:" + basetype);
            }
            cdmvar.setDataType(cdmbasetype);
            if (basetype.isEnumType()) {
                EnumTypedef cdmenum = (EnumTypedef)this.nodemap.get((DapNode)basetype);
                if (cdmenum == null) {
                    throw new DapException("Unknown enumeration type:" + basetype.toString());
                }
                cdmvar.setEnumTypedef(cdmenum);
            }
            this.nodemap.put((CDMNode)cdmvar, (DapNode)dapvar);
        } else if (basetype.isStructType()) {
            DapStructure dapstruct = (DapStructure)basetype;
            Structure cdmstruct = new Structure(ncfile, cdmgroup, cdmparentstruct, dapstruct.getShortName());
            cdmvar = cdmstruct;
            this.nodemap.put((CDMNode)cdmvar, (DapNode)dapvar);
            for (DapVariable field : dapstruct.getFields()) {
                this.createVar(field, ncfile, cdmgroup, cdmstruct);
            }
        } else if (basetype.isSeqType()) {
            DapSequence dapseq = (DapSequence)basetype;
            Sequence cdmseq = new Sequence(ncfile, cdmgroup, cdmparentstruct, dapseq.getShortName());
            cdmvar = cdmseq;
            this.nodemap.put((CDMNode)cdmvar, (DapNode)dapvar);
            for (DapVariable field : dapseq.getFields()) {
                this.createVar(field, ncfile, cdmgroup, (Structure)cdmseq);
            }
            if (dapvar.getRank() > 0) {
                ArrayList<String> value = new ArrayList<String>();
                value.add("CDM does not support Sequences with rank > 0");
                Attribute warning = new Attribute("_WARNING:", value);
                cdmvar.addAttribute(warning);
            }
        } else assert (false) : "Unknown variable sort: " + dapvar.getSort();
        int rank = dapvar.getRank();
        ArrayList<Dimension> cdmdims = new ArrayList<Dimension>(rank + 1);
        for (int i = 0; i < rank; ++i) {
            DapDimension dim = dapvar.getDimension(i);
            Dimension cdmdim = this.createDimensionRef(dim, cdmgroup);
            cdmdims.add(cdmdim);
        }
        if (basetype.isSeqType()) {
            cdmdims.add(Dimension.VLEN);
        }
        cdmvar.setDimensions(cdmdims);
        for (String key : dapvar.getAttributes().keySet()) {
            DapAttribute attr = (DapAttribute)dapvar.getAttributes().get(key);
            Attribute cdmattr = this.createAttribute(attr);
            cdmvar.addAttribute(cdmattr);
        }
        if (cdmparentstruct != null) {
            cdmparentstruct.addMemberVariable(cdmvar);
        } else if (cdmgroup != null) {
            cdmgroup.addVariable(cdmvar);
        }
    }

    protected void createDimension(DapDimension dapdim, Group cdmgroup) throws DapException {
        if (dapdim.isShared()) {
            if (this.nodemap.containsKey((DapNode)dapdim)) {
                throw new DapException("Attempt to declare dimension twice:" + dapdim.getFQN());
            }
        } else {
            throw new DapException("Attempt to declare an anonymous dimension");
        }
        Dimension cdmdim = new Dimension(dapdim.getShortName(), (int)dapdim.getSize(), true, false, false);
        this.nodemap.put((CDMNode)cdmdim, (DapNode)dapdim);
        cdmgroup.addDimension(cdmdim);
    }

    protected Dimension createDimensionRef(DapDimension dim, Group cdmgroup) throws DapException {
        Dimension cdmdim = null;
        cdmdim = dim.isShared() ? (Dimension)this.nodemap.get((DapNode)dim) : new Dimension(null, (int)dim.getSize(), false, false, false);
        if (cdmdim == null) {
            throw new DapException("Unknown dimension: " + dim.getFQN());
        }
        return cdmdim;
    }

    protected EnumTypedef createEnum(DapEnumeration dapenum, Group cdmparent) throws DapException {
        DapType basetype = dapenum.getBaseType();
        DataType cdmbasetype = CDMTypeFcns.enumTypeFor(basetype);
        HashMap<Integer, String> map = new HashMap<Integer, String>();
        List ecnames = dapenum.getNames();
        for (String ecname : ecnames) {
            DapEnumConst value = dapenum.lookup(ecname);
            map.put(value.getIntValue(), ecname);
        }
        EnumTypedef cdmenum = new EnumTypedef(dapenum.getShortName(), map, cdmbasetype);
        this.nodemap.put((CDMNode)cdmenum, (DapNode)dapenum);
        cdmparent.addEnumeration(cdmenum);
        return cdmenum;
    }

    protected Attribute createAttribute(DapAttribute dapattr) {
        return this.createAttribute(null, dapattr);
    }

    protected Attribute createAttribute(String prefix, DapAttribute dapattr) {
        Attribute cdmattr = null;
        switch (dapattr.getSort()) {
            case ATTRIBUTE: {
                DapType basetype = dapattr.getBaseType();
                if (!basetype.isLegalAttrType()) {
                    throw new ForbiddenConversionException("Illegal attribute type:" + basetype.toString());
                }
                DataType cdmtype = CDMTypeFcns.daptype2cdmtype(basetype);
                DapEnumeration dapen = basetype.isEnumType() ? (DapEnumeration)basetype : null;
                String[] dapvalues = dapattr.getValues();
                Object cvt = dapen != null ? Convert.convert((DapType)dapen, (DapType)DapType.STRING, (Object)dapvalues) : Convert.convert((DapType)basetype, (DapType)DapType.STRING, (Object)dapvalues);
                List cdmvalues = CDMTypeFcns.listify(cvt);
                EnumTypedef en = (EnumTypedef)(dapen != null ? this.nodemap.get((DapNode)basetype) : null);
                if (dapen != null) {
                    cdmattr = new Attribute(dapattr.getShortName(), DataType.STRING);
                    cdmattr.setValues(cdmvalues, false);
                    cdmattr.setEnumType(en);
                }
                cdmattr = new Attribute(dapattr.getShortName(), cdmvalues, false);
                break;
            }
            case ATTRIBUTESET: {
                String setname = dapattr.getShortName();
                prefix = prefix == null ? setname : prefix + "_" + setname;
                for (String key : dapattr.getAttributes().keySet()) {
                    DapAttribute subattr = (DapAttribute)dapattr.getAttributes().get(key);
                    cdmattr = this.createAttribute(prefix, subattr);
                }
                break;
            }
            case OTHERXML: {
                ArrayList<String> cdmvalues = new ArrayList<String>();
                cdmvalues.add("OtherXML");
                cdmattr = new Attribute("OtherXML", cdmvalues);
            }
        }
        this.nodemap.put((CDMNode)cdmattr, (DapNode)dapattr);
        return cdmattr;
    }
}

