/*
 * Decompiled with CFR 0.152.
 */
package dap4.cdm.nc2;

import dap4.cdm.NodeMap;
import dap4.cdm.nc2.DMRToCDM;
import dap4.cdm.nc2.DapNetcdfFile;
import dap4.cdm.nc2.DataToCDM;
import dap4.core.data.DSP;
import dap4.core.dmr.DapDataset;
import dap4.core.dmr.DapNode;
import dap4.core.util.DapException;
import java.util.Map;
import ucar.ma2.Array;
import ucar.nc2.CDMNode;
import ucar.nc2.Group;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Variable;

public class CDMCompiler {
    public static boolean DEBUG = false;
    protected DapNetcdfFile ncfile = null;
    protected DSP dsp = null;
    protected DapDataset dmr = null;
    protected Group cdmroot = null;
    protected NodeMap<CDMNode, DapNode> nodemap = null;
    protected Map<Variable, Array> arraymap = null;

    public CDMCompiler(DapNetcdfFile ncfile, DSP dsp) throws DapException {
        this.ncfile = ncfile;
        this.dsp = dsp;
        this.dmr = dsp.getDMR();
    }

    public NodeMap<CDMNode, DapNode> getNodeMap() {
        return this.nodemap;
    }

    public Map<Variable, Array> getArrayMap() {
        return this.arraymap;
    }

    public NetcdfFile getNetcdfFile() {
        return this.ncfile;
    }

    void compile() throws DapException {
        this.compileDMR();
        this.compileData();
    }

    protected void compileDMR() throws DapException {
        this.nodemap = new DMRToCDM(this.ncfile, this.dsp).create();
    }

    protected void compileData() throws DapException {
        this.arraymap = new DataToCDM(this.ncfile, this.dsp, this.nodemap).create();
    }
}

