/*
 * Decompiled with CFR 0.152.
 */
package dap4.cdm.nc2;

import dap4.cdm.CDMUtil;
import dap4.cdm.nc2.CDMCompiler;
import dap4.core.data.DSP;
import dap4.core.data.DSPRegistry;
import dap4.core.util.DapContext;
import dap4.core.util.DapUtil;
import dap4.dap4lib.FileDSP;
import dap4.dap4lib.HttpDSP;
import dap4.dap4lib.XURI;
import java.io.IOException;
import java.net.URISyntaxException;
import java.nio.channels.WritableByteChannel;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ucar.ma2.Array;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.Range;
import ucar.ma2.Section;
import ucar.nc2.NetcdfFile;
import ucar.nc2.ParsedSectionSpec;
import ucar.nc2.Variable;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.iosp.IospHelper;
import ucar.nc2.util.CancelTask;

public class DapNetcdfFile
extends NetcdfFile {
    static final boolean DEBUG = false;
    static final boolean PARSEDEBUG = false;
    static final boolean MERGE = false;
    static Set<NetcdfDataset.Enhance> ENHANCEMENT = EnumSet.of(NetcdfDataset.Enhance.CoordSystems);
    static final String QUERYSTART = "?";
    static final String FRAGSTART = "#";
    protected static final NullCancelTask nullcancel = new NullCancelTask();
    protected static DSPRegistry dspregistry = new DSPRegistry();
    protected boolean allowCompression = true;
    protected boolean closed = false;
    protected String location = null;
    protected String dsplocation = null;
    protected XURI xuri = null;
    protected DSP dsp = null;
    protected CancelTask cancel = null;
    protected Map<Variable, Array> arraymap = new HashMap<Variable, Array>();

    public DapNetcdfFile(String location, CancelTask cancelTask) throws IOException {
        XURI xuri;
        this.location = location;
        try {
            xuri = new XURI(location);
        }
        catch (URISyntaxException use) {
            throw new IOException(use);
        }
        boolean isfile = xuri.isFile();
        this.dsplocation = isfile ? DapUtil.absolutize((String)xuri.getPath()) : xuri.assemble(XURI.URLBASE);
        DapContext cxt = new DapContext();
        this.cancel = cancelTask == null ? nullcancel : cancelTask;
        this.dsp = dspregistry.findMatchingDSP(location, cxt);
        if (this.dsp == null) {
            throw new IOException("No matching DSP: " + this.location);
        }
        this.dsp.setContext(cxt);
        this.dsp.open(this.dsplocation);
        CDMCompiler compiler = new CDMCompiler(this, this.dsp);
        compiler.compile();
        this.setLocation(this.dsp.getDMR().getDataset().getShortName());
        this.finish();
        this.arraymap = compiler.getArrayMap();
    }

    public DapNetcdfFile(String url) throws IOException {
        this(url, null);
    }

    public synchronized void close() throws IOException {
        if (this.closed) {
            return;
        }
        this.closed = true;
        this.dsp = null;
    }

    public boolean isconstrainable() {
        return true;
    }

    public String getLocation() {
        return this.location;
    }

    public DSP getDSP() {
        return this.dsp;
    }

    public List<Array> readArrays(List<Variable> variables) throws IOException {
        ArrayList<Array> result = new ArrayList<Array>();
        for (Variable variable : variables) {
            result.add(variable.read());
        }
        return result;
    }

    public long readToByteChannel(Variable v, Section section, WritableByteChannel channel) throws IOException, InvalidRangeException {
        Array result = this.readData(v, section);
        return IospHelper.transferData((Array)result, (WritableByteChannel)channel);
    }

    public Array readSection(String variableSection) throws IOException, InvalidRangeException {
        ParsedSectionSpec cer = ParsedSectionSpec.parseVariableSection((NetcdfFile)this, (String)variableSection);
        return cer.v.read(cer.section);
    }

    protected Array readData(Variable cdmvar, Section section) throws IOException, InvalidRangeException {
        assert (this.dsp != null);
        Array result = this.arraymap.get(cdmvar);
        if (result == null) {
            throw new IOException("No data for variable: " + cdmvar.getFullName());
        }
        if (section != null) {
            if (cdmvar.getRank() != section.getRank()) {
                throw new InvalidRangeException(String.format("Section rank != %s rank", cdmvar.getFullName()));
            }
            List ranges = section.getRanges();
            if (CDMUtil.hasVLEN(ranges)) {
                ranges = ranges.subList(0, ranges.size() - 1);
            }
            if (ranges.size() > 0 && !CDMUtil.isWhole((List<Range>)ranges, cdmvar)) {
                result = result.sectionNoReduce(ranges);
            }
        }
        return result;
    }

    static {
        dspregistry.register(FileDSP.class, false);
        dspregistry.register(HttpDSP.class, false);
    }

    protected static class NullCancelTask
    implements CancelTask {
        protected NullCancelTask() {
        }

        public boolean isCancel() {
            return false;
        }

        public void setError(String msg) {
        }

        public void setProgress(String msg, int progress) {
        }
    }
}

