/*
 * Decompiled with CFR 0.152.
 */
package dap4.cdm.nc2;

import dap4.cdm.CDMTypeFcns;
import dap4.cdm.CDMUtil;
import dap4.cdm.nc2.CDMArray;
import dap4.core.data.DSP;
import dap4.core.data.DataCursor;
import dap4.core.dmr.DapType;
import dap4.core.dmr.DapVariable;
import dap4.core.util.Convert;
import dap4.core.util.DapException;
import dap4.core.util.DapUtil;
import dap4.core.util.Index;
import java.io.IOException;
import java.util.List;
import ucar.ma2.Array;
import ucar.ma2.DataType;
import ucar.ma2.IndexIterator;
import ucar.nc2.Group;

class CDMArrayAtomic
extends Array
implements CDMArray {
    protected DSP dsp = null;
    protected DapVariable template = null;
    protected DapType basetype = null;
    protected DataCursor data = null;
    protected Group cdmroot = null;
    protected int elementsize = 0;
    protected long dimsize = 0L;
    protected long totalsize = 0L;

    CDMArrayAtomic(DataCursor data) throws DapException {
        super(CDMTypeFcns.daptype2cdmtype(((DapVariable)data.getTemplate()).getBaseType()), CDMUtil.computeEffectiveShape(((DapVariable)data.getTemplate()).getDimensions()));
        this.dsp = data.getDSP();
        this.data = data;
        this.template = (DapVariable)this.data.getTemplate();
        this.basetype = this.template.getBaseType();
        this.dimsize = DapUtil.dimProduct((List)this.template.getDimensions());
        this.elementsize = this.basetype.getSize();
    }

    @Override
    public DapType getBaseType() {
        return this.basetype;
    }

    @Override
    public DSP getDSP() {
        return this.dsp;
    }

    @Override
    public DapVariable getTemplate() {
        return this.template;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        DapType basetype = this.getBaseType();
        String sbt = basetype == null ? "?" : basetype.toString();
        String st = this.template == null ? "?" : this.template.getShortName();
        buf.append(String.format("%s %s[%d]", sbt, st, this.dimsize));
        return buf.toString();
    }

    public Class getElementType() {
        DataType dt = CDMTypeFcns.daptype2cdmtype(this.basetype);
        if (dt == null) {
            throw new IllegalArgumentException("Unknown datatype: " + this.basetype);
        }
        return CDMTypeFcns.cdmElementClass(dt);
    }

    public double getDouble(ucar.ma2.Index cdmidx) {
        return this.getDouble(CDMUtil.cdmIndexToIndex(cdmidx));
    }

    public float getFloat(ucar.ma2.Index cdmidx) {
        return this.getFloat(CDMUtil.cdmIndexToIndex(cdmidx));
    }

    public long getLong(ucar.ma2.Index cdmidx) {
        return this.getLong(CDMUtil.cdmIndexToIndex(cdmidx));
    }

    public int getInt(ucar.ma2.Index cdmidx) {
        return this.getInt(CDMUtil.cdmIndexToIndex(cdmidx));
    }

    public short getShort(ucar.ma2.Index cdmidx) {
        return this.getShort(CDMUtil.cdmIndexToIndex(cdmidx));
    }

    public byte getByte(ucar.ma2.Index cdmidx) {
        return this.getByte(CDMUtil.cdmIndexToIndex(cdmidx));
    }

    public char getChar(ucar.ma2.Index cdmidx) {
        return this.getChar(CDMUtil.cdmIndexToIndex(cdmidx));
    }

    public boolean getBoolean(ucar.ma2.Index cdmidx) {
        return this.getBoolean(CDMUtil.cdmIndexToIndex(cdmidx));
    }

    public Object getObject(ucar.ma2.Index cdmidx) {
        return this.getObject(CDMUtil.cdmIndexToIndex(cdmidx));
    }

    public double getDouble(int offset) {
        DapVariable d4var = this.getTemplate();
        long[] dimsizes = DapUtil.getDimSizes((List)d4var.getDimensions());
        return this.getDouble(DapUtil.offsetToIndex((long)offset, (long[])dimsizes));
    }

    public float getFloat(int offset) {
        DapVariable d4var = this.getTemplate();
        long[] dimsizes = DapUtil.getDimSizes((List)d4var.getDimensions());
        return this.getFloat(DapUtil.offsetToIndex((long)offset, (long[])dimsizes));
    }

    public long getLong(int offset) {
        DapVariable d4var = this.getTemplate();
        long[] dimsizes = DapUtil.getDimSizes((List)d4var.getDimensions());
        return this.getLong(DapUtil.offsetToIndex((long)offset, (long[])dimsizes));
    }

    public int getInt(int offset) {
        DapVariable d4var = this.getTemplate();
        long[] dimsizes = DapUtil.getDimSizes((List)d4var.getDimensions());
        return this.getInt(DapUtil.offsetToIndex((long)offset, (long[])dimsizes));
    }

    public short getShort(int offset) {
        DapVariable d4var = this.getTemplate();
        long[] dimsizes = DapUtil.getDimSizes((List)d4var.getDimensions());
        return this.getShort(DapUtil.offsetToIndex((long)offset, (long[])dimsizes));
    }

    public byte getByte(int offset) {
        DapVariable d4var = this.getTemplate();
        long[] dimsizes = DapUtil.getDimSizes((List)d4var.getDimensions());
        return this.getByte(DapUtil.offsetToIndex((long)offset, (long[])dimsizes));
    }

    public char getChar(int offset) {
        DapVariable d4var = this.getTemplate();
        long[] dimsizes = DapUtil.getDimSizes((List)d4var.getDimensions());
        return this.getChar(DapUtil.offsetToIndex((long)offset, (long[])dimsizes));
    }

    public boolean getBoolean(int offset) {
        DapVariable d4var = this.getTemplate();
        long[] dimsizes = DapUtil.getDimSizes((List)d4var.getDimensions());
        return this.getBoolean(DapUtil.offsetToIndex((long)offset, (long[])dimsizes));
    }

    public Object getObject(int offset) {
        DapVariable d4var = this.getTemplate();
        long[] dimsizes = DapUtil.getDimSizes((List)d4var.getDimensions());
        return this.getObject(DapUtil.offsetToIndex((long)offset, (long[])dimsizes));
    }

    public Object getStorage() {
        try {
            List slices = DapUtil.dimsetToSlices((List)this.template.getDimensions());
            Object result = this.data.read(slices);
            return result;
        }
        catch (DapException e) {
            throw new IllegalArgumentException();
        }
    }

    public void setDouble(ucar.ma2.Index ima, double value) {
        throw new UnsupportedOperationException();
    }

    public void setFloat(ucar.ma2.Index ima, float value) {
        throw new UnsupportedOperationException();
    }

    public void setLong(ucar.ma2.Index ima, long value) {
        throw new UnsupportedOperationException();
    }

    public void setInt(ucar.ma2.Index ima, int value) {
        throw new UnsupportedOperationException();
    }

    public void setShort(ucar.ma2.Index ima, short value) {
        throw new UnsupportedOperationException();
    }

    public void setByte(ucar.ma2.Index ima, byte value) {
        throw new UnsupportedOperationException();
    }

    public void setChar(ucar.ma2.Index ima, char value) {
        throw new UnsupportedOperationException();
    }

    public void setBoolean(ucar.ma2.Index ima, boolean value) {
        throw new UnsupportedOperationException();
    }

    public void setObject(ucar.ma2.Index ima, Object value) {
        throw new UnsupportedOperationException();
    }

    public void setDouble(int elem, double value) {
        throw new UnsupportedOperationException();
    }

    public void setFloat(int elem, float value) {
        throw new UnsupportedOperationException();
    }

    public void setLong(int elem, long value) {
        throw new UnsupportedOperationException();
    }

    public void setInt(int elem, int value) {
        throw new UnsupportedOperationException();
    }

    public void setShort(int elem, short value) {
        throw new UnsupportedOperationException();
    }

    public void setByte(int elem, byte value) {
        throw new UnsupportedOperationException();
    }

    public void setChar(int elem, char value) {
        throw new UnsupportedOperationException();
    }

    public void setBoolean(int elem, boolean value) {
        throw new UnsupportedOperationException();
    }

    public void setObject(int elem, Object value) {
        throw new UnsupportedOperationException();
    }

    protected void copyTo1DJavaArray(IndexIterator indexIterator, Object o) {
        throw new UnsupportedOperationException();
    }

    protected void copyFrom1DJavaArray(IndexIterator iter, Object javaArray) {
        throw new UnsupportedOperationException();
    }

    protected Array createView(ucar.ma2.Index index) {
        return this;
    }

    protected double getDouble(Index idx) {
        assert (this.data.getScheme() == DataCursor.Scheme.ATOMIC);
        try {
            Object value = this.data.read(idx);
            value = Convert.convert((DapType)DapType.FLOAT64, (DapType)this.basetype, (Object)value);
            return (Double)java.lang.reflect.Array.get(value, 0);
        }
        catch (IOException ioe) {
            throw new IndexOutOfBoundsException(ioe.getMessage());
        }
    }

    protected float getFloat(Index idx) {
        assert (this.data.getScheme() == DataCursor.Scheme.ATOMIC);
        try {
            Object value = this.data.read(idx);
            value = Convert.convert((DapType)DapType.FLOAT32, (DapType)this.basetype, (Object)value);
            return ((Float)java.lang.reflect.Array.get(value, 0)).floatValue();
        }
        catch (IOException ioe) {
            throw new IndexOutOfBoundsException(ioe.getMessage());
        }
    }

    protected long getLong(Index idx) {
        assert (this.data.getScheme() == DataCursor.Scheme.ATOMIC);
        try {
            Object value = this.data.read(idx);
            value = Convert.convert((DapType)DapType.INT64, (DapType)this.basetype, (Object)value);
            return (Long)java.lang.reflect.Array.get(value, 0);
        }
        catch (IOException ioe) {
            throw new IndexOutOfBoundsException(ioe.getMessage());
        }
    }

    protected int getInt(Index idx) {
        assert (this.data.getScheme() == DataCursor.Scheme.ATOMIC);
        try {
            Object value = this.data.read(idx);
            value = Convert.convert((DapType)DapType.INT32, (DapType)this.basetype, (Object)value);
            return (Integer)java.lang.reflect.Array.get(value, 0);
        }
        catch (IOException ioe) {
            throw new IndexOutOfBoundsException(ioe.getMessage());
        }
    }

    protected short getShort(Index idx) {
        assert (this.data.getScheme() == DataCursor.Scheme.ATOMIC);
        try {
            Object value = this.data.read(idx);
            value = Convert.convert((DapType)DapType.INT16, (DapType)this.basetype, (Object)value);
            return (Short)java.lang.reflect.Array.get(value, 0);
        }
        catch (IOException ioe) {
            throw new IndexOutOfBoundsException(ioe.getMessage());
        }
    }

    protected byte getByte(Index idx) {
        assert (this.data.getScheme() == DataCursor.Scheme.ATOMIC);
        try {
            Object value = this.data.read(idx);
            value = Convert.convert((DapType)DapType.INT8, (DapType)this.basetype, (Object)value);
            return (Byte)java.lang.reflect.Array.get(value, 0);
        }
        catch (IOException ioe) {
            throw new IndexOutOfBoundsException(ioe.getMessage());
        }
    }

    protected char getChar(Index idx) {
        assert (this.data.getScheme() == DataCursor.Scheme.ATOMIC);
        try {
            Object value = this.data.read(idx);
            value = Convert.convert((DapType)DapType.CHAR, (DapType)this.basetype, (Object)value);
            return ((Character)java.lang.reflect.Array.get(value, 0)).charValue();
        }
        catch (IOException ioe) {
            throw new IndexOutOfBoundsException(ioe.getMessage());
        }
    }

    protected boolean getBoolean(Index idx) {
        assert (this.data.getScheme() == DataCursor.Scheme.ATOMIC);
        try {
            Object value = this.data.read(idx);
            value = Convert.convert((DapType)DapType.INT64, (DapType)this.basetype, (Object)value);
            return (Long)java.lang.reflect.Array.get(value, 0) != 0L;
        }
        catch (IOException ioe) {
            throw new IndexOutOfBoundsException(ioe.getMessage());
        }
    }

    protected Object getObject(Index idx) {
        assert (this.data.getScheme() == DataCursor.Scheme.ATOMIC);
        try {
            Object value = this.data.read(idx);
            value = java.lang.reflect.Array.get(value, 0);
            return value;
        }
        catch (IOException ioe) {
            throw new IndexOutOfBoundsException(ioe.getMessage());
        }
    }

    public DapVariable getVariable() {
        return this.template;
    }

    public DapType getType() {
        return this.basetype;
    }
}

