/*
 * Decompiled with CFR 0.152.
 */
package dap4.cdm;

import dap4.cdm.CDMArray;
import dap4.cdm.CDMArrayAtomic;
import dap4.cdm.CDMDataset;
import dap4.cdmshared.CDMUtil;
import dap4.core.data.DataException;
import dap4.core.dmr.AtomicType;
import dap4.core.dmr.DapStructure;
import dap4.core.dmr.DapType;
import dap4.core.dmr.DapVariable;
import dap4.core.util.DapSort;
import dap4.core.util.DapUtil;
import dap4.dap4shared.D4DSP;
import dap4.dap4shared.D4DataAtomic;
import dap4.dap4shared.D4DataCompoundArray;
import dap4.dap4shared.Dap4Util;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.List;
import ucar.ma2.Array;
import ucar.ma2.ArraySequence;
import ucar.ma2.ArrayStructure;
import ucar.ma2.DataType;
import ucar.ma2.ForbiddenConversionException;
import ucar.ma2.StructureData;
import ucar.ma2.StructureDataA;
import ucar.ma2.StructureMembers;

public class CDMArrayStructure
extends ArrayStructure
implements CDMArray {
    protected CDMDataset root = null;
    protected D4DSP dsp = null;
    protected DapVariable template = null;
    protected long bytesize = 0L;
    protected DapType basetype = null;
    protected AtomicType primitivetype = null;
    protected D4DataCompoundArray d4data = null;
    protected long dimsize = 0L;
    protected int dimactual = 0;
    protected CDMArray[] instances = null;
    protected StructureDataA[] structdata = null;

    CDMArrayStructure(D4DSP dsp, CDMDataset root, D4DataCompoundArray d4data) {
        super(CDMArrayStructure.computemembers((DapStructure)d4data.getTemplate()), CDMUtil.computeEffectiveShape((List)((DapVariable)d4data.getTemplate()).getDimensions()));
        this.dsp = dsp;
        this.root = root;
        this.template = (DapVariable)d4data.getTemplate();
        this.basetype = this.template.getBaseType();
        this.primitivetype = this.basetype.getPrimitiveType();
        this.dimsize = DapUtil.dimProduct((List)this.template.getDimensions());
        this.d4data = d4data;
        this.structdata = new StructureDataA[(int)this.dimsize];
        int nmembers = ((DapStructure)this.template).getFields().size();
        this.instances = new CDMArray[(int)(this.dimsize * (long)nmembers)];
        Arrays.fill(this.instances, null);
        int i = 0;
        while ((long)i < this.dimsize) {
            this.structdata[i] = new StructureDataA((ArrayStructure)this, i);
            ++i;
        }
    }

    void finish() {
        int nmembers = ((DapStructure)this.template).getFields().size();
        for (int i = 0; i < this.dimactual; ++i) {
            for (int m = 0; m < nmembers; ++m) {
                int offset = (int)((long)i * this.dimsize) + m;
                assert (this.instances[offset] != null);
            }
        }
        this.bytesize = this.computeTotalSize();
    }

    public D4DSP getDSP() {
        return this.dsp;
    }

    @Override
    public CDMDataset getRoot() {
        return this.root;
    }

    @Override
    public DapVariable getTemplate() {
        return this.template;
    }

    @Override
    public long getByteSize() {
        return this.bytesize;
    }

    @Override
    public DapType getBaseType() {
        return this.basetype;
    }

    @Override
    public AtomicType getPrimitiveType() {
        return this.primitivetype;
    }

    public long getSize() {
        return this.dimsize;
    }

    void addField(int index, StructureMembers.Member m, Array instance) {
        int mindex = CDMArrayStructure.memberIndex(m);
        this.addField(index, m, instance);
    }

    void addField(long index, int mindex, CDMArray instance) {
        assert (this.instances != null) : "Internal Error";
        if (index < 0L || index >= (long)this.instances.length) {
            throw new ArrayIndexOutOfBoundsException("CDMArrayStructure.addInstance: index out of range: " + index);
        }
        if (index > (long)this.dimactual) {
            this.dimactual = (int)index + 1;
        }
        int offset = (int)(index * this.dimsize) + mindex;
        this.instances[offset] = instance;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        DapStructure struct = (DapStructure)this.template;
        int i = 0;
        while ((long)i < this.dimsize) {
            List fields = struct.getFields();
            if ((long)i < this.dimsize - 1L) {
                buf.append("\n");
            }
            buf.append("Structure {\n");
            if (fields != null) {
                for (int j = 0; j < fields.size(); ++j) {
                    CDMArray array;
                    DapVariable field = (DapVariable)fields.get(j);
                    int offset = (int)((long)i * this.dimsize + (long)j);
                    String sfield = this.instances != null && offset < this.instances.length && this.instances[offset] != null ? ((array = this.instances[offset]) == null ? "null" : array.toString()) : "null";
                    buf.append(sfield + "\n");
                }
            }
            buf.append(String.format("} [%d/%d]", i, this.dimsize));
            ++i;
        }
        return buf.toString();
    }

    public long computeTotalSize() {
        long totalsize = 0L;
        int nmembers = this.getStructureMembers().getMembers().size();
        for (int recno = 0; recno < this.dimactual; ++recno) {
            for (int m = 0; m < nmembers; ++m) {
                int offset = (int)((long)recno * this.dimsize + (long)m);
                totalsize += this.instances[offset].getByteSize();
            }
        }
        return totalsize;
    }

    public Array getArray(int index, StructureMembers.Member m) {
        if (index < 0 || index >= this.instances.length) {
            throw new ArrayIndexOutOfBoundsException("CDMArrayStructure.getArray: index out of range: " + index);
        }
        int mindex = CDMArrayStructure.memberIndex(m);
        int offset = (int)((long)index * this.dimsize + (long)mindex);
        return (Array)this.instances[offset];
    }

    public double getScalarDouble(int index, StructureMembers.Member m) {
        CDMArrayAtomic data = this.getAtomicArray(index, m);
        return data.getDouble(0);
    }

    public float getScalarFloat(int index, StructureMembers.Member m) {
        CDMArrayAtomic data = this.getAtomicArray(index, m);
        return data.getFloat(0);
    }

    public byte getScalarByte(int index, StructureMembers.Member m) {
        CDMArrayAtomic data = this.getAtomicArray(index, m);
        return data.getByte(0);
    }

    public short getScalarShort(int index, StructureMembers.Member m) {
        CDMArrayAtomic data = this.getAtomicArray(index, m);
        return data.getShort(0);
    }

    public int getScalarInt(int index, StructureMembers.Member m) {
        CDMArrayAtomic data = this.getAtomicArray(index, m);
        return data.getInt(0);
    }

    public long getScalarLong(int index, StructureMembers.Member m) {
        CDMArrayAtomic data = this.getAtomicArray(index, m);
        return data.getLong(0);
    }

    public char getScalarChar(int index, StructureMembers.Member m) {
        CDMArrayAtomic data = this.getAtomicArray(index, m);
        return data.getChar(0);
    }

    public String getScalarString(int recnum, StructureMembers.Member m) {
        Array data = m.getDataArray();
        return data.getObject(recnum).toString();
    }

    public double[] getJavaArrayDouble(int recnum, StructureMembers.Member m) {
        D4DataAtomic data = this.getAtomicArray(recnum, m).getData();
        DapType atype = data.getType();
        long count = atype.getSize();
        try {
            Object vector = Dap4Util.createVector((AtomicType)atype.getPrimitiveType(), (long)count);
            data.read(0L, count, vector);
            return (double[])Dap4Util.convertVector((DapType)DapType.FLOAT64, (DapType)atype, (Object)vector);
        }
        catch (DataException de) {
            throw new UnsupportedOperationException(de);
        }
    }

    public float[] getJavaArrayFloat(int index, StructureMembers.Member m) {
        D4DataAtomic data = this.getAtomicArray(index, m).getData();
        DapType atype = data.getType();
        long count = atype.getSize();
        try {
            Object vector = Dap4Util.createVector((AtomicType)atype.getPrimitiveType(), (long)count);
            data.read(0L, count, vector);
            return (float[])Dap4Util.convertVector((DapType)DapType.FLOAT32, (DapType)atype, (Object)vector);
        }
        catch (DataException de) {
            throw new UnsupportedOperationException(de);
        }
    }

    public byte[] getJavaArrayByte(int index, StructureMembers.Member m) {
        D4DataAtomic data = this.getAtomicArray(index, m).getData();
        DapType atype = data.getType();
        long count = atype.getSize();
        try {
            Object vector = Dap4Util.createVector((AtomicType)atype.getPrimitiveType(), (long)count);
            data.read(0L, count, vector);
            return (byte[])Dap4Util.convertVector((DapType)DapType.INT8, (DapType)atype, (Object)vector);
        }
        catch (DataException de) {
            throw new UnsupportedOperationException(de);
        }
    }

    public short[] getJavaArrayShort(int index, StructureMembers.Member m) {
        D4DataAtomic data = this.getAtomicArray(index, m).getData();
        DapType atype = data.getType();
        long count = atype.getSize();
        try {
            Object vector = Dap4Util.createVector((AtomicType)atype.getPrimitiveType(), (long)count);
            data.read(0L, count, vector);
            return (short[])Dap4Util.convertVector((DapType)DapType.INT16, (DapType)atype, (Object)vector);
        }
        catch (DataException de) {
            throw new UnsupportedOperationException(de);
        }
    }

    public int[] getJavaArrayInt(int index, StructureMembers.Member m) {
        D4DataAtomic data = this.getAtomicArray(index, m).getData();
        DapType atype = data.getType();
        long count = atype.getSize();
        try {
            Object vector = Dap4Util.createVector((AtomicType)atype.getPrimitiveType(), (long)count);
            data.read(0L, count, vector);
            return (int[])Dap4Util.convertVector((DapType)DapType.INT32, (DapType)atype, (Object)vector);
        }
        catch (DataException de) {
            throw new UnsupportedOperationException(de);
        }
    }

    public long[] getJavaArrayLong(int index, StructureMembers.Member m) {
        D4DataAtomic data = this.getAtomicArray(index, m).getData();
        DapType atype = data.getType();
        long count = atype.getSize();
        try {
            Object vector = Dap4Util.createVector((AtomicType)atype.getPrimitiveType(), (long)count);
            data.read(0L, count, vector);
            return (long[])Dap4Util.convertVector((DapType)DapType.INT64, (DapType)atype, (Object)vector);
        }
        catch (DataException de) {
            throw new UnsupportedOperationException(de);
        }
    }

    public char[] getJavaArrayChar(int index, StructureMembers.Member m) {
        D4DataAtomic data = this.getAtomicArray(index, m).getData();
        DapType atype = data.getType();
        long count = atype.getSize();
        try {
            Object vector = Dap4Util.createVector((AtomicType)atype.getPrimitiveType(), (long)count);
            data.read(0L, count, vector);
            return (char[])Dap4Util.convertVector((DapType)DapType.CHAR, (DapType)atype, (Object)vector);
        }
        catch (DataException de) {
            throw new UnsupportedOperationException(de);
        }
    }

    public String[] getJavaArrayString(int index, StructureMembers.Member m) {
        D4DataAtomic data = this.getAtomicArray(index, m).getData();
        DapType atype = data.getType();
        long count = atype.getSize();
        try {
            Object vector = Dap4Util.createVector((AtomicType)atype.getPrimitiveType(), (long)count);
            data.read(0L, count, vector);
            return (String[])Dap4Util.convertVector((DapType)DapType.STRING, (DapType)atype, (Object)vector);
        }
        catch (DataException de) {
            throw new UnsupportedOperationException(de);
        }
    }

    public ByteBuffer[] getJavaArrayOpaque(int index, StructureMembers.Member m) {
        D4DataAtomic data = this.getAtomicArray(index, m).getData();
        DapType atype = data.getType();
        long count = atype.getSize();
        try {
            Object vector = Dap4Util.createVector((AtomicType)atype.getPrimitiveType(), (long)count);
            data.read(0L, count, vector);
            return (ByteBuffer[])Dap4Util.convertVector((DapType)DapType.OPAQUE, (DapType)atype, (Object)vector);
        }
        catch (DataException de) {
            throw new UnsupportedOperationException(de);
        }
    }

    public StructureData getScalarStructure(int index, StructureMembers.Member m) {
        if (m.getDataType() != DataType.STRUCTURE) {
            throw new ForbiddenConversionException("Atomic field cannot be converted to Structure");
        }
        CDMArray ca = this.memberArray(index, CDMArrayStructure.memberIndex(m));
        if (!ca.getBaseType().isCompound()) {
            throw new ForbiddenConversionException("Attempt to access non-structure member");
        }
        CDMArrayStructure as = (CDMArrayStructure)ca;
        return as.getStructureData(0);
    }

    public ArrayStructure getArrayStructure(int index, StructureMembers.Member m) {
        if (m.getDataType() != DataType.STRUCTURE) {
            throw new ForbiddenConversionException("Atomic field cannot be converted to Structure");
        }
        CDMArray dd = this.memberArray(index, CDMArrayStructure.memberIndex(m));
        if (!dd.getBaseType().isCompound()) {
            throw new ForbiddenConversionException("Attempt to access non-structure member");
        }
        return (CDMArrayStructure)dd;
    }

    public ArraySequence getArraySequence(StructureMembers.Member m) {
        throw new UnsupportedOperationException("CDMArraySequence");
    }

    protected StructureData makeStructureData(ArrayStructure as, int index) {
        if (this.structdata[index] == null) {
            this.structdata[index] = new StructureDataA(as, index);
        }
        return this.structdata[index];
    }

    protected static StructureMembers computemembers(DapStructure ds) {
        StructureMembers sm = new StructureMembers(ds.getShortName());
        List fields = ds.getFields();
        for (int i = 0; i < fields.size(); ++i) {
            DapVariable field = (DapVariable)fields.get(i);
            StructureMembers.Member m = sm.addMember(field.getShortName(), "", null, CDMUtil.daptype2cdmtype((DapType)field.getBaseType()), CDMUtil.computeEffectiveShape((List)ds.getDimensions()));
            m.setDataParam(i);
            if (field.getSort() != DapSort.STRUCTURE) continue;
            StructureMembers subsm = CDMArrayStructure.computemembers((DapStructure)field);
            m.setStructureMembers(subsm);
        }
        return sm;
    }

    protected CDMArray memberArray(int recno, int memberindex) {
        int offset = (int)((long)recno * this.dimsize + (long)memberindex);
        CDMArray cdmdata = this.instances[offset];
        return cdmdata;
    }

    protected static int memberIndex(StructureMembers.Member m) {
        return m.getDataParam();
    }

    protected CDMArrayAtomic getAtomicArray(int index, StructureMembers.Member m) {
        CDMArray dd = this.memberArray(index, CDMArrayStructure.memberIndex(m));
        if (!dd.getBaseType().isCompound()) {
            return (CDMArrayAtomic)dd;
        }
        throw new ForbiddenConversionException("Cannot convert structure to AtomicArray");
    }
}

