/*
 * Decompiled with CFR 0.152.
 */
package dap4.cdm;

import dap4.cdm.CDMArray;
import dap4.cdm.CDMArrayAtomic;
import dap4.cdm.CDMArrayStructure;
import dap4.cdm.CDMDataset;
import dap4.cdm.DSPToCDM;
import dap4.cdm.DapNetcdfFile;
import dap4.cdmshared.NodeMap;
import dap4.core.data.DataSort;
import dap4.core.data.DataVariable;
import dap4.core.dmr.DapAtomicVariable;
import dap4.core.dmr.DapDataset;
import dap4.core.dmr.DapNode;
import dap4.core.dmr.DapStructure;
import dap4.core.dmr.DapType;
import dap4.core.dmr.DapVariable;
import dap4.core.util.DapException;
import dap4.core.util.DapUtil;
import dap4.core.util.Escape;
import dap4.dap4shared.D4DSP;
import dap4.dap4shared.D4DataAtomic;
import dap4.dap4shared.D4DataCompoundArray;
import dap4.dap4shared.D4DataDataset;
import dap4.dap4shared.D4DataStructure;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;
import ucar.ma2.Array;
import ucar.nc2.Attribute;
import ucar.nc2.Variable;

public class CDMCompiler {
    static final boolean DEBUG = false;
    static final boolean DUMP = false;
    static final int COUNTSIZE = 8;
    static String LBRACE = "{";
    static String RBRACE = "}";
    static final String CHECKSUMATTRNAME = "_DAP4_Checksum_CRC32";
    static final int CHECKSUMSIZE = 4;
    DapNetcdfFile ncfile = null;
    D4DSP dsp = null;
    DapDataset dmr = null;
    D4DataDataset d4root = null;
    CDMDataset cdmroot = null;
    NodeMap nodemap = new NodeMap();

    public CDMCompiler(DapNetcdfFile ncfile, D4DSP dsp) throws DapException {
        this.ncfile = ncfile;
        this.dsp = dsp;
        this.d4root = (D4DataDataset)dsp.getDataDataset();
        this.dmr = dsp.getDMR();
    }

    public NodeMap getNodeMap() {
        return this.nodemap;
    }

    protected void compileDMR() throws DapException {
        this.nodemap = new DSPToCDM(this.ncfile, this.dmr).create();
    }

    void compile() throws DapException {
        assert (this.d4root.getSort() == DataSort.DATASET);
        this.compileDMR();
        List vars = this.d4root.getTopVariables();
        for (DataVariable var : vars) {
            CDMArray array = this.compileVar(var);
            Variable cdmvar = (Variable)this.nodemap.get(var.getTemplate());
            cdmvar.setCachedData((Array)array);
        }
    }

    protected CDMArray compileVar(DataVariable d4var) throws DapException {
        CDMArray array = null;
        DapVariable dapvar = (DapVariable)d4var.getTemplate();
        switch (d4var.getSort()) {
            case ATOMIC: {
                array = this.compileAtomicVar(d4var);
                break;
            }
            case SEQUENCE: {
                array = null;
                break;
            }
            case COMPOUNDARRAY: {
                array = this.compileStructureArray((D4DataCompoundArray)d4var);
                break;
            }
            default: {
                assert (false) : "Unexpected databuffer sort: " + d4var.getSort();
                break;
            }
        }
        if (dapvar.isTopLevel()) {
            byte[] csum = dapvar.getChecksum();
            String scsum = Escape.bytes2hex((byte[])csum);
            Variable cdmvar = (Variable)this.nodemap.get((DapNode)dapvar);
            Attribute acsum = new Attribute(CHECKSUMATTRNAME, scsum);
            cdmvar.addAttribute(acsum);
        }
        return array;
    }

    protected CDMArray compileAtomicVar(DataVariable d4var) throws DapException {
        DapAtomicVariable atomvar = (DapAtomicVariable)d4var.getTemplate();
        DapType daptype = atomvar.getBaseType();
        CDMArrayAtomic array = new CDMArrayAtomic(this.dsp, this.cdmroot, (D4DataAtomic)d4var);
        return array;
    }

    protected CDMArray compileStructure(D4DataStructure d4var, int index, CDMArrayStructure container) throws DapException {
        assert (d4var.getSort() == DataSort.STRUCTURE);
        DapStructure dapstruct = (DapStructure)d4var.getTemplate();
        assert (dapstruct.getRank() > 0 || index == 0);
        int nmembers = dapstruct.getFields().size();
        List dfields = dapstruct.getFields();
        assert (nmembers == dfields.size());
        for (int m = 0; m < nmembers; ++m) {
            DataVariable dfield = d4var.readfield(m);
            CDMArray afield = this.compileVar(dfield);
            container.addField((long)index, m, afield);
        }
        container.finish();
        return container;
    }

    protected CDMArray compileStructureArray(D4DataCompoundArray d4var) throws DapException {
        assert (d4var.getSort() == DataSort.COMPOUNDARRAY);
        DapStructure dapstruct = (DapStructure)d4var.getTemplate();
        long dimproduct = DapUtil.dimProduct((List)dapstruct.getDimensions());
        CDMArrayStructure arraystruct = new CDMArrayStructure(this.dsp, this.cdmroot, d4var);
        try {
            int i = 0;
            while ((long)i < dimproduct) {
                D4DataStructure dds = (D4DataStructure)d4var.read((long)i);
                this.compileStructure(dds, i, arraystruct);
                ++i;
            }
            arraystruct.finish();
            return arraystruct;
        }
        catch (IOException ioe) {
            throw new DapException((Throwable)ioe);
        }
    }

    static void skip(ByteBuffer data, int count) {
        data.position(data.position() + count);
    }

    static int getCount(ByteBuffer data) {
        long count = data.getLong();
        return (int)(count & 0xFFFFFFFFFFFFFFFFL);
    }

    static long walkByteStrings(int[] positions, ByteBuffer databuffer) {
        int count = positions.length;
        long total = 0L;
        int savepos = databuffer.position();
        for (int i = 0; i < count; ++i) {
            int pos;
            positions[i] = pos = databuffer.position();
            int size = CDMCompiler.getCount(databuffer);
            total += 8L;
            total += (long)size;
            CDMCompiler.skip(databuffer, size);
        }
        databuffer.position(savepos);
        return total;
    }
}

