/*
 * Decompiled with CFR 0.152.
 */
package dap4.cdm;

import dap4.cdm.CDMArray;
import dap4.cdm.CDMArrayAtomic;
import dap4.cdm.CDMDataset;
import dap4.cdmshared.CDMUtil;
import dap4.core.data.DataException;
import dap4.core.dmr.AtomicType;
import dap4.core.dmr.DapStructure;
import dap4.core.dmr.DapType;
import dap4.core.dmr.DapVariable;
import dap4.core.util.DapSort;
import dap4.core.util.DapUtil;
import dap4.dap4shared.D4DSP;
import dap4.dap4shared.D4DataAtomic;
import dap4.dap4shared.D4DataCompoundArray;
import dap4.dap4shared.DSP;
import dap4.dap4shared.Dap4Util;
import java.nio.ByteBuffer;
import java.util.List;
import ucar.ma2.Array;
import ucar.ma2.ArraySequence;
import ucar.ma2.ArrayStructure;
import ucar.ma2.DataType;
import ucar.ma2.ForbiddenConversionException;
import ucar.ma2.StructureData;
import ucar.ma2.StructureDataA;
import ucar.ma2.StructureMembers;

public class CDMArrayStructure
extends ArrayStructure
implements CDMArray {
    protected CDMDataset root = null;
    protected D4DSP dsp = null;
    protected DapVariable template = null;
    protected long bytesize = 0L;
    protected DapType basetype = null;
    protected AtomicType primitivetype = null;
    protected D4DataCompoundArray d4data = null;
    protected long dimsize = 0L;
    protected long nmembers = 0L;
    protected Array[][] instances = null;

    CDMArrayStructure(D4DSP dsp, CDMDataset root, D4DataCompoundArray d4data) {
        super(CDMArrayStructure.computemembers((DapStructure)d4data.getTemplate()), CDMUtil.computeEffectiveShape((List)((DapVariable)d4data.getTemplate()).getDimensions()));
        this.dsp = dsp;
        this.root = root;
        this.template = (DapVariable)d4data.getTemplate();
        this.basetype = this.template.getBaseType();
        this.primitivetype = this.basetype.getPrimitiveType();
        this.dimsize = DapUtil.dimProduct((List)this.template.getDimensions());
        this.d4data = d4data;
        this.nmembers = ((DapStructure)this.template).getFields().size();
        this.sdata = new StructureDataA[(int)this.dimsize];
        this.instances = new Array[(int)this.dimsize][(int)this.nmembers];
        int i = 0;
        while ((long)i < this.dimsize) {
            this.sdata[i] = new StructureDataA((ArrayStructure)this, i);
            this.instances[i] = new Array[(int)this.nmembers];
            ++i;
        }
    }

    void finish() {
        int i = 0;
        while ((long)i < this.dimsize) {
            assert (this.instances[i] != null);
            ++i;
        }
        this.bytesize = this.computeTotalSize();
    }

    @Override
    public DSP getDSP() {
        return this.dsp;
    }

    @Override
    public CDMDataset getRoot() {
        return this.root;
    }

    @Override
    public DapVariable getTemplate() {
        return this.template;
    }

    @Override
    public long getByteSize() {
        return this.bytesize;
    }

    @Override
    public DapType getBaseType() {
        return this.basetype;
    }

    @Override
    public AtomicType getPrimitiveType() {
        return this.primitivetype;
    }

    public long getSize() {
        return this.dimsize;
    }

    void addField(int index, StructureMembers.Member m, Array instance) {
        int mindex = CDMArrayStructure.memberIndex(m);
        this.addField(index, m, instance);
    }

    void addField(long recno, int mindex, Array instance) {
        assert (this.instances != null) : "Internal Error";
        if (recno < 0L || recno >= this.dimsize) {
            throw new ArrayIndexOutOfBoundsException("CDMArrayStructure: dimension index out of range: " + recno);
        }
        if (mindex < 0 || (long)mindex >= this.nmembers) {
            throw new ArrayIndexOutOfBoundsException("CDMArrayStructure: member index out of range: " + mindex);
        }
        this.instances[(int)recno][mindex] = instance;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        DapStructure struct = (DapStructure)this.template;
        int i = 0;
        while ((long)i < this.dimsize) {
            List fields = struct.getFields();
            if ((long)i < this.dimsize - 1L) {
                buf.append("\n");
            }
            buf.append("Structure {\n");
            if (fields != null) {
                int nmembers = fields.size();
                for (int j = 0; j < nmembers; ++j) {
                    DapVariable field = (DapVariable)fields.get(j);
                    Array array = this.instances[i][j];
                    String sfield = array == null ? "null" : array.toString();
                    buf.append(sfield + "\n");
                }
            }
            buf.append(String.format("} [%d/%d]", i, this.dimsize));
            ++i;
        }
        return buf.toString();
    }

    public long computeTotalSize() {
        long totalsize = 0L;
        int recno = 0;
        while ((long)recno < this.dimsize) {
            int m = 0;
            while ((long)m < this.nmembers) {
                totalsize += this.instances[recno][m].getSizeBytes();
                ++m;
            }
            ++recno;
        }
        return totalsize;
    }

    public StructureData getStructureData(int index) {
        if (this.sdata == null || index < 0 || (long)index >= this.dimsize) {
            throw new IllegalArgumentException(index + " >= " + this.sdata.length);
        }
        assert (this.sdata[index] != null);
        return this.sdata[index];
    }

    public Array getArray(int recno, StructureMembers.Member m) {
        return this.memberArray(recno, CDMArrayStructure.memberIndex(m));
    }

    public double getScalarDouble(int index, StructureMembers.Member m) {
        CDMArrayAtomic data = this.getAtomicArray(index, m);
        return data.getDouble(0);
    }

    public float getScalarFloat(int index, StructureMembers.Member m) {
        CDMArrayAtomic data = this.getAtomicArray(index, m);
        return data.getFloat(0);
    }

    public byte getScalarByte(int index, StructureMembers.Member m) {
        CDMArrayAtomic data = this.getAtomicArray(index, m);
        return data.getByte(0);
    }

    public short getScalarShort(int index, StructureMembers.Member m) {
        CDMArrayAtomic data = this.getAtomicArray(index, m);
        return data.getShort(0);
    }

    public int getScalarInt(int index, StructureMembers.Member m) {
        CDMArrayAtomic data = this.getAtomicArray(index, m);
        return data.getInt(0);
    }

    public long getScalarLong(int index, StructureMembers.Member m) {
        CDMArrayAtomic data = this.getAtomicArray(index, m);
        return data.getLong(0);
    }

    public char getScalarChar(int index, StructureMembers.Member m) {
        CDMArrayAtomic data = this.getAtomicArray(index, m);
        return data.getChar(0);
    }

    public String getScalarString(int recnum, StructureMembers.Member m) {
        Array data = m.getDataArray();
        return data.getObject(recnum).toString();
    }

    public double[] getJavaArrayDouble(int recnum, StructureMembers.Member m) {
        D4DataAtomic data = this.getAtomicArray(recnum, m).getData();
        DapType atype = data.getType();
        long count = atype.getSize();
        try {
            Object vector = Dap4Util.createVector((AtomicType)atype.getPrimitiveType(), (long)count);
            data.read(0L, count, vector, 0L);
            return (double[])Dap4Util.convertVector((DapType)DapType.FLOAT64, (DapType)atype, (Object)vector);
        }
        catch (DataException de) {
            throw new UnsupportedOperationException(de);
        }
    }

    public float[] getJavaArrayFloat(int index, StructureMembers.Member m) {
        D4DataAtomic data = this.getAtomicArray(index, m).getData();
        DapType atype = data.getType();
        long count = atype.getSize();
        try {
            Object vector = Dap4Util.createVector((AtomicType)atype.getPrimitiveType(), (long)count);
            data.read(0L, count, vector, 0L);
            return (float[])Dap4Util.convertVector((DapType)DapType.FLOAT32, (DapType)atype, (Object)vector);
        }
        catch (DataException de) {
            throw new UnsupportedOperationException(de);
        }
    }

    public byte[] getJavaArrayByte(int index, StructureMembers.Member m) {
        D4DataAtomic data = this.getAtomicArray(index, m).getData();
        DapType atype = data.getType();
        long count = atype.getSize();
        try {
            Object vector = Dap4Util.createVector((AtomicType)atype.getPrimitiveType(), (long)count);
            data.read(0L, count, vector, 0L);
            return (byte[])Dap4Util.convertVector((DapType)DapType.INT8, (DapType)atype, (Object)vector);
        }
        catch (DataException de) {
            throw new UnsupportedOperationException(de);
        }
    }

    public short[] getJavaArrayShort(int index, StructureMembers.Member m) {
        D4DataAtomic data = this.getAtomicArray(index, m).getData();
        DapType atype = data.getType();
        long count = atype.getSize();
        try {
            Object vector = Dap4Util.createVector((AtomicType)atype.getPrimitiveType(), (long)count);
            data.read(0L, count, vector, 0L);
            return (short[])Dap4Util.convertVector((DapType)DapType.INT16, (DapType)atype, (Object)vector);
        }
        catch (DataException de) {
            throw new UnsupportedOperationException(de);
        }
    }

    public int[] getJavaArrayInt(int index, StructureMembers.Member m) {
        D4DataAtomic data = this.getAtomicArray(index, m).getData();
        DapType atype = data.getType();
        long count = atype.getSize();
        try {
            Object vector = Dap4Util.createVector((AtomicType)atype.getPrimitiveType(), (long)count);
            data.read(0L, count, vector, 0L);
            return (int[])Dap4Util.convertVector((DapType)DapType.INT32, (DapType)atype, (Object)vector);
        }
        catch (DataException de) {
            throw new UnsupportedOperationException(de);
        }
    }

    public long[] getJavaArrayLong(int index, StructureMembers.Member m) {
        D4DataAtomic data = this.getAtomicArray(index, m).getData();
        DapType atype = data.getType();
        long count = atype.getSize();
        try {
            Object vector = Dap4Util.createVector((AtomicType)atype.getPrimitiveType(), (long)count);
            data.read(0L, count, vector, 0L);
            return (long[])Dap4Util.convertVector((DapType)DapType.INT64, (DapType)atype, (Object)vector);
        }
        catch (DataException de) {
            throw new UnsupportedOperationException(de);
        }
    }

    public char[] getJavaArrayChar(int index, StructureMembers.Member m) {
        D4DataAtomic data = this.getAtomicArray(index, m).getData();
        DapType atype = data.getType();
        long count = atype.getSize();
        try {
            Object vector = Dap4Util.createVector((AtomicType)atype.getPrimitiveType(), (long)count);
            data.read(0L, count, vector, 0L);
            return (char[])Dap4Util.convertVector((DapType)DapType.CHAR, (DapType)atype, (Object)vector);
        }
        catch (DataException de) {
            throw new UnsupportedOperationException(de);
        }
    }

    public String[] getJavaArrayString(int index, StructureMembers.Member m) {
        D4DataAtomic data = this.getAtomicArray(index, m).getData();
        DapType atype = data.getType();
        long count = atype.getSize();
        try {
            Object vector = Dap4Util.createVector((AtomicType)atype.getPrimitiveType(), (long)count);
            data.read(0L, count, vector, 0L);
            return (String[])Dap4Util.convertVector((DapType)DapType.STRING, (DapType)atype, (Object)vector);
        }
        catch (DataException de) {
            throw new UnsupportedOperationException(de);
        }
    }

    public ByteBuffer[] getJavaArrayOpaque(int index, StructureMembers.Member m) {
        D4DataAtomic data = this.getAtomicArray(index, m).getData();
        DapType atype = data.getType();
        long count = atype.getSize();
        try {
            Object vector = Dap4Util.createVector((AtomicType)atype.getPrimitiveType(), (long)count);
            data.read(0L, count, vector, 0L);
            return (ByteBuffer[])Dap4Util.convertVector((DapType)DapType.OPAQUE, (DapType)atype, (Object)vector);
        }
        catch (DataException de) {
            throw new UnsupportedOperationException(de);
        }
    }

    public StructureData getScalarStructure(int index, StructureMembers.Member m) {
        if (m.getDataType() != DataType.STRUCTURE) {
            throw new ForbiddenConversionException("Atomic field cannot be converted to Structure");
        }
        Array ca = this.memberArray(index, CDMArrayStructure.memberIndex(m));
        if (ca.getDataType() != DataType.STRUCTURE && ca.getDataType() != DataType.SEQUENCE) {
            throw new ForbiddenConversionException("Attempt to access non-structure member");
        }
        CDMArrayStructure as = (CDMArrayStructure)ca;
        return as.getStructureData(0);
    }

    public ArrayStructure getArrayStructure(int index, StructureMembers.Member m) {
        if (m.getDataType() != DataType.STRUCTURE) {
            throw new ForbiddenConversionException("Atomic field cannot be converted to Structure");
        }
        Array dd = this.memberArray(index, CDMArrayStructure.memberIndex(m));
        if (dd.getDataType() != DataType.STRUCTURE && dd.getDataType() != DataType.SEQUENCE) {
            throw new ForbiddenConversionException("Attempt to access non-structure member");
        }
        return (CDMArrayStructure)dd;
    }

    public ArraySequence getArraySequence(StructureMembers.Member m) {
        throw new UnsupportedOperationException("CDMArraySequence");
    }

    public Array copy() {
        return this;
    }

    protected StructureData makeStructureData(ArrayStructure as, int index) {
        if (this.sdata[index] == null) {
            this.sdata[index] = new StructureDataA(as, index);
        }
        return this.sdata[index];
    }

    static StructureMembers computemembers(DapStructure ds) {
        StructureMembers sm = new StructureMembers(ds.getShortName());
        List fields = ds.getFields();
        for (int i = 0; i < fields.size(); ++i) {
            DapVariable field = (DapVariable)fields.get(i);
            StructureMembers.Member m = sm.addMember(field.getShortName(), "", null, CDMUtil.daptype2cdmtype((DapType)field.getBaseType()), CDMUtil.computeEffectiveShape((List)ds.getDimensions()));
            m.setDataParam(i);
            if (field.getSort() != DapSort.STRUCTURE) continue;
            StructureMembers subsm = CDMArrayStructure.computemembers((DapStructure)field);
            m.setStructureMembers(subsm);
        }
        return sm;
    }

    protected Array memberArray(int recno, int memberindex) {
        Array cdmdata = this.instances[recno][memberindex];
        return cdmdata;
    }

    protected static int memberIndex(StructureMembers.Member m) {
        return m.getDataParam();
    }

    protected CDMArrayAtomic getAtomicArray(int index, StructureMembers.Member m) {
        Array dd = this.memberArray(index, CDMArrayStructure.memberIndex(m));
        if (dd.getDataType() != DataType.STRUCTURE && dd.getDataType() != DataType.SEQUENCE) {
            return (CDMArrayAtomic)dd;
        }
        throw new ForbiddenConversionException("Cannot convert structure to AtomicArray");
    }
}

