/*
 * Decompiled with CFR 0.152.
 */
package dap4.cdm;

import dap4.cdm.CDMCompiler;
import dap4.cdmshared.CDMUtil;
import dap4.cdmshared.NodeMap;
import dap4.dap4shared.ChecksumMode;
import dap4.dap4shared.D4DSP;
import dap4.dap4shared.DSP;
import dap4.dap4shared.FileDSP;
import dap4.dap4shared.HttpDSP;
import dap4.dap4shared.RequestMode;
import dap4.dap4shared.XURI;
import java.io.IOException;
import java.net.URISyntaxException;
import java.nio.channels.WritableByteChannel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import ucar.ma2.Array;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.Section;
import ucar.nc2.NetcdfFile;
import ucar.nc2.ParsedSectionSpec;
import ucar.nc2.Variable;
import ucar.nc2.iosp.IospHelper;
import ucar.nc2.util.CancelTask;

public class DapNetcdfFile
extends NetcdfFile {
    static final boolean DEBUG = false;
    static final boolean PARSEDEBUG = false;
    static final boolean MERGE = false;
    static final String QUERYSTART = "?";
    static final String FRAGSTART = "#";
    protected static final NullCancelTask nullcancel = new NullCancelTask();
    protected boolean allowCompression = true;
    protected boolean closed = false;
    protected String originalurl = null;
    protected String finalurl = null;
    protected XURI xuri = null;
    protected D4DSP dsp = null;
    protected CancelTask cancel = null;
    protected NodeMap nodemap = null;
    protected Map<Variable, Array> arraymap = new HashMap<Variable, Array>();

    public DapNetcdfFile(String url, CancelTask cancelTask) throws IOException {
        XURI xuri;
        this.originalurl = url;
        try {
            xuri = new XURI(url);
        }
        catch (URISyntaxException use) {
            throw new IOException(use);
        }
        List protocols = xuri.getProtocols();
        url = xuri.assemble(XURI.URLALL);
        switch (protocols.size()) {
            case 0: {
                if (!xuri.isFile()) break;
                url = "file://" + url;
                break;
            }
            case 1: {
                if (!((String)protocols.get(0)).equalsIgnoreCase("dap4")) break;
                url = "http" + url.substring(4, url.length());
                break;
            }
            case 2: {
                if (!((String)protocols.get(0)).equalsIgnoreCase("dap4")) break;
                url = url.substring(5, url.length());
                break;
            }
        }
        this.finalurl = url;
        this.cancel = cancelTask == null ? nullcancel : cancelTask;
        this.dsp = xuri.isFile() ? (D4DSP)new FileDSP().open(url) : (D4DSP)new HttpDSP().open(url);
        CDMCompiler compiler = new CDMCompiler(this, this.dsp);
        compiler.compile(this.arraymap);
        this.setLocation(this.dsp.getDMR().getDataset().getShortName());
    }

    public DapNetcdfFile(String url) throws IOException {
        this(url, null);
    }

    public synchronized void close() throws IOException {
        if (this.closed) {
            return;
        }
        this.closed = true;
        this.dsp = null;
        this.nodemap = null;
    }

    public boolean isconstrainable() {
        return true;
    }

    public String getURL() {
        return this.originalurl;
    }

    public DSP getDSP() {
        return this.dsp;
    }

    public List<Array> readArrays(List<Variable> variables) throws IOException {
        ArrayList<Array> result = new ArrayList<Array>();
        for (Variable variable : variables) {
            result.add(variable.read());
        }
        return result;
    }

    public long readToByteChannel(Variable v, Section section, WritableByteChannel channel) throws IOException, InvalidRangeException {
        Array result = this.readData(v, section);
        return IospHelper.transferData((Array)result, (WritableByteChannel)channel);
    }

    public Array readSection(String variableSection) throws IOException, InvalidRangeException {
        ParsedSectionSpec cer = ParsedSectionSpec.parseVariableSection((NetcdfFile)this, (String)variableSection);
        return cer.v.read(cer.section);
    }

    protected Array readData(Variable cdmvar, Section section) throws IOException, InvalidRangeException {
        assert (this.dsp != null);
        Array result = this.arraymap.get(cdmvar);
        if (result == null) {
            throw new IOException("No data for variable: " + cdmvar.getFullName());
        }
        if (section != null) {
            if (cdmvar.getRank() != section.getRank()) {
                throw new InvalidRangeException(String.format("Section rank != %s rank", cdmvar.getFullName()));
            }
            List ranges = section.getRanges();
            if (CDMUtil.hasVLEN((List)ranges)) {
                ranges = ranges.subList(0, ranges.size() - 1);
            }
            if (ranges.size() > 0 && !CDMUtil.isWhole((List)ranges, (Variable)cdmvar)) {
                result = result.sectionNoReduce(ranges);
            }
        }
        return result;
    }

    protected static class NullCancelTask
    implements CancelTask {
        protected NullCancelTask() {
        }

        public boolean isCancel() {
            return false;
        }

        public void setError(String msg) {
        }

        public void setProgress(String msg, int progress) {
        }
    }

    protected static class State {
        RequestMode requestmode = null;
        ChecksumMode checksummode = null;
        int status = 0;
        boolean bigendian = false;

        protected State() {
        }
    }
}

