/*
 * Decompiled with CFR 0.152.
 */
package dap4.dap4;

import dap4.core.data.DataAtomic;
import dap4.core.data.DataDataset;
import dap4.core.data.DataException;
import dap4.core.data.DataRecord;
import dap4.core.data.DataSequence;
import dap4.core.data.DataSort;
import dap4.core.data.DataStructure;
import dap4.core.data.DataVariable;
import dap4.core.dmr.AtomicType;
import dap4.core.dmr.DapAtomicVariable;
import dap4.core.dmr.DapAttribute;
import dap4.core.dmr.DapDataset;
import dap4.core.dmr.DapDimension;
import dap4.core.dmr.DapEnum;
import dap4.core.dmr.DapGroup;
import dap4.core.dmr.DapMap;
import dap4.core.dmr.DapNode;
import dap4.core.dmr.DapSequence;
import dap4.core.dmr.DapStructure;
import dap4.core.dmr.DapType;
import dap4.core.dmr.DapVariable;
import dap4.core.util.DapException;
import dap4.core.util.DapSort;
import dap4.core.util.DapUtil;
import dap4.core.util.Escape;
import dap4.core.util.IndentWriter;
import dap4.core.util.Odometer;
import dap4.dap4shared.D4DSP;
import dap4.dap4shared.D4DataCompoundArray;
import dap4.dap4shared.D4DataDataset;
import dap4.dap4shared.HttpDSP;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;

public class Dap4Print {
    protected static final int COLUMNS = 8;
    protected static final char LPAREN = '(';
    protected static final char RPAREN = ')';
    protected static final char LBRACE = '{';
    protected static final char RBRACE = '}';
    protected static final char LBRACKET = '[';
    protected static final char RBRACKET = ']';
    protected static final int NILFLAGS = 0;
    protected static final int PERLINE = 1;
    protected static final int NONAME = 2;
    protected static final int NONNIL = 4;
    protected String originalurl = null;
    protected PrintWriter writer = null;
    protected IndentWriter printer = null;
    protected D4DSP dsp = null;
    protected DapDataset dmr = null;
    protected DataDataset data = null;

    public Dap4Print(String url, PrintWriter writer) {
        this.writer = writer;
        this.printer = new IndentWriter((Writer)this.writer);
        this.originalurl = url;
    }

    public void print() throws DapException {
        this.dsp = (D4DSP)new HttpDSP().open(this.originalurl);
        this.dmr = this.dsp.getDMR();
        this.data = (D4DataDataset)this.dsp.getDataDataset();
        this.printer.setIndent(0);
        this.print((DapNode)this.dmr);
        this.printer.eol();
        this.printer.setIndent(0);
        this.printData();
        this.printer.eol();
    }

    void print(DapNode node) throws DapException {
        if (node == null) {
            return;
        }
        DapSort sort = node.getSort();
        String dmrname = sort.getName();
        switch (sort) {
            case DATASET: 
            case GROUP: {
                DapGroup group = (DapGroup)node;
                this.printer.marginPrint("<" + dmrname);
                int flags = sort == DapSort.DATASET ? 1 : 0;
                this.printXMLAttributes(node, flags);
                this.printer.println(">");
                this.printer.indent();
                if (group.getDimensions().size() > 0) {
                    for (DapNode subnode : group.getDimensions()) {
                        this.print(subnode);
                        this.printer.eol();
                    }
                }
                if (group.getEnums().size() > 0) {
                    for (DapNode subnode : group.getEnums()) {
                        this.print(subnode);
                        this.printer.eol();
                    }
                }
                if (group.getVariables().size() > 0) {
                    for (DapNode subnode : group.getVariables()) {
                        this.print(subnode);
                        this.printer.eol();
                    }
                }
                this.printMetadata(node);
                if (group.getGroups().size() > 0) {
                    for (DapNode subnode : group.getGroups()) {
                        this.print(subnode);
                        this.printer.eol();
                    }
                }
                this.printer.outdent();
                this.printer.marginPrint("</" + dmrname + ">");
                break;
            }
            case DIMENSION: {
                DapDimension dim = (DapDimension)node;
                if (!dim.isShared()) break;
                this.printer.marginPrint("<" + dmrname);
                this.printXMLAttributes(node, 0);
                if (Dap4Print.hasMetadata(node)) {
                    this.printer.println(">");
                    this.printMetadata(node);
                    this.printer.marginPrint("</" + dmrname + ">");
                    break;
                }
                this.printer.print("/>");
                break;
            }
            case ENUMERATION: {
                DapEnum en = (DapEnum)node;
                this.printer.marginPrint("<" + dmrname);
                this.printXMLAttributes((DapNode)en, 0);
                this.printer.println(">");
                this.printer.indent();
                List econstnames = en.getNames();
                for (String econst : econstnames) {
                    Long value = en.lookup(econst);
                    assert (value != null);
                    this.printer.marginPrintln(String.format("<EnumConst name=\"%s\" value=\"%s\"/>", Escape.entityEscape((String)econst), value.toString()));
                }
                this.printMetadata(node);
                this.printer.outdent();
                this.printer.marginPrint("</" + dmrname + ">");
                break;
            }
            case STRUCTURE: 
            case SEQUENCE: {
                DapStructure struct = (DapStructure)node;
                this.printer.marginPrint("<" + dmrname);
                this.printXMLAttributes(node, 0);
                this.printer.println(">");
                this.printer.indent();
                for (DapVariable field : struct.getFields()) {
                    this.print((DapNode)field);
                    this.printer.eol();
                }
                this.printDimrefs((DapVariable)struct);
                this.printMetadata(node);
                this.printMaps((DapVariable)struct);
                this.printer.outdent();
                this.printer.marginPrint("</" + dmrname + ">");
                break;
            }
            case ATOMICVARIABLE: {
                DapAtomicVariable var = (DapAtomicVariable)node;
                DapType basetype = var.getBaseType();
                this.printer.marginPrint("<" + basetype.getAtomicType().name());
                this.printXMLAttributes(node, 0);
                if (Dap4Print.hasMetadata(node) || Dap4Print.hasDimensions((DapVariable)var) || Dap4Print.hasMaps((DapVariable)var)) {
                    this.printer.println(">");
                    this.printer.indent();
                    if (Dap4Print.hasDimensions((DapVariable)var)) {
                        this.printDimrefs((DapVariable)var);
                    }
                    if (Dap4Print.hasMetadata((DapNode)var)) {
                        this.printMetadata((DapNode)var);
                    }
                    if (Dap4Print.hasMaps((DapVariable)var)) {
                        this.printMaps((DapVariable)var);
                    }
                    this.printer.outdent();
                    this.printer.marginPrint("</" + basetype.getAtomicType().name() + ">");
                    break;
                }
                this.printer.print("/>");
                break;
            }
            default: {
                assert (false) : "Unexpected sort: " + sort.name();
                break;
            }
        }
    }

    void printXMLAttributes(DapNode node, int flags) throws DapException {
        String name;
        if ((flags & 1) != 0) {
            this.printer.indent(2);
        }
        if ((name = node.getShortName()) != null && (flags & 2) == 0) {
            name = node.getShortName();
            this.printXMLAttribute("name", name, flags);
        }
        switch (node.getSort()) {
            case DATASET: {
                DapDataset dataset = (DapDataset)node;
                this.printXMLAttribute("dapVersion", dataset.getDapVersion(), flags);
                this.printXMLAttribute("dmrVersion", dataset.getDMRVersion(), flags);
                this.printXMLAttribute("xmlns", "http://xml.opendap.org/ns/DAP/4.0#", flags);
                this.printXMLAttribute("xmlns:dap", "http://xml.opendap.org/ns/DAP/4.0#", flags);
                break;
            }
            case DIMENSION: {
                DapDimension orig = (DapDimension)node;
                long size = orig.getSize();
                this.printXMLAttribute("size", Long.toString(size), flags);
                break;
            }
            case ENUMERATION: {
                this.printXMLAttribute("basetype", ((DapEnum)node).getBaseType().getTypeName(), flags);
                break;
            }
            case ATOMICVARIABLE: {
                DapAtomicVariable atom = (DapAtomicVariable)node;
                DapType basetype = atom.getBaseType();
                if (!basetype.isEnumType()) break;
                this.printXMLAttribute("enum", basetype.getTypeName(), flags);
                break;
            }
            case ATTRIBUTE: {
                DapAttribute attr = (DapAttribute)node;
                DapType basetype = attr.getBaseType();
                this.printXMLAttribute("type", basetype.getTypeName(), flags);
                if (!attr.getBaseType().isEnumType()) break;
                this.printXMLAttribute("enum", basetype.getTypeName(), flags);
                break;
            }
        }
        if ((flags & 1) != 0) {
            this.printer.outdent(2);
        }
    }

    void printXMLAttribute(String name, String value, int flags) throws DapException {
        if (name == null) {
            return;
        }
        if ((flags & 4) == 0 && (value == null || value.length() == 0)) {
            return;
        }
        if ((flags & 1) != 0) {
            this.printer.eol();
            this.printer.margin();
        }
        this.printer.print(" " + name + "=");
        this.printer.print("\"");
        if (value != null) {
            value = Escape.entityEscape((String)value);
            this.printer.print(value);
        }
        this.printer.print("\"");
    }

    void printMetadata(DapNode node) throws DapException {
        Map attributes = node.getAttributes();
        if (attributes.size() == 0) {
            return;
        }
        for (Map.Entry entry : attributes.entrySet()) {
            DapAttribute attr = (DapAttribute)entry.getValue();
            String key = (String)entry.getKey();
            assert (attr != null);
            switch (attr.getSort()) {
                case ATTRIBUTE: {
                    this.printAttribute(attr);
                    break;
                }
                case ATTRIBUTESET: {
                    this.printContainerAttribute(attr);
                    break;
                }
                case OTHERXML: {
                    this.printOtherXML(attr);
                }
            }
        }
    }

    void printContainerAttribute(DapAttribute attr) {
    }

    void printOtherXML(DapAttribute attr) {
    }

    void printAttribute(DapAttribute attr) throws DapException {
        this.printer.marginPrint("<Attribute");
        this.printXMLAttributes((DapNode)attr, 0);
        List values = attr.getValues();
        this.printer.println(">");
        if (values == null) {
            throw new DapException("Attribute with no values:" + attr.getFQN());
        }
        this.printer.indent();
        if (values.size() == 1) {
            this.printer.marginPrintln(String.format("<Value value=\"%s\"/>", Dap4Print.getPrintValue(values.get(0))));
        } else {
            this.printer.marginPrintln("<Value>");
            this.printer.indent();
            for (Object value : values) {
                this.printer.marginPrint(Dap4Print.getPrintValue(value));
                this.printer.eol();
            }
            this.printer.outdent();
            this.printer.marginPrintln("</Value>");
        }
        this.printer.outdent();
        this.printer.marginPrintln("</Attribute>");
    }

    void printDimrefs(DapVariable var) throws DapException {
        if (var.getRank() == 0) {
            return;
        }
        List dimset = var.getDimensions();
        for (int i = 0; i < var.getRank(); ++i) {
            DapDimension dim = (DapDimension)dimset.get(i);
            this.printer.marginPrint("<Dim");
            if (dim.isShared()) {
                String fqn = dim.getFQN();
                assert (fqn != null) : "Illegal Dimension reference";
                this.printXMLAttribute("name", fqn, 0);
            } else {
                this.printXMLAttribute("size", Integer.toString((int)dim.getSize()), 0);
            }
            this.printer.println("/>");
        }
    }

    void printMaps(DapVariable parent) throws DapException {
        List maps = parent.getMaps();
        if (maps.size() == 0) {
            return;
        }
        for (DapMap map : maps) {
            this.printer.marginPrint("<Map");
            String name = map.getFQN();
            assert (name != null) : "Illegal <Map> reference";
            this.printXMLAttribute("name", name, 0);
            this.printXMLAttributes((DapNode)map, 2);
            if (Dap4Print.hasMetadata((DapNode)map)) {
                this.printer.println(">");
                this.printer.indent();
                this.printMetadata((DapNode)map);
                this.printer.outdent();
                this.printer.marginPrintln("</Map>");
                continue;
            }
            this.printer.println("/>");
        }
    }

    protected void printData() throws DataException {
        this.printer.setIndent(0);
        this.printer.marginPrintln("<data>");
        List topvars = this.dmr.getTopVariables();
        for (int i = 0; i < topvars.size(); ++i) {
            DapVariable top = (DapVariable)topvars.get(i);
            DataVariable dv = this.data.getVariableData(top);
            if (dv == null) {
                throw new DataException("Variable has no data:" + top);
            }
            this.printVariable(dv);
        }
        this.printer.setIndent(0);
        this.printer.marginPrintln("</data>");
    }

    protected void printVariable(DataVariable datav) throws DataException {
        DapVariable dapv = datav.getVariable();
        DapType daptype = dapv.getBaseType();
        if (datav.getSort() == DataSort.ATOMIC) {
            DapAtomicVariable datom = (DapAtomicVariable)dapv;
            DataAtomic atom = (DataAtomic)datav;
            long nelems = atom.getCount();
            long nrows = nelems > 0L ? (nelems + 7L) / nelems : 0L;
            this.printer.marginPrintf("<%s name=\"%s\">", new Object[]{dapv.getBaseType().getAtomicType().name(), dapv.getShortName()});
            this.printer.eol();
            this.printer.indent();
            int r = 0;
            while ((long)r < nrows) {
                for (int c = 0; c < 8; ++c) {
                    if (c > 0) {
                        this.printer.print(", ");
                    }
                    try {
                        Object value = atom.read(nrows * 8L + (long)c);
                        this.printer.print(this.valueString(value, daptype));
                        continue;
                    }
                    catch (IOException ioe) {
                        throw new DataException((Throwable)ioe);
                    }
                }
                this.printer.eol();
                ++r;
            }
            this.printer.outdent();
            this.printer.marginPrintf("</%s>", new Object[]{dapv.getBaseType().getAtomicType().name()});
        } else if (datav.getSort() == DataSort.COMPOUNDARRAY) {
            try {
                D4DataCompoundArray cmpd = (D4DataCompoundArray)datav;
                DapStructure dstruct = (DapStructure)dapv;
                List dfields = dstruct.getFields();
                long nelems = cmpd.getCount();
                Odometer odom = new Odometer(dstruct.getDimensions(), false);
                while (odom.hasNext()) {
                    String sindices = this.indicesToString(odom.getIndices());
                    this.printer.marginPrintf("<Structure name=\"%s\" indices=\"%s\">", new Object[]{dapv.getShortName(), sindices});
                    this.printer.eol();
                    this.printVariable(this.data.getVariableData((DapVariable)dstruct));
                    this.printer.marginPrintln("</Structure>");
                }
            }
            catch (IOException ioe) {
                throw new DataException((Throwable)ioe);
            }
        } else if (datav.getSort() == DataSort.STRUCTURE) {
            DapStructure dstruct = (DapStructure)dapv;
            List dfields = dstruct.getFields();
            if (dstruct.getRank() == 0) {
                this.printer.marginPrintf("<Structure name=\"%s\">", new Object[]{dapv.getShortName()});
            }
            this.printer.indent();
            DataStructure dv = (DataStructure)datav;
            for (int f = 0; f < dfields.size(); ++f) {
                DataVariable df = dv.readfield(f);
                this.printVariable(df);
            }
            this.printer.outdent();
            if (dstruct.getRank() == 0) {
                this.printer.marginPrintln("</Structure>");
            }
        } else if (datav.getSort() == DataSort.SEQUENCE) {
            DapSequence dseq = (DapSequence)dapv;
            DataSequence dvseq = (DataSequence)datav;
            this.printer.marginPrintf("<Sequence name=\"%s\">", new Object[]{dapv.getShortName()});
            this.printer.indent();
            long nrecs = dvseq.getRecordCount();
            int i = 0;
            while ((long)i < nrecs) {
                DataRecord dr = dvseq.readRecord((long)i);
                this.printVariable((DataVariable)dr);
                ++i;
            }
            this.printer.outdent();
            this.printer.marginPrintln("</Sequence>");
        } else if (datav.getSort() == DataSort.RECORD) {
            DapSequence dseq = (DapSequence)dapv;
            DataRecord dr = (DataRecord)datav;
            List dfields = dseq.getFields();
            this.printer.marginPrintf("<Record>", new Object[0]);
            this.printer.indent();
            for (int f = 0; f < dfields.size(); ++f) {
                DataVariable dv = dr.readfield(f);
                this.printVariable(dv);
            }
            this.printer.outdent();
            this.printer.marginPrintln("</Record>");
        } else {
            throw new DataException("Attempt to treat non-variable as variable:" + dapv.getFQN());
        }
    }

    protected String indicesToString(long[] indices) throws DapException {
        StringBuilder buf = new StringBuilder();
        if (indices != null && indices.length > 0) {
            for (int i = 0; i < indices.length; ++i) {
                buf.append(i == 0 ? Character.valueOf('[') : ",");
                buf.append(String.format("%d", indices[i]));
            }
            buf.append(']');
        }
        return buf.toString();
    }

    protected String valueString(Object value, DapType basetype) throws DataException {
        if (value == null) {
            return "null";
        }
        AtomicType atype = basetype.getAtomicType();
        boolean unsigned = atype.isUnsigned();
        switch (atype) {
            case Int8: 
            case UInt8: {
                long lvalue = ((Byte)value).longValue();
                if (unsigned) {
                    lvalue &= 0xFFL;
                }
                return String.format("%d", lvalue);
            }
            case Int16: 
            case UInt16: {
                long lvalue = ((Short)value).longValue();
                if (unsigned) {
                    lvalue &= 0xFFFFL;
                }
                return String.format("%d", lvalue);
            }
            case Int32: 
            case UInt32: {
                long lvalue = ((Integer)value).longValue();
                if (unsigned) {
                    lvalue &= 0xFFFFFFFFL;
                }
                return String.format("%d", lvalue);
            }
            case Int64: 
            case UInt64: {
                long lvalue = (Long)value;
                if (unsigned) {
                    BigInteger b = BigInteger.valueOf(lvalue);
                    b = b.and(DapUtil.BIG_UMASK64);
                    return b.toString();
                }
                return String.format("%d", lvalue);
            }
            case Float32: {
                return String.format("%f", (Float)value);
            }
            case Float64: {
                return String.format("%f", (Double)value);
            }
            case Char: {
                return "'" + ((Character)value).toString() + "'";
            }
            case String: 
            case URL: {
                return "\"" + (String)value + "\"";
            }
            case Opaque: {
                ByteBuffer opaque = (ByteBuffer)value;
                StringBuilder s = new StringBuilder();
                s.append("0x");
                for (int i = 0; i < opaque.limit(); ++i) {
                    byte b = opaque.get(i);
                    char c = Dap4Print.hexchar(b >> 4 & 0xF);
                    s.append(c);
                    c = Dap4Print.hexchar(b & 0xF);
                    s.append(c);
                }
                return s.toString();
            }
            case Enum: {
                return this.valueString(value, ((DapEnum)basetype).getBaseType());
            }
        }
        throw new DataException("Unknown type: " + basetype);
    }

    static char hexchar(int i) {
        return "0123456789ABCDEF".charAt(i & 0xF);
    }

    static void usage(String msg) {
        System.err.println(msg);
        System.err.println("usage: java -jar Dap4Print-o <output-file><url-with-constraint>");
        System.exit(1);
    }

    static CommandlineOptions getopts(String[] argv) {
        Options options = new Options();
        options.addOption("o", true, "send output to this file");
        PosixParser clparser = new PosixParser();
        CommandLine cmd = null;
        try {
            cmd = clparser.parse(options, argv);
        }
        catch (ParseException pe) {
            Dap4Print.usage("Command line parse failure: " + pe.getMessage());
        }
        CommandlineOptions cloptions = new CommandlineOptions();
        String[] remainder = cmd.getArgs();
        if (remainder.length > 0) {
            cloptions.path = remainder[0];
        }
        if (cmd.hasOption("o")) {
            cloptions.outputfile = cmd.getOptionValue("o");
        }
        return cloptions;
    }

    public static void main(String[] argv) {
        try {
            if (argv.length == 0) {
                Dap4Print.usage("");
            }
            CommandlineOptions options = Dap4Print.getopts(argv);
            PrintWriter output = null;
            if (options.outputfile != null) {
                File f = new File(options.outputfile);
                if (!f.canWrite()) {
                    Dap4Print.usage("Cannot write to output file: " + options.outputfile);
                }
                output = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(f), DapUtil.UTF8));
            } else {
                output = new PrintWriter(new OutputStreamWriter((OutputStream)System.out, DapUtil.UTF8));
            }
            Dap4Print d4printer = new Dap4Print(options.path, output);
            d4printer.print();
            output.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    protected static String getPrintValue(Object value) {
        if (value instanceof String) {
            return Escape.entityEscape((String)((String)value));
        }
        return value.toString();
    }

    protected static boolean hasMetadata(DapNode node) {
        return node.getAttributes().size() > 0;
    }

    protected static boolean hasMaps(DapVariable var) {
        return var.getMaps().size() > 0;
    }

    protected static boolean hasDimensions(DapVariable var) {
        return var.getDimensions().size() > 0;
    }

    static class CommandlineOptions {
        public String path = null;
        public String outputfile = null;

        CommandlineOptions() {
        }
    }
}

