/*
 * Decompiled with CFR 0.152.
 */
package dap4.core.dmr.parser;

import dap4.core.dmr.parser.SaxEvent;
import dap4.core.dmr.parser.SaxEventType;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.Charset;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public abstract class SaxEventHandler
extends DefaultHandler {
    static boolean TRACE = false;
    static Charset UTF8 = Charset.forName("UTF-8");
    static final String LOAD_EXTERNAL_DTD = "http://apache.org/xml/features/nonvalidating/load-external-dtd";
    String document = null;
    Locator locator = null;
    SAXParserFactory spf = null;
    SAXParser saxparser = null;
    ByteArrayInputStream input = null;

    public abstract void yyevent(SaxEvent var1) throws SAXException;

    public boolean parse(String document) throws SAXException {
        this.document = document;
        try {
            this.spf = SAXParserFactory.newInstance();
            this.spf.setValidating(false);
            this.spf.setNamespaceAware(true);
            this.spf.setFeature(LOAD_EXTERNAL_DTD, false);
            this.saxparser = this.spf.newSAXParser();
            this.input = new ByteArrayInputStream(document.getBytes(UTF8));
            this.saxparser.parse((InputStream)this.input, (DefaultHandler)this);
            return true;
        }
        catch (Exception e) {
            throw new SAXException(e);
        }
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    @Override
    public void startDocument() throws SAXException {
        SaxEvent token = new SaxEvent(SaxEventType.STARTDOCUMENT, this.locator);
        if (TRACE) {
            System.err.printf("eventtype.%s: %s\n", token.eventtype.name(), token.toString());
        }
        this.yyevent(token);
    }

    @Override
    public void endDocument() throws SAXException {
        SaxEvent token = new SaxEvent(SaxEventType.ENDDOCUMENT, this.locator);
        if (TRACE) {
            System.err.printf("eventtype.%s: %s\n", token.eventtype.name(), token.toString());
        }
        this.yyevent(token);
    }

    @Override
    public void startElement(String nsuri, String name, String qualname, Attributes attributes) throws SAXException {
        SaxEvent token = new SaxEvent(SaxEventType.STARTELEMENT, this.locator, name, qualname, nsuri);
        if (TRACE) {
            System.err.printf("eventtype.%s: %s\n", token.eventtype.name(), token.toString());
        }
        this.yyevent(token);
        int nattr = attributes.getLength();
        for (int i = 0; i < nattr; ++i) {
            String aname = attributes.getLocalName(i);
            if ("".equals(aname)) {
                aname = attributes.getQName(i);
            }
            String value = attributes.getValue(i);
            token = new SaxEvent(SaxEventType.ATTRIBUTE, this.locator, aname);
            token.value = value;
            if (TRACE) {
                System.err.printf("eventtype.%s: %s\n", token.eventtype.name(), token.toString());
            }
            this.yyevent(token);
        }
    }

    @Override
    public void endElement(String nsuri, String name, String qualname) throws SAXException {
        SaxEvent token = new SaxEvent(SaxEventType.ENDELEMENT, this.locator, name, qualname, nsuri);
        if (TRACE) {
            System.err.printf("eventtype.%s: %s\n", token.eventtype.name(), token.toString());
        }
        this.yyevent(token);
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        SaxEvent token = new SaxEvent(SaxEventType.CHARACTERS, this.locator);
        token.text = new String(ch, start, length);
        if (TRACE) {
            System.err.printf("eventtype.%s: %s\n", token.eventtype.name(), token.toString());
        }
        this.yyevent(token);
    }

    @Override
    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
    }

    @Override
    public void endPrefixMapping(String prefix) throws SAXException {
    }

    @Override
    public void notationDecl(String name, String publicId, String systemId) throws SAXException {
    }

    @Override
    public void processingInstruction(String target, String data) throws SAXException {
    }

    @Override
    public void skippedEntity(String name) throws SAXException {
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) throws SAXException {
    }

    @Override
    public void unparsedEntityDecl(String name, String publicId, String systemId, String notationName) throws SAXException {
    }

    @Override
    public InputSource resolveEntity(String publicId, String systemId) {
        if (TRACE) {
            System.err.printf("eventtype.RESOLVEENTITY: %s.%s\n", publicId, systemId);
        }
        return null;
    }

    @Override
    public void fatalError(SAXParseException e) throws SAXException {
        throw e;
    }

    @Override
    public void error(SAXParseException e) throws SAXException {
        System.err.println("Sax error: %s\n" + e);
    }

    @Override
    public void warning(SAXParseException e) throws SAXException {
        System.err.println("Sax warning: " + e);
    }
}

