/*
 * Decompiled with CFR 0.152.
 */
package dap4.core.util;

import dap4.core.util.DapUtil;
import java.io.FileInputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;

public abstract class DapDump {
    static int MAXLIMIT = 20000;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void dumpbytes(ByteBuffer buf0, boolean skipdmr) {
        int savepos = buf0.position();
        int limit0 = buf0.limit();
        int skipcount = 0;
        if (limit0 > MAXLIMIT) {
            limit0 = MAXLIMIT;
        }
        if (skipdmr) {
            skipcount = buf0.getInt();
            skipcount &= 0xFFFFFF;
            skipcount += 4;
        }
        byte[] bytes = new byte[limit0 + 8 - skipcount];
        Arrays.fill(bytes, (byte)0);
        buf0.position(savepos + skipcount);
        buf0.get(bytes, 0, limit0 - skipcount);
        buf0.position(savepos);
        ByteBuffer buf = ByteBuffer.wrap(bytes).order(buf0.order());
        int i = 0;
        int stop = bytes.length - 8;
        try {
            i = 0;
            while (buf.position() < stop) {
                savepos = buf.position();
                int iv = buf.getInt();
                buf.position(savepos);
                byte b = buf.get();
                long uv = (long)iv & 0xFFFFFFFFL;
                byte ib = b;
                int ub = iv & 0xFF;
                char c = (char)ub;
                String s = Character.toString(c);
                if (c == '\r') {
                    s = "\\r";
                } else if (c == '\n') {
                    s = "\\n";
                } else if (c < ' ') {
                    s = "?";
                }
                System.out.printf("[%03d] %02x %4d '%s'\t%12d 0x%08x\n", i, ub, (int)ib, s, iv, uv);
                ++i;
            }
        }
        catch (Exception e) {
            System.out.println("failure:" + e);
        }
        finally {
            System.out.flush();
        }
    }

    public static void main(String[] argv) {
        try {
            FileInputStream f = new FileInputStream(argv[0]);
            byte[] content = DapUtil.readbinaryfile(f);
            ByteBuffer buf = ByteBuffer.wrap(content).order(ByteOrder.LITTLE_ENDIAN);
            DapDump.dumpbytes(buf, false);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

