/*
 * Decompiled with CFR 0.152.
 */
package dap4.core.util;

import dap4.core.dmr.DapDimension;
import dap4.core.dmr.DapGroup;
import dap4.core.dmr.DapNode;
import dap4.core.dmr.DapStructure;
import dap4.core.dmr.DapType;
import dap4.core.dmr.DapVariable;
import dap4.core.util.DapException;
import dap4.core.util.Slice;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.Charset;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;

public abstract class DapUtil {
    public static final BigInteger BIG_UMASK64 = new BigInteger("FFFFFFFFFFFFFFFF", 16);
    public static final Charset UTF8 = Charset.forName("UTF-8");
    public static final ByteOrder NETWORK_ORDER = ByteOrder.BIG_ENDIAN;
    public static final ByteOrder NATIVE_ORDER = ByteOrder.nativeOrder();
    public static final int CHUNK_DATA = 0;
    public static final int CHUNK_END = 1;
    public static final int CHUNK_ERROR = 2;
    public static final int CHUNK_LITTLE_ENDIAN = 4;
    public static final int CHUNK_ALL = 7;
    public static final String LF = "\n";
    public static final String CRLF = "\r\n";
    public static final int CRLFSIZE = 2;
    public static final int CHECKSUMSIZE = 4;
    public static final String DIGESTER = "CRC32";
    static final String protocol_re = "[a-zA-Z0-9_-]+";

    public static String fqnSuffix(String fqn) {
        int structindex = fqn.lastIndexOf(46);
        int groupindex = fqn.lastIndexOf(47);
        if (structindex >= 0) {
            return fqn.substring(structindex + 1, fqn.length());
        }
        return fqn.substring(groupindex + 1, fqn.length());
    }

    public static String fqnPrefix(String fqn) {
        int structindex = fqn.lastIndexOf(46);
        int groupindex = fqn.lastIndexOf(47);
        if (structindex >= 0) {
            return fqn.substring(0, structindex);
        }
        return fqn.substring(0, groupindex);
    }

    public static List<String> backslashSplit(String s, char sep) {
        ArrayList<String> path = new ArrayList<String>();
        int len = s.length();
        StringBuilder piece = new StringBuilder();
        for (int i = 0; i <= len - 1; ++i) {
            char c = s.charAt(i);
            if (c == '\\' && i < len - 1) {
                piece.append(c);
                piece.append(s.charAt(++i));
                continue;
            }
            if (c == sep) {
                path.add(piece.toString());
                piece.setLength(0);
                continue;
            }
            piece.append(c);
        }
        path.add(piece.toString());
        return path;
    }

    public static boolean hasSequence(DapNode node) {
        switch (node.getSort()) {
            case SEQUENCE: {
                return true;
            }
            case STRUCTURE: {
                DapStructure container = (DapStructure)node;
                for (int i = 0; i < container.getFields().size(); ++i) {
                    if (!DapUtil.hasSequence(container.getFields().get(i))) continue;
                    return true;
                }
                break;
            }
            case GROUP: {
                DapGroup group = (DapGroup)node;
                for (int i = 0; i < group.getDecls().size(); ++i) {
                    if (!DapUtil.hasSequence(group.getDecls().get(i))) continue;
                    return true;
                }
                break;
            }
        }
        return false;
    }

    public static String locateFile(String filename, String abspath, boolean wantdir) {
        String currentpath;
        ArrayDeque<String> q = new ArrayDeque<String>();
        filename = filename.trim().replace('\\', '/');
        abspath = abspath.trim().replace('\\', '/');
        if (filename.charAt(0) == '/') {
            filename = filename.substring(1);
        }
        if (filename.endsWith("/")) {
            filename = filename.substring(0, filename.length() - 1);
        }
        if (abspath.endsWith("/")) {
            abspath = abspath.substring(0, abspath.length() - 1);
        }
        q.addFirst(abspath);
        while ((currentpath = (String)q.poll()) != null) {
            File current = new File(currentpath);
            File[] contents = current.listFiles();
            if (contents == null) continue;
            for (File subfile : contents) {
                if (!subfile.getName().equals(filename) || (!wantdir || !subfile.isDirectory()) && (wantdir || !subfile.isFile())) continue;
                return DapUtil.canonicalpath(subfile.getAbsolutePath(), false);
            }
            for (File subfile : contents) {
                if (!subfile.isDirectory()) continue;
                q.addFirst(currentpath + "/" + subfile.getName());
            }
        }
        return null;
    }

    public static String locateRelative(String relpath, String abspath, boolean wantdir) {
        if ((relpath = relpath.trim().replace('\\', '/')).charAt(0) == '/') {
            relpath = relpath.substring(1);
        }
        if (relpath.endsWith("/")) {
            relpath = relpath.substring(0, relpath.length() - 1);
        }
        String[] pieces = relpath.split("[/]");
        String partial = abspath;
        for (int i = 0; i < pieces.length - 1; ++i) {
            String nextdir = DapUtil.locateFile(pieces[i], abspath, true);
            if (nextdir == null) {
                return null;
            }
            partial = nextdir;
        }
        String finalpath = DapUtil.locateFile(pieces[pieces.length - 1], partial, wantdir);
        return finalpath;
    }

    public static String canonicalpath(String path, boolean relative) {
        if (path == null) {
            return null;
        }
        path = path.trim();
        if ((path = path.replace('\\', '/')).endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        if (relative && path.startsWith("/")) {
            path = path.substring(1);
        }
        return path;
    }

    public static boolean checkFixedSize(DapVariable var) {
        switch (var.getSort()) {
            case ATOMICVARIABLE: {
                DapType dt = var.getBaseType();
                return dt.isFixedSize();
            }
            case SEQUENCE: 
            case STRUCTURE: 
            case GRID: {
                for (DapVariable field : ((DapStructure)var).getFields()) {
                    if (DapUtil.checkFixedSize(field)) continue;
                    return false;
                }
                break;
            }
        }
        return true;
    }

    public static byte[] extract(ByteBuffer buf) {
        int len = buf.limit();
        byte[] bytes = new byte[len];
        buf.rewind();
        buf.get(bytes);
        return bytes;
    }

    public static byte[] readbinaryfile(InputStream stream) throws IOException {
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        byte[] tmp = new byte[65536];
        while (true) {
            int cnt;
            try {
                cnt = stream.read(tmp);
                if (cnt <= 0) {
                    break;
                }
            }
            catch (IOException ioe) {
                throw new DapException(ioe);
            }
            bytes.write(tmp, 0, cnt);
        }
        return bytes.toByteArray();
    }

    public static String readtextfile(InputStream stream) throws IOException {
        int c;
        StringBuilder buf = new StringBuilder();
        InputStreamReader rdr = new InputStreamReader(stream, UTF8);
        while ((c = rdr.read()) >= 0) {
            buf.append((char)c);
        }
        return buf.toString();
    }

    public static List<DapVariable> getStructurePath(DapVariable var) {
        List<DapNode> path = var.getPath();
        ArrayList<DapVariable> structpath = new ArrayList<DapVariable>();
        block4: for (int i = 0; i < path.size(); ++i) {
            DapNode node = path.get(i);
            switch (node.getSort()) {
                case GROUP: 
                case DATASET: {
                    continue block4;
                }
                case STRUCTURE: 
                case ATOMICVARIABLE: {
                    structpath.add((DapVariable)node);
                    continue block4;
                }
                default: {
                    assert (false) : "Internal error";
                    continue block4;
                }
            }
        }
        return structpath;
    }

    public static String nullify(String path) {
        return path != null && path.length() == 0 ? null : path;
    }

    public static String[] getProtocols(String url) {
        String[] pieces = url.split("[:]");
        if (pieces.length > 1) {
            for (int i = 0; i < pieces.length; ++i) {
                if (pieces[i].matches(protocol_re)) continue;
                String[] protos = new String[i];
                for (int j = 0; j < i; ++j) {
                    protos[j] = pieces[j];
                }
                return protos;
            }
        }
        return new String[0];
    }

    public static long dimProduct(List<DapDimension> dimset) {
        long count = 1L;
        for (DapDimension dim : dimset) {
            count *= dim.getSize();
        }
        return count;
    }

    public static List<Slice> dimsetSlices(List<DapDimension> dimset) throws DapException {
        ArrayList<Slice> slices = new ArrayList<Slice>(dimset.size());
        for (int i = 0; i < dimset.size(); ++i) {
            DapDimension dim = dimset.get(i);
            Slice s = new Slice().fill(dim);
            slices.add(s);
        }
        return slices;
    }

    public static boolean isWhole(List<Slice> slices, List<DapDimension> dimset) {
        if (slices.size() != dimset.size()) {
            return false;
        }
        for (int i = 0; i < slices.size(); ++i) {
            Slice slice = slices.get(i);
            DapDimension dim = dimset.get(i);
            if (slice.getStride() == 1L && slice.getFirst() == 0L && slice.getCount() == dim.getSize()) continue;
            return false;
        }
        return true;
    }

    public static long sliceProduct(List<Slice> slices) {
        long count = 1L;
        for (Slice slice : slices) {
            count *= slice.getCount();
        }
        return count;
    }

    public static boolean hasStrideOne(List<Slice> slices) {
        for (Slice slice : slices) {
            if (slice.getStride() == 1L) continue;
            return false;
        }
        return true;
    }
}

