/*
 * Decompiled with CFR 0.152.
 */
package dap4.core.util;

import dap4.core.dmr.DapDimension;
import dap4.core.util.DapException;
import dap4.core.util.DapUtil;
import dap4.core.util.Slice;
import java.util.Iterator;
import java.util.List;

public class Odometer
implements Iterator<Boolean> {
    protected int rank = 0;
    protected long[] first = null;
    protected long[] stop = null;
    protected long[] stride = null;
    protected long[] count = null;
    protected long[] declsize = null;
    protected DapDimension[] dimset = null;
    protected long[] index = null;

    public static ScalarOdometer getScalarOdometer() {
        return new ScalarOdometer();
    }

    public Odometer() {
    }

    public Odometer(List<DapDimension> dimset) throws DapException {
        this(DapUtil.dimsetSlices(dimset), dimset);
    }

    public Odometer(List<Slice> set, List<DapDimension> dimset) throws DapException {
        if (set == null) {
            throw new DapException("Null slice list");
        }
        this.setup(set.size());
        if (this.rank == 0) {
            return;
        }
        for (int i = 0; i < this.rank; ++i) {
            Slice slice = set.get(i);
            this.fill(i, slice.getFirst(), slice.getLast() + 1L, slice.getStride());
        }
        this.setDeclsizes(dimset);
    }

    protected void setDeclsizes(List<DapDimension> dimset) throws DapException {
        int rank = dimset.size();
        if (rank != this.rank) {
            throw new DapException("Odometer: |dimset| != rank");
        }
        for (int i = 0; i < dimset.size(); ++i) {
            DapDimension dim = dimset.get(i);
            long size = dim.getSize();
            if (size <= this.first[i] || size < this.stop[i]) {
                throw new DapException("Odometer: Dimset invalidates odometer");
            }
            this.declsize[i] = size;
            this.dimset[i] = dim;
        }
    }

    protected void fill(int i, long first, long stop, long stride) {
        this.stop[i] = stop;
        this.first[i] = first;
        this.stride[i] = stride;
        this.count[i] = (stop - first + (stride - 1L)) / stride;
        this.index[i] = first;
        this.declsize[i] = this.stop[i];
    }

    protected void setup(int rank) {
        this.rank = rank;
        this.first = new long[this.rank];
        this.stop = new long[this.rank];
        this.stride = new long[this.rank];
        this.count = new long[this.rank];
        this.declsize = new long[this.rank];
        this.index = new long[this.rank];
        this.dimset = new DapDimension[this.rank];
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < this.rank; ++i) {
            if (i > 0) {
                buf.append(",");
            }
            buf.append(this.dimset[i] != null ? this.dimset[i].getShortName() : "null");
            buf.append("[");
            if (this.stride[i] == 1L) {
                buf.append(String.format("%d:%d", this.first[i], this.stop[i] - 1L));
            } else {
                buf.append(String.format("%d:%d:%d", this.first[i], this.stride[i], this.stop[i] - 1L));
            }
            buf.append(String.format("|%d", this.index[i]));
            if (this.declsize[i] > 0L) {
                buf.append(String.format("/%d", this.declsize[i]));
            }
            buf.append("]");
        }
        return buf.toString();
    }

    public long index() {
        long offset = 0L;
        for (int i = 0; i < this.rank; ++i) {
            offset *= this.declsize[i];
            offset += this.index[i];
        }
        return offset;
    }

    public long totalSize() {
        long size = 1L;
        for (int i = 0; i < this.rank; ++i) {
            size *= this.count[i];
        }
        return size;
    }

    public long[] getIndices() {
        return this.index;
    }

    @Override
    public boolean hasNext() {
        return this.index[0] < this.stop[0];
    }

    @Override
    public Boolean next() {
        Boolean more = Boolean.FALSE;
        for (int i = this.rank - 1; i >= 0; --i) {
            int n = i;
            this.index[n] = this.index[n] + this.stride[i];
            if (this.index[i] < this.stop[i]) {
                more = Boolean.TRUE;
                break;
            }
            if (i <= 0) continue;
            this.index[i] = this.first[i];
        }
        return more;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    public static class ScalarOdometer
    extends Odometer {
        protected boolean first = true;

        @Override
        public long index() {
            return 0L;
        }

        @Override
        public long totalSize() {
            return 1L;
        }

        @Override
        public boolean hasNext() {
            boolean first = this.first;
            this.first = false;
            return first;
        }
    }
}

