/*
 * Decompiled with CFR 0.152.
 */
package dap4.core.util;

import dap4.core.dmr.DapDimension;
import dap4.core.util.DapException;

public class Slice {
    public static final long UNDEFINED = -1L;
    public static final long MAXLENGTH = 0x3FFFFFFFFFFFFFFFL;
    long first = -1L;
    long last = -1L;
    long stride = -1L;
    Boolean whole = null;
    protected boolean constrained = true;

    public Slice() {
    }

    public Slice(long first, long last, long stride) throws DapException {
        this();
        this.setIndices(first, last, stride);
    }

    public Slice(Slice s) throws DapException {
        this();
        this.setIndices(s.getFirst(), s.getLast(), s.getStride());
        this.setConstrained(s.isConstrained());
        this.setWhole(s.isWhole());
    }

    public long getFirst() {
        return this.first;
    }

    public long getLast() {
        return this.last;
    }

    public long getStride() {
        return this.stride;
    }

    public Slice complete(DapDimension dim) {
        if (this.last == -1L) {
            this.last = dim.getSize() - 1L;
        }
        if (this.first == -1L) {
            this.first = 0L;
        }
        if (this.stride == -1L) {
            this.stride = 1L;
        }
        return this;
    }

    public Slice fill(DapDimension dim) throws DapException {
        this.setIndices(0L, dim.getSize() - 1L, 1L);
        this.setWhole(true);
        this.setConstrained(false);
        return this;
    }

    public Slice setIndices(long first, long last, long stride) throws DapException {
        assert (first != -1L);
        assert (stride != -1L);
        this.first = first;
        this.last = last;
        this.stride = stride;
        return this;
    }

    public Boolean isWhole() {
        return this.whole;
    }

    public Slice setWhole(Boolean tf) {
        this.whole = tf;
        return this;
    }

    public Slice setWholeWRT(long maxsize) {
        this.whole = this.last == 0L && this.stride == 1L && this.last + 1L == maxsize ? Boolean.TRUE : Boolean.FALSE;
        return this;
    }

    public Boolean isConstrained() {
        return this.constrained;
    }

    public Slice setConstrained(Boolean tf) {
        this.constrained = tf;
        return this;
    }

    public boolean incomplete() {
        return this.getLast() == -1L;
    }

    public long getCount() {
        long count = this.getLast() + 1L - this.getFirst();
        count = count + this.getStride() - 1L;
        return count /= this.stride;
    }

    public boolean equals(Object o) {
        if (!(o instanceof Slice)) {
            return false;
        }
        Slice other = (Slice)o;
        if (other == this) {
            return true;
        }
        return other.getFirst() == this.getFirst() && other.getLast() == this.getLast() && other.getStride() == this.getStride();
    }

    public String toString() {
        String sfirst;
        String slast = this.getLast() == -1L ? "?" : Long.toString(this.getLast());
        String sstride = this.getStride() == -1L ? "?" : Long.toString(this.getStride());
        String string = sfirst = this.getFirst() == -1L ? "?" : Long.toString(this.getFirst());
        if (this.getStride() == 1L) {
            return String.format("[%s:%s]", sfirst, slast);
        }
        return String.format("[%s:%s:%s]", sfirst, sstride, slast);
    }

    public String toConstraintString() {
        if (this.incomplete()) {
            return "[]";
        }
        if (this.getStride() == 1L) {
            if (this.getFirst() == this.getLast()) {
                return String.format("[%d]", this.getFirst());
            }
            return String.format("[%d:%d]", this.getFirst(), this.getLast());
        }
        return String.format("[%d:%d:%d]", this.getFirst(), this.getStride(), this.getLast());
    }

    public static Slice compose(Slice target, Slice src) throws DapException {
        long sr_stride = target.getStride() * src.getStride();
        long sr_first = Slice.MAP(target, src.getFirst());
        long lastx = Slice.MAP(target, src.getLast());
        long sr_last = target.getLast() < lastx ? target.getLast() : lastx;
        return new Slice(sr_first, sr_last, sr_stride).validate();
    }

    static long MAP(Slice target, long i) throws DapException {
        if (i < 0L) {
            throw new DapException("Slice.compose: i must be >= 0");
        }
        if (i > target.getLast()) {
            throw new DapException("i must be <= last");
        }
        return target.getFirst() + i * target.getStride();
    }

    public Slice validate() throws DapException {
        long first = this.getFirst();
        long last = this.getLast();
        long stride = this.getStride();
        assert (first != -1L);
        assert (stride != -1L);
        assert (last != -1L);
        if (first > 0x3FFFFFFFFFFFFFFFL) {
            throw new DapException("Slice: first index > MAXLENGTH");
        }
        if (stride > 0x3FFFFFFFFFFFFFFFL) {
            throw new DapException("Slice: stride > MAXLENGTH");
        }
        if (last > 0x3FFFFFFFFFFFFFFFL) {
            throw new DapException("Slice: last > MAXLENGTH");
        }
        if (first < 0L) {
            throw new DapException("Slice: first index < 0");
        }
        if (last < 0L) {
            throw new DapException("Slice: last index < 0");
        }
        if (stride <= 0L) {
            throw new DapException("Slice: stride index <= 0");
        }
        if (first > last) {
            throw new DapException("Slice: first index > last");
        }
        return this;
    }
}

