/*
 * Decompiled with CFR 0.152.
 */
package dap4.core.dmr;

import dap4.core.dmr.AtomicType;
import dap4.core.dmr.DapDecl;
import dap4.core.dmr.DapDimension;
import dap4.core.dmr.DapEnum;
import dap4.core.dmr.DapMap;
import dap4.core.dmr.DapNode;
import dap4.core.dmr.DapType;
import dap4.core.util.DapException;
import dap4.core.util.DapUtil;
import java.util.ArrayList;
import java.util.List;

public abstract class DapVariable
extends DapNode
implements DapDecl {
    protected DapType basetype = null;
    protected List<DapDimension> dimensions = new ArrayList<DapDimension>();
    protected List<DapMap> maps = new ArrayList<DapMap>();
    protected byte[] checksum = null;

    public DapVariable() {
    }

    public DapVariable(String name) {
        super(name);
    }

    public DapType getBaseType() {
        return this.basetype;
    }

    public void setBaseType(DapType basetype) {
        this.basetype = basetype;
    }

    public DapType getTrueBaseType() {
        DapType bt = this.getBaseType();
        if (bt.getAtomicType() == AtomicType.Enum) {
            return ((DapEnum)bt).getBaseType();
        }
        return bt;
    }

    public int getRank() {
        return this.dimensions.size();
    }

    public long getCount() {
        return DapUtil.dimProduct(this.getDimensions());
    }

    public List<DapDimension> getDimensions() {
        return this.dimensions;
    }

    public DapDimension getDimension(int i) {
        if (this.dimensions == null || i < 0 || i >= this.dimensions.size()) {
            return null;
        }
        return this.dimensions.get(i);
    }

    public void addDimension(DapDimension node) throws DapException {
        for (DapDimension d : this.dimensions) {
            if (!d.isVariableLength()) continue;
            throw new DapException("Variable length dimension must always be last");
        }
        this.dimensions.add(node);
    }

    public List<DapMap> getMaps() {
        return this.maps;
    }

    public void addMap(DapMap map) throws DapException {
        if (this.maps.contains(map)) {
            throw new DapException("Duplicate map variables: " + map.getFQN());
        }
        this.maps.add(map);
    }

    public byte[] getChecksum() {
        return this.checksum;
    }

    public void setChecksum(byte[] csum) {
        this.checksum = csum;
    }

    @Override
    public String toString() {
        String s = super.toString();
        for (int i = 0; i < this.getRank(); ++i) {
            DapDimension dim = this.dimensions.get(i);
            s = dim == null ? s + "(null)" : s + String.format("(%d)", dim.getSize());
        }
        return s;
    }

    public abstract boolean isLeaf();
}

