/*
 * Decompiled with CFR 0.152.
 */
package dap4.core.dmr.parser;

import dap4.core.dmr.parser.Dap4Actions;
import dap4.core.dmr.parser.SaxEvent;
import dap4.core.dmr.parser.SaxEventType;
import dap4.core.util.Escape;

public abstract class Debug {
    static void addtext(StringBuilder dst, String txt, int flags) {
        boolean shortened = false;
        if (txt == null) {
            dst.append("null");
            return;
        }
        if ((flags & 8) != 0) {
            txt = txt.trim();
        }
        int len = txt.length();
        if ((flags & 4) != 0 && len > 12) {
            len = 12;
            shortened = true;
        }
        dst.append('|');
        for (int i = 0; i < txt.length(); ++i) {
            char c = txt.charAt(i);
            if (len-- <= 0) continue;
            if ((flags & 1) != 0 && c < ' ') {
                dst.append('\\');
                switch (c) {
                    case '\n': {
                        dst.append('n');
                        break;
                    }
                    case '\r': {
                        dst.append('r');
                        break;
                    }
                    case '\f': {
                        dst.append('f');
                        break;
                    }
                    case '\t': {
                        dst.append('t');
                        break;
                    }
                    default: {
                        char uc = c;
                        int oct = uc >> 6 & 0x3F;
                        dst.append((char)(48 + oct));
                        oct = uc >> 3 & 0x3F;
                        dst.append((char)(48 + oct));
                        oct = uc & 0x3F;
                        dst.append((char)(48 + oct));
                        break;
                    }
                }
                continue;
            }
            if ((flags & 2) != 0 && c == '\r') continue;
            dst.append(c);
        }
        if (shortened) {
            dst.append("...");
        }
        dst.append('|');
    }

    public static String trace(SaxEvent token) {
        return Debug.trace(token, 15);
    }

    public static String trace(SaxEvent token, int flags) {
        StringBuilder result = new StringBuilder();
        String name = "UNDEFINED";
        String value = "";
        String text = "";
        SaxEventType event = null;
        name = token.name;
        value = token.value;
        text = token.text;
        event = token.eventtype;
        result.append("[" + event.name() + "] ");
        switch (event) {
            case STARTELEMENT: 
            case ENDELEMENT: {
                result.append(": element=|");
                result.append(name);
                result.append("|");
                break;
            }
            case CHARACTERS: {
                result.append(" text=");
                Debug.addtext(result, text, flags);
                String trans = Escape.entityUnescape(text);
                result.append(" translation=");
                Debug.addtext(result, trans, flags);
                break;
            }
            case ATTRIBUTE: {
                result.append(": name=");
                Debug.addtext(result, name, flags);
                result.append(" value=");
                Debug.addtext(result, value, flags);
                break;
            }
            case STARTDOCUMENT: {
                break;
            }
            case ENDDOCUMENT: {
                break;
            }
            default: {
                assert (false) : "Unexpected tokentype";
                break;
            }
        }
        result.append(" eventtype=" + event.name());
        return result.toString();
    }

    static String traceList(Dap4Actions.XMLAttributeMap map) {
        String result = "";
        for (String key : map.keySet()) {
            SaxEvent event = (SaxEvent)map.get(key);
            String trace = Debug.trace(event);
            if (result.length() != 0) {
                result = result + "\n";
            }
            result = result + key + ": " + trace;
        }
        return result;
    }
}

