/*
 * Decompiled with CFR 0.152.
 */
package dap4.core.util;

import dap4.core.dmr.DapDimension;
import dap4.core.util.DapException;
import dap4.core.util.MultiSlice;
import dap4.core.util.Odometer;
import dap4.core.util.PowerSet;
import dap4.core.util.Slice;
import java.util.List;
import java.util.NoSuchElementException;

public class MultiOdometer
extends Odometer {
    protected static boolean DEBUG = false;
    protected Slice[] cache;
    protected int current;
    protected long[][] setindices;
    protected long[] sizes;

    public MultiOdometer() {
    }

    public MultiOdometer(List<Slice> set, List<DapDimension> dimset, boolean usecontiguous) throws DapException {
        super(set, dimset, usecontiguous);
        this.cache = set.toArray(new Slice[set.size()]);
        this.sizes = new long[this.rank];
        block4: for (int i = 0; i < this.rank; ++i) {
            Slice sl = set.get(i);
            switch (sl.getSort()) {
                case Single: {
                    this.sizes[i] = 1L;
                    continue block4;
                }
                case Multi: {
                    this.sizes[i] = ((MultiSlice)sl).getSlices().size();
                }
            }
        }
        int truerank = this.rank - this.contiguousdelta;
        if (truerank == 0) {
            this.setindices = null;
        } else {
            PowerSet ps = new PowerSet(this.sizes);
            this.setindices = ps.getPowerSet();
            if (DEBUG) {
                System.err.printf("Multi: |slicesets| = %d\n", this.setindices.length);
                System.err.println(ps.toString());
            }
        }
        this.current = 0;
        this.moveToNextSet();
    }

    @Override
    public String toString() {
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < this.rank; ++i) {
            Slice s = this.cache[i];
            if (i == this.current) {
                buf.append("*");
            }
            buf.append(s.toString());
            buf.append(String.format("(%d)", s.getCount()));
        }
        return buf.toString();
    }

    @Override
    public boolean hasNext() {
        if (super.hasNext()) {
            return true;
        }
        return this.setindices != null && this.current + 1 < this.setindices.length;
    }

    @Override
    public Long next() {
        if (super.hasNext()) {
            return super.next();
        }
        ++this.current;
        if (this.setindices == null || this.current >= this.setindices.length) {
            throw new NoSuchElementException();
        }
        this.moveToNextSet();
        this.state = Odometer.STATE.INITIAL;
        return super.next();
    }

    protected void moveToNextSet() {
        if (this.setindices == null) {
            return;
        }
        long[] indices = this.setindices[this.current];
        this.slices = new Slice[this.rank];
        for (int i = 0; i < this.rank; ++i) {
            Slice s;
            Slice sl = this.cache[i];
            if (sl.getSort() != Slice.Sort.Multi) continue;
            int ii = (int)indices[i];
            MultiSlice msl = (MultiSlice)sl;
            this.slices[i] = s = msl.getSlices().get(ii);
        }
        if (DEBUG) {
            System.err.println("Multislice: " + this.toString());
        }
        super.reset();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public long totalSize() {
        long size = 1L;
        for (int i = 0; i < this.rank; ++i) {
            size *= this.cache[i].getCount();
        }
        return size;
    }

    @Override
    public boolean isContiguous() {
        return this.cache[this.cache.length - 1].isContiguous();
    }

    @Override
    public List<Slice> getContiguous() {
        return this.cache[this.cache.length - 1].getContiguous();
    }
}

