/*
 * Decompiled with CFR 0.152.
 */
package dap4.core.util;

import dap4.core.dmr.DapDimension;
import dap4.core.util.DapException;
import dap4.core.util.SliceIterator;
import java.util.ArrayList;
import java.util.List;

public class Slice {
    public static final long UNDEFINED = -1L;
    public static final long MAXLENGTH = 0x3FFFFFFFFFFFFFFFL;
    protected Sort sort = Sort.Single;
    long first = -1L;
    long last = -1L;
    long stride = -1L;
    long size = 0x3FFFFFFFFFFFFFFFL;
    Boolean whole = null;
    protected boolean constrained = true;

    public Slice() {
    }

    public Slice(long first, long last, long stride) throws DapException {
        this(first, last, stride, last == -1L ? -1L : last + 1L);
    }

    public Slice(long first, long last, long stride, long maxsize) throws DapException {
        this();
        this.setIndices(first, last, stride, maxsize);
    }

    public Slice(Slice s) throws DapException {
        this();
        this.setIndices(s.getFirst(), s.getLast(), s.getStride(), s.getMaxSize());
        this.setConstrained(s.isConstrained());
        this.setWhole(s.isWhole());
    }

    public Slice(DapDimension dim) throws DapException {
        this();
        this.setIndices(0L, dim.getSize() - 1L, 1L, dim.getSize());
        this.setWhole(true);
        this.setConstrained(false);
    }

    public Slice finish() throws DapException {
        if (this.first == -1L) {
            this.first = 0L;
        }
        if (this.stride == -1L) {
            this.stride = 1L;
        }
        if (this.last == -1L && this.size != -1L) {
            this.last = this.size - 1L;
        }
        if (this.size == -1L && this.last != -1L) {
            this.size = this.last + 1L;
        } else if (this.last == -1L && this.size == -1L) {
            throw new DapException("Slice: both last and size are UNDEFINED");
        }
        assert (this.first != -1L);
        assert (this.stride != -1L);
        assert (this.last != -1L);
        if (this.first > this.size) {
            throw new DapException("Slice: first index > max size");
        }
        if (this.stride > this.size) {
            throw new DapException("Slice: stride > max size");
        }
        if (this.last > this.size) {
            throw new DapException("Slice: last > max size");
        }
        if (this.first < 0L) {
            throw new DapException("Slice: first index < 0");
        }
        if (this.last < 0L) {
            throw new DapException("Slice: last index < 0");
        }
        if (this.stride <= 0L) {
            throw new DapException("Slice: stride index <= 0");
        }
        if (this.first > this.last) {
            throw new DapException("Slice: first index > last");
        }
        return this;
    }

    public SliceIterator iterator() {
        return new SliceIterator(this);
    }

    public Sort getSort() {
        return this.sort;
    }

    public long getFirst() {
        return this.first;
    }

    public long getLast() {
        return this.last;
    }

    public long getStride() {
        return this.stride;
    }

    public long getMaxSize() {
        return this.size;
    }

    public void setMaxSize(long size) throws DapException {
        this.setIndices(this.first, this.last, this.stride, size);
    }

    public Slice setIndices(long first, long last, long stride) throws DapException {
        return this.setIndices(first, last, stride, -1L);
    }

    public Slice setIndices(long first, long last, long stride, long maxsize) throws DapException {
        this.first = first;
        this.last = last;
        this.stride = stride;
        this.size = maxsize;
        return this;
    }

    public Boolean isWhole() {
        return this.whole;
    }

    public Slice setWhole(Boolean tf) {
        this.whole = tf;
        return this;
    }

    public Boolean isConstrained() {
        return this.constrained;
    }

    public Slice setConstrained(Boolean tf) {
        this.constrained = tf;
        return this;
    }

    public long getCount() {
        assert (this.first != -1L && this.stride != -1L && this.last != -1L);
        long count = this.last + 1L - this.first;
        count = count + this.stride - 1L;
        return count /= this.stride;
    }

    public long getStop() {
        assert (this.last != -1L);
        return this.last + 1L;
    }

    public boolean equals(Object o) {
        if (!(o instanceof Slice)) {
            return false;
        }
        Slice other = (Slice)o;
        if (other == this) {
            return true;
        }
        return other.getFirst() == this.getFirst() && other.getLast() == this.getLast() && other.getStride() == this.getStride();
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean withbrackets) {
        String ssize;
        StringBuilder buf = new StringBuilder();
        String slast = this.last == -1L ? "?" : Long.toString(this.last);
        String sstride = this.stride == -1L ? "?" : Long.toString(this.stride);
        String sfirst = this.first == -1L ? "?" : Long.toString(this.first);
        String string = ssize = this.size == -1L ? "?" : Long.toString(this.size);
        if (withbrackets) {
            buf.append("[");
        }
        if (this.stride == 1L) {
            buf.append(String.format("%s:%s", sfirst, slast));
        } else {
            buf.append(String.format("%s:%s:%s", sfirst, sstride, slast));
        }
        buf.append("|");
        buf.append(ssize);
        if (withbrackets) {
            buf.append("]");
        }
        return buf.toString();
    }

    public String toConstraintString() throws DapException {
        assert (this.first != -1L && this.stride != -1L && this.last != -1L);
        if (this.stride == 1L) {
            if (this.first == this.last) {
                return String.format("[%d]", this.first);
            }
            return String.format("[%d:%d]", this.first, this.last);
        }
        return String.format("[%d:%d:%d]", this.first, this.stride, this.last);
    }

    public boolean isContiguous() {
        return this.stride == 1L;
    }

    public List<Slice> getContiguous() {
        ArrayList<Slice> contig = new ArrayList<Slice>();
        if (this.stride == 1L) {
            contig.add(this);
        }
        return contig;
    }

    public static Slice compose(Slice target, Slice src) throws DapException {
        long sr_stride = target.getStride() * src.getStride();
        long sr_first = Slice.MAP(target, src.getFirst());
        long lastx = Slice.MAP(target, src.getLast());
        long sr_last = target.getLast() < lastx ? target.getLast() : lastx;
        return new Slice(sr_first, sr_last, sr_stride, sr_last + 1L).finish();
    }

    static long MAP(Slice target, long i) throws DapException {
        if (i < 0L) {
            throw new DapException("Slice.compose: i must be >= 0");
        }
        if (i > target.getLast()) {
            throw new DapException("i must be <= last");
        }
        return target.getFirst() + i * target.getStride();
    }

    public static enum Sort {
        Single,
        Multi;

    }
}

