/*
 * Decompiled with CFR 0.152.
 */
package dap4.core.dmr;

import dap4.core.dmr.DapNode;
import dap4.core.util.DapException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DapXML
extends DapNode {
    NodeType nodetype = null;
    String prefix = null;
    List<DapXML> elements = new ArrayList<DapXML>();
    Map<String, DapXML> xmlattributes = new HashMap<String, DapXML>();
    String value = null;
    String text = null;

    public DapXML() {
    }

    public DapXML(NodeType nodetype, String fullname) {
        super(null);
        this.setNodeType(nodetype);
        int i = fullname.indexOf(58);
        if (i >= 0) {
            this.prefix = fullname.substring(i);
            fullname = fullname.substring(i + 1, fullname.length());
            if (this.prefix.length() == 0) {
                this.prefix = null;
            }
        }
        this.setShortName(fullname);
    }

    public NodeType getNodeType() {
        return this.nodetype;
    }

    public void setNodeType(NodeType nodetype) {
        this.nodetype = nodetype;
        this.prefix = null;
        String fullname = null;
        switch (nodetype) {
            case COMMENT: {
                fullname = "#comment";
                break;
            }
            case TEXT: {
                fullname = "#text";
                break;
            }
            case DOCUMENT: {
                fullname = "#document";
                break;
            }
            case CDATA: {
                fullname = "#cdata-section";
                break;
            }
        }
        this.setShortName(fullname);
    }

    public String getLocalName() {
        return this.getShortName();
    }

    public void setLocalName(String localname) {
        this.setShortName(localname);
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    @Override
    public DapXML getParent() {
        return (DapXML)super.getParent();
    }

    public List<DapXML> getElements() {
        return this.elements;
    }

    public void addElement(DapXML child) {
        if (this.elements == null) {
            this.elements = new ArrayList<DapXML>();
        }
        this.elements.add(child);
    }

    public Map<String, DapXML> getXMLAttributes() {
        return this.xmlattributes;
    }

    public void addXMLAttribute(DapXML attr) throws DapException {
        if (this.xmlattributes == null) {
            this.xmlattributes = new HashMap<String, DapXML>();
        }
        if (this.xmlattributes.containsKey(attr.getShortName())) {
            throw new DapException("DapXML: attempt to add duplicate xml attribute: " + attr.getShortName());
        }
        this.xmlattributes.put(attr.getShortName(), attr);
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public static enum NodeType {
        ELEMENT(1),
        ATTRIBUTE(2),
        TEXT(3),
        CDATA(4),
        COMMENT(8),
        DOCUMENT(9),
        DOCTYPE(10);

        private short w3c_nodetype;

        private NodeType(short nodetype) {
            this.w3c_nodetype = nodetype;
        }

        public short getW3CNodeType() {
            return this.w3c_nodetype;
        }
    }
}

