/*
 * Decompiled with CFR 0.152.
 */
package dap4.core.util;

import dap4.core.util.DapException;
import dap4.core.util.Slice;
import java.util.ArrayList;
import java.util.List;

public class MultiSlice
extends Slice {
    protected List<Slice> slices;
    protected long count = -1L;

    public MultiSlice(List<Slice> slices) throws DapException {
        this.sort = Slice.Sort.Multi;
        this.slices = slices;
        this.finish();
        this.first = -1L;
        this.last = -1L;
        this.stride = -1L;
        this.size = -1L;
        for (int i = 0; i < this.slices.size(); ++i) {
            Slice s = this.slices.get(i);
            this.first = this.first < 0L ? s.getFirst() : Math.min(this.first, s.getFirst());
            this.last = Math.max(this.last, s.getLast());
            this.stride = Math.max(this.stride, s.getStride());
            this.size = Math.max(this.size, s.getMaxSize());
        }
        this.whole = false;
        this.constrained = true;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (o instanceof Slice) {
            try {
                ArrayList<Slice> tmp = new ArrayList<Slice>();
                tmp.add((Slice)o);
                o = new MultiSlice(tmp);
            }
            catch (DapException de) {
                throw new IllegalArgumentException();
            }
        }
        if (!(o instanceof MultiSlice)) {
            return false;
        }
        Slice other = (Slice)o;
        return other.getFirst() == this.getFirst() && other.getLast() == this.getLast() && other.getStride() == this.getStride();
    }

    @Override
    public int hashCode() {
        long accum = 0L;
        for (int i = 0; i < this.slices.size(); ++i) {
            Slice s = this.slices.get(i);
            accum += (long)(s.hashCode() * i);
        }
        return (int)accum;
    }

    @Override
    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("[");
        for (int i = 0; i < this.slices.size(); ++i) {
            if (i > 0) {
                buf.append(",");
            }
            buf.append(this.slices.get(i).toString(false));
        }
        buf.append("]");
        return buf.toString();
    }

    @Override
    public Slice finish() throws DapException {
        int i;
        this.size = -1L;
        for (i = 0; i < this.slices.size(); ++i) {
            Slice sl = this.slices.get(i);
            assert (sl.getSort() == Slice.Sort.Single);
            sl.finish();
            if (this.size >= sl.getMaxSize()) continue;
            this.size = sl.getMaxSize();
        }
        if (this.size < 0L) {
            throw new DapException("Cannot compute multislice size");
        }
        for (i = 0; i < this.slices.size(); ++i) {
            this.slices.get(i).setMaxSize(this.size);
        }
        this.count = 0L;
        for (i = 0; i < this.slices.size(); ++i) {
            this.count += this.slices.get(i).getCount();
        }
        return this;
    }

    public List<Slice> getSlices() {
        return this.slices;
    }

    @Override
    public long getCount() {
        return this.count;
    }

    @Override
    public void setMaxSize(long size) throws DapException {
        for (int i = 0; i < this.slices.size(); ++i) {
            this.slices.get(i).setMaxSize(size);
        }
    }

    @Override
    public boolean isContiguous() {
        for (int i = 0; i < this.slices.size(); ++i) {
            if (this.slices.get(i).getStride() == 1L) continue;
            return false;
        }
        return true;
    }

    @Override
    public List<Slice> getContiguous() {
        ArrayList<Slice> contig = new ArrayList<Slice>();
        if (this.isContiguous()) {
            contig.addAll(this.slices);
        }
        return contig;
    }
}

