/*
 * Decompiled with CFR 0.152.
 */
package dap4.core.dmr;

import dap4.core.dmr.DapAtomicVariable;
import dap4.core.dmr.DapAttribute;
import dap4.core.dmr.DapAttributeSet;
import dap4.core.dmr.DapDataset;
import dap4.core.dmr.DapDimension;
import dap4.core.dmr.DapEnum;
import dap4.core.dmr.DapGrid;
import dap4.core.dmr.DapGroup;
import dap4.core.dmr.DapMap;
import dap4.core.dmr.DapOtherXML;
import dap4.core.dmr.DapSequence;
import dap4.core.dmr.DapStructure;
import dap4.core.dmr.DapType;
import dap4.core.dmr.DapXML;
import dap4.core.util.DapException;
import dap4.core.util.DapSort;
import dap4.core.util.Escape;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class DapNode {
    protected DapSort sort = null;
    protected int index;
    protected String shortname = null;
    protected String escapedname = null;
    protected DapNode parent = null;
    protected DapDataset dataset = null;
    protected String fqn = null;
    protected Map<String, DapAttribute> attributes = null;

    public DapNode() {
        if (this instanceof DapAtomicVariable) {
            this.sort = DapSort.ATOMICVARIABLE;
        } else if (this instanceof DapSequence) {
            this.sort = DapSort.SEQUENCE;
        } else if (this instanceof DapStructure) {
            this.sort = DapSort.STRUCTURE;
        } else if (this instanceof DapOtherXML) {
            this.sort = DapSort.OTHERXML;
        } else if (this instanceof DapAttributeSet) {
            this.sort = DapSort.ATTRIBUTESET;
        } else if (this instanceof DapAttribute) {
            this.sort = DapSort.ATTRIBUTE;
        } else if (this instanceof DapDataset) {
            this.sort = DapSort.DATASET;
        } else if (this instanceof DapGroup) {
            this.sort = DapSort.GROUP;
        } else if (this instanceof DapDimension) {
            this.sort = DapSort.DIMENSION;
        } else if (this instanceof DapEnum) {
            this.sort = DapSort.ENUMERATION;
        } else if (this instanceof DapGrid) {
            this.sort = DapSort.GRID;
        } else if (this instanceof DapXML) {
            this.sort = DapSort.XML;
        } else if (this instanceof DapEnum) {
            this.sort = DapSort.ENUMERATION;
        } else if (this instanceof DapMap) {
            this.sort = DapSort.MAP;
        } else if (this instanceof DapType) {
            this.sort = DapSort.TYPE;
        } else assert (false) : "Internal error";
    }

    public DapNode(String shortname) {
        this();
        this.setShortName(shortname);
    }

    public Map<String, DapAttribute> getAttributes() {
        if (this.attributes == null) {
            this.attributes = new HashMap<String, DapAttribute>();
        }
        return this.attributes;
    }

    public void setAttributes(Map<String, DapAttribute> alist) {
        this.attributes = alist;
    }

    public synchronized DapAttribute setAttribute(DapAttribute attr) throws DapException {
        if (this.attributes == null) {
            this.attributes = new HashMap<String, DapAttribute>();
        }
        DapAttribute old = this.attributes.get(attr.getShortName());
        this.attributes.put(attr.getShortName(), attr);
        attr.setParent(this);
        return old;
    }

    public synchronized void addAttribute(DapAttribute attr) throws DapException {
        String name = attr.getShortName();
        if (this.attributes == null) {
            this.attributes = new HashMap<String, DapAttribute>();
        }
        if (this.attributes.containsKey(name)) {
            throw new DapException("Attempt to add duplicate attribute: " + attr.getShortName());
        }
        this.setAttribute(attr);
    }

    public synchronized void removeAttribute(DapAttribute attr) throws DapException {
        if (this.attributes == null) {
            return;
        }
        String name = attr.getShortName();
        if (this.attributes.containsKey(name)) {
            this.attributes.remove(name);
        }
    }

    public synchronized DapAttribute findAttribute(String name) {
        return this.attributes.get(name);
    }

    public DapSort getSort() {
        return this.sort;
    }

    public void setSort(DapSort sort) {
        this.sort = sort;
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public DapDataset getDataset() {
        return this.dataset;
    }

    public void setDataset(DapDataset dataset) {
        this.dataset = dataset;
        if (dataset != null && this != dataset) {
            dataset.addNode(this);
        }
    }

    public DapGroup getGroup() {
        DapNode group;
        if (this.sort == DapSort.DATASET) {
            return null;
        }
        for (group = this.parent; group != null; group = group.getParent()) {
            switch (group.getSort()) {
                case DATASET: 
                case GROUP: {
                    return (DapGroup)group;
                }
            }
        }
        return (DapGroup)group;
    }

    public DapNode getContainer() {
        DapNode container;
        for (container = this.parent; container != null; container = container.getParent()) {
            switch (container.getSort()) {
                case DATASET: 
                case GROUP: 
                case STRUCTURE: 
                case GRID: 
                case SEQUENCE: {
                    return container;
                }
            }
        }
        return container;
    }

    public DapNode getParent() {
        return this.parent;
    }

    public void setParent(DapNode parent) {
        this.parent = parent;
    }

    public String getShortName() {
        return this.shortname;
    }

    public void setShortName(String shortname) {
        this.shortname = shortname;
        this.escapedname = null;
        this.fqn = null;
    }

    public String getEscapedShortName() {
        if (this.escapedname == null) {
            this.escapedname = Escape.backslashEscape(this.getShortName(), null);
        }
        return this.escapedname;
    }

    public String getFQN() {
        if (this.fqn == null) {
            this.fqn = this.computefqn();
        }
        assert (this.fqn.length() > 0 || this.getSort() == DapSort.DATASET);
        return this.fqn;
    }

    public List<DapNode> getPath() {
        ArrayList<DapNode> path = new ArrayList<DapNode>();
        DapNode current = this;
        while (true) {
            path.add(0, current);
            if (current.getParent() == null) break;
            current = current.getParent();
        }
        return path;
    }

    public List<DapNode> getContainerPath() {
        ArrayList<DapNode> path = new ArrayList<DapNode>();
        DapNode current = this.getContainer();
        while (true) {
            path.add(0, current);
            if (current.getContainer() == null) break;
            current = current.getContainer();
        }
        return path;
    }

    public List<DapGroup> getGroupPath() {
        ArrayList<DapGroup> path = new ArrayList<DapGroup>();
        DapNode current = this;
        while (true) {
            if (current.getSort() == DapSort.GROUP || current.getSort() == DapSort.DATASET) {
                path.add(0, (DapGroup)current);
            }
            if (current.getContainer() == null) break;
            current = current.getContainer();
        }
        return path;
    }

    String computefqn() {
        List<DapNode> path = this.getPath();
        StringBuilder fqn = new StringBuilder();
        DapNode parent = path.get(0);
        for (int i = 1; i < path.size(); ++i) {
            DapNode current = path.get(i);
            switch (parent.getSort()) {
                case DATASET: 
                case GROUP: {
                    fqn.append('/');
                    fqn.append(current.getEscapedShortName());
                    break;
                }
                case STRUCTURE: 
                case ENUMERATION: {
                    fqn.append('.');
                    fqn.append(current.getEscapedShortName());
                    break;
                }
                default: {
                    assert (false) : "Illegal FQN parent";
                    break;
                }
            }
            parent = current;
        }
        return fqn.toString();
    }

    public boolean isTopLevel() {
        return this.parent == null || this.parent.getSort() == DapSort.DATASET || this.parent.getSort() == DapSort.GROUP;
    }

    public String toString() {
        String sortname = this.sort == null ? "undefined" : this.sort.name();
        String name = null;
        if (name == null) {
            name = this.getShortName();
        }
        if (name == null) {
            name = "?";
        }
        return sortname + "::" + name;
    }
}

